/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mtj.internal.jmunit.ui.part.MethodStubsSelectionButtonGroup;
import org.eclipse.mtj.internal.ui.util.PixelConverter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LayoutUtil {
    public static Control createEmptySpace(Composite parent, int span) {
        Label label = new Label(parent, 16384);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.horizontalIndent = 0;
        gd.widthHint = 0;
        gd.heightHint = 0;
        label.setLayoutData((Object)gd);
        return label;
    }

    public static void doDefaultLayout(Composite parent, MethodStubsSelectionButtonGroup[] editors, boolean labelOnTop) {
        LayoutUtil.doDefaultLayout(parent, editors, labelOnTop, 0, 0, 0, 0);
    }

    public static void doDefaultLayout(Composite parent, MethodStubsSelectionButtonGroup[] editors, boolean labelOnTop, int minWidth, int minHeight) {
        LayoutUtil.doDefaultLayout(parent, editors, labelOnTop, minWidth, minHeight, 0, 0);
    }

    public static void doDefaultLayout(Composite parent, MethodStubsSelectionButtonGroup[] editors, boolean labelOnTop, int minWidth, int minHeight, int marginWidth, int marginHeight) {
        int nCulumns = LayoutUtil.getNumberOfColumns(editors);
        Control[][] controls = new Control[editors.length][];
        int i = 0;
        while (i < editors.length) {
            controls[i] = editors[i].doFillIntoGrid(parent, nCulumns);
            ++i;
        }
        if (labelOnTop) {
            LayoutUtil.modifyLabelSpans(controls, --nCulumns);
        }
        GridLayout layout = new GridLayout();
        if (marginWidth != -1) {
            layout.marginWidth = marginWidth;
        }
        if (marginHeight != -1) {
            layout.marginHeight = marginHeight;
        }
        layout.numColumns = nCulumns;
        parent.setLayout((Layout)layout);
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static int getNumberOfColumns(MethodStubsSelectionButtonGroup[] editors) {
        int columnCount = 0;
        MethodStubsSelectionButtonGroup[] methodStubsSelectionButtonGroupArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            MethodStubsSelectionButtonGroup editor = methodStubsSelectionButtonGroupArray[n2];
            columnCount = Math.max(editor.getNumberOfControls(), columnCount);
            ++n2;
        }
        return columnCount;
    }

    public static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = LayoutUtil.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    public static void setHorizontalIndent(Control control, int horizontalIndent) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).horizontalIndent = horizontalIndent;
        }
    }

    public static void setHorizontalSpan(Control control, int span) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).horizontalSpan = span;
        } else if (span != 1) {
            GridData gd = new GridData();
            gd.horizontalSpan = span;
            control.setLayoutData((Object)gd);
        }
    }

    public static void setWidthHint(Control control, int widthHint) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).widthHint = widthHint;
        }
    }

    private static void modifyLabelSpans(Control[][] controls, int nCulumns) {
        Control[][] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control[] control = controlArray[n2];
            LayoutUtil.setHorizontalSpan(control[0], nCulumns);
            ++n2;
        }
    }
}

