/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui;

import java.util.Set;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.sdk.device.DeviceMatchCache;
import org.eclipse.mtj.internal.core.sdk.device.IDeviceMatchCache;
import org.eclipse.mtj.internal.core.sdk.device.IDeviceMatcher;
import org.eclipse.mtj.internal.ui.dialog.DeviceMatchDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceMatcher
implements IDeviceMatcher {
    private IDevice device = null;
    private String configName = null;
    protected boolean saveMatch = false;

    private IDevice matchDevice(final String configurationName, final String deviceGroup, final String deviceName, final Set<String> existingConfigNames) {
        try {
            Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                public void run() {
                    DeviceMatchDialog dialog = new DeviceMatchDialog(Display.getDefault().getActiveShell());
                    dialog.setConfigurationName(configurationName);
                    dialog.setDeviceGroup(deviceGroup);
                    dialog.setDeviceName(deviceName);
                    dialog.setExistingConfigNames(existingConfigNames);
                    if (dialog.open() == 0) {
                        DeviceMatcher.this.device = dialog.getSelectedDevice();
                        DeviceMatcher.this.saveMatch = dialog.getToggleState();
                        DeviceMatcher.this.configName = dialog.getConfigurationName();
                    }
                }
            });
        }
        catch (SWTException e) {
            e.printStackTrace();
        }
        if (this.device != null && this.saveMatch) {
            IDeviceMatchCache cache = DeviceMatchCache.getInstance();
            cache.saveInCache(cache.createKey(deviceGroup, deviceName), cache.createValue(this.device));
        }
        return this.device;
    }

    public IDevice match(String deviceGroup, String deviceName) {
        return this.matchDevice(null, deviceGroup, deviceName, null);
    }

    public String[] match(String configurationName, String deviceGroup, String deviceName, Set<String> existingConfigNames) {
        this.device = this.matchDevice(configurationName, deviceGroup, deviceName, existingConfigNames);
        if (this.device != null) {
            return new String[]{this.configName, this.device.getSDKName(), this.device.getName()};
        }
        return null;
    }
}

