/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistry;
import org.eclipse.mtj.internal.core.launching.midp.ota.OTAServer;
import org.eclipse.mtj.internal.core.sdk.device.DeviceRegistry;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJLabelProvider;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.util.PluginPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJUIPlugin
extends AbstractUIPlugin {
    private static MTJUIPlugin plugin;
    private Map<ColorCacheKey, Resource> colorCache;
    private IPreferenceStore corePreferenceStore;
    private FormToolkit dialogsFormToolkit;
    private FormColors fFormColors;
    private MTJLabelProvider fLabelProvider;
    private Map<FontCacheKey, Resource> fontCache;
    private IDocumentProvider fTextFileDocumentProvider;

    public static void displayError(Shell shell, int severity, int code, String title, String message, Throwable exception) {
        String id = MTJUIPlugin.getDefault().getBundle().getSymbolicName();
        Status status = new Status(severity, id, code, message, exception);
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public static IWorkbenchPage getActivePage() {
        return MTJUIPlugin.getDefault().internalGetActivePage();
    }

    public static Shell getActiveWindowShell() {
        MTJUIPlugin plugin = MTJUIPlugin.getDefault();
        IWorkbenchWindow activeWindow = plugin.getWorkbench().getActiveWorkbenchWindow();
        return activeWindow.getShell();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = MTJUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return MTJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Color getColor(Display display, int red, int green, int blue) {
        Map<ColorCacheKey, Resource> cache = MTJUIPlugin.getDefault().colorCache;
        ColorCacheKey key = new ColorCacheKey(display, red, green, blue);
        Color color = (Color)cache.get(key);
        if (color == null) {
            color = new Color((Device)display, red, green, blue);
            cache.put(key, (Resource)color);
        }
        return color;
    }

    public static IPersistentPreferenceStore getCoreProjectPreferenceStore(IProject context) {
        ProjectScope projectScope = new ProjectScope(context);
        return new ScopedPreferenceStore((IScopeContext)projectScope, "org.eclipse.mtj.core");
    }

    public static MTJUIPlugin getDefault() {
        return plugin;
    }

    public static IDialogSettings getDialogSettings(IDialogSettings dialogSettings, String sectionName) {
        IDialogSettings settings = dialogSettings.getSection(sectionName);
        if (settings == null) {
            settings = dialogSettings.addNewSection(sectionName);
        }
        return settings;
    }

    public static IDialogSettings getDialogSettings(String sectionName) {
        return MTJUIPlugin.getDialogSettings(MTJUIPlugin.getDefault().getDialogSettings(), sectionName);
    }

    public static Font getFont(Display display, String name, int height, int style) {
        Map<FontCacheKey, Resource> cache = MTJUIPlugin.getDefault().fontCache;
        FontCacheKey key = new FontCacheKey(display, name, height, style);
        Font font = (Font)cache.get(key);
        if (font == null) {
            font = new Font((Device)display, name, height, style);
            cache.put(key, (Resource)font);
        }
        return font;
    }

    public static String getPluginId() {
        return MTJUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static IWorkspace getWorkspace() {
        return MTJCore.getWorkspace();
    }

    public static boolean isFullNameModeEnabled() {
        return false;
    }

    public MTJUIPlugin() {
        if (plugin == null) {
            plugin = this;
        }
        this.colorCache = new HashMap<ColorCacheKey, Resource>();
        this.fontCache = new HashMap<FontCacheKey, Resource>();
    }

    public IPreferenceStore getCorePreferenceStore() {
        if (this.corePreferenceStore == null) {
            this.corePreferenceStore = new PluginPreferenceStore(MTJCore.getPluginId());
        }
        return this.corePreferenceStore;
    }

    public static GridData buildGridData(int horizontalAlignment, int verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = horizontalAlignment;
        gridData.verticalAlignment = verticalAlignment;
        gridData.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        gridData.grabExcessVerticalSpace = grabExcessVerticalSpace;
        return gridData;
    }

    public static GridData buildGridData(boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace) {
        return MTJUIPlugin.buildGridData(16384, 0x1000000, grabExcessHorizontalSpace, grabExcessVerticalSpace);
    }

    public FormToolkit getDialogsFormToolkit() {
        if (this.dialogsFormToolkit == null) {
            FormColors colors = new FormColors(Display.getCurrent());
            colors.setBackground(null);
            colors.setForeground(null);
            this.dialogsFormToolkit = new FormToolkit(colors);
        }
        return this.dialogsFormToolkit;
    }

    public FormColors getFormColors(Display display) {
        if (this.fFormColors == null) {
            this.fFormColors = new FormColors(display);
            this.fFormColors.markShared();
        }
        return this.fFormColors;
    }

    public MTJLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new MTJLabelProvider();
        }
        return this.fLabelProvider;
    }

    public synchronized IDocumentProvider getTextFileDocumentProvider() {
        if (this.fTextFileDocumentProvider == null) {
            this.fTextFileDocumentProvider = new TextFileDocumentProvider();
        }
        return this.fTextFileDocumentProvider;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        for (Color color : this.colorCache.values()) {
            color.dispose();
        }
        for (Font font : this.fontCache.values()) {
            font.dispose();
        }
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        boolean startAtStart = iPreferenceStore.getBoolean("ota_start_at_start");
        if (startAtStart) {
            this.startupOTAServer();
        }
        this.verifyDevices();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.dialogsFormToolkit != null) {
                this.dialogsFormToolkit.dispose();
                this.dialogsFormToolkit = null;
            }
        }
        finally {
            super.stop(context);
        }
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    private void startupOTAServer() {
        try {
            OTAServer.getInstance().start();
        }
        catch (Exception e) {
            MTJLogger.log((int)4, (String)"startupOTAServer", (Throwable)e);
        }
    }

    private void verifyDevices() {
        boolean toRemove;
        List sdkWithInvalidReferences;
        IDeviceRegistry deviceRegistry = MTJCore.getDeviceRegistry();
        if (deviceRegistry instanceof DeviceRegistry && !(sdkWithInvalidReferences = ((DeviceRegistry)deviceRegistry).getInvalidSDKNames()).isEmpty() && (toRemove = this.showWarningInvalidReferences(sdkWithInvalidReferences))) {
            try {
                ((DeviceRegistry)deviceRegistry).updateReferences();
            }
            catch (PersistenceException e) {
                MTJLogger.log((int)4, (Throwable)e);
            }
            catch (TransformerException e) {
                MTJLogger.log((int)4, (Throwable)e);
            }
            catch (IOException e) {
                MTJLogger.log((int)4, (Throwable)e);
            }
        }
    }

    private boolean showWarningInvalidReferences(final List<String> sdkWithInvalidReferences) {
        final Display display = Display.getDefault();
        final AtomicBoolean result = new AtomicBoolean(false);
        display.syncExec(new Runnable(){

            public void run() {
                String message = String.valueOf(MTJUIMessages.MTJUIPlugin_missing_devices_text) + "\n";
                for (String removedSDK : sdkWithInvalidReferences) {
                    message = String.valueOf(message) + "\n" + removedSDK;
                }
                message = String.valueOf(message) + "\n\n" + MTJUIMessages.MTJUIPlugin_remove_invalid_references_question;
                result.set(MessageDialog.openQuestion((Shell)display.getActiveShell(), (String)MTJUIMessages.MTJUIPlugin_missing_devices_dialog_title, (String)message));
            }
        });
        return result.get();
    }

    private static class ColorCacheKey {
        private int blue;
        private Display display;
        private int green;
        private int red;

        private ColorCacheKey(Display display, int red, int green, int blue) {
            this.display = display;
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public boolean equals(Object obj) {
            boolean equals = false;
            if (obj instanceof ColorCacheKey) {
                ColorCacheKey other = (ColorCacheKey)obj;
                equals = this.display.equals(other.display) && this.red == other.red && this.green == other.green && this.blue == other.blue;
            }
            return equals;
        }

        public int hashCode() {
            return this.display.hashCode() ^ this.red << 24 ^ this.green << 16 ^ this.blue;
        }
    }

    private static class FontCacheKey {
        private Display display;
        private int height;
        private String name;
        private int style;

        private FontCacheKey(Display display, String name, int height, int style) {
            this.display = display;
            this.name = name;
            this.height = height;
            this.style = style;
        }

        public boolean equals(Object obj) {
            boolean equals = false;
            if (obj instanceof FontCacheKey) {
                FontCacheKey other = (FontCacheKey)obj;
                equals = this.display.equals(other.display) && this.name.equals(other.name) && this.height == other.height && this.style == other.style;
            }
            return equals;
        }

        public int hashCode() {
            return this.display.hashCode() ^ this.name.hashCode() ^ this.height << 16 ^ this.style;
        }
    }
}

