/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.midp.J2MENature;
import org.eclipse.mtj.core.project.midp.ProjectConvertionException;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.project.midp.MTJProjectConverter;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.actions.AbstractJavaProjectAction;
import org.eclipse.mtj.internal.ui.dialog.DeviceSelectDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConvertToMidletProjectAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            try {
                IMIDPDevice device = this.getDevice(shell);
                if (device == null) {
                    MessageDialog.openError((Shell)shell, (String)MTJUIMessages.ConvertToMidletProjectAction_error_no_device_title, (String)MTJUIMessages.ConvertToMidletProjectAction_error_no_device_message);
                } else {
                    this.convertSelectedProjects(device, (IStructuredSelection)selection, shell);
                }
            }
            catch (PersistenceException e) {
                this.handleException(e, shell);
            }
        }
        return null;
    }

    private void convertSelectedProjects(IMIDPDevice device, IStructuredSelection selection, Shell shell) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        try {
            try {
                dialog.open();
                IProgressMonitor monitor = dialog.getProgressMonitor();
                MTJCore.getWorkspace().run(this.getRunnable(device, selection), monitor);
            }
            catch (CoreException e) {
                this.handleException(e, shell);
                dialog.close();
            }
        }
        finally {
            dialog.close();
        }
    }

    private IMIDPDevice getDevice(Shell shell) throws PersistenceException {
        DeviceSelectDialog dialog;
        IMIDPDevice device = null;
        if (MTJCore.getDeviceRegistry().getDeviceCount() > 0 && (dialog = new DeviceSelectDialog(shell)).open() == 0) {
            device = (IMIDPDevice)dialog.getSelectedDevice();
        }
        return device;
    }

    private IWorkspaceRunnable getRunnable(final IMIDPDevice def, final IStructuredSelection selection) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(MTJUIMessages.ConvertToMidletProjectAction_convert_taskname, selection.size());
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    IJavaProject javaProject = AbstractJavaProjectAction.getJavaProject(iter.next());
                    if (javaProject != null) {
                        monitor.setTaskName(MTJUIMessages.bind((String)MTJUIMessages.ConvertToMidletProjectAction_convert_taskname2, (Object)javaProject.getElementName()));
                        boolean hasMtjNature = false;
                        boolean hasEclipseMeNature = false;
                        IProject project = javaProject.getProject();
                        try {
                            hasMtjNature = J2MENature.hasMtjCoreNature((IProject)project);
                        }
                        catch (CoreException coreException) {}
                        try {
                            hasEclipseMeNature = project.hasNature("eclipseme.core.nature");
                        }
                        catch (CoreException coreException) {}
                        if (!hasMtjNature) {
                            if (hasEclipseMeNature) {
                                try {
                                    MTJProjectConverter.getInstance().convertEclipseMeProject(project, def, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                }
                                catch (ProjectConvertionException e) {
                                    MTJStatusHandler.throwCoreException((int)4, (int)-999, (String)e.getMessage());
                                }
                            } else {
                                try {
                                    MTJProjectConverter.getInstance().convertJavaProject(javaProject, def, monitor);
                                }
                                catch (InvocationTargetException e1) {
                                    MTJStatusHandler.throwCoreException((int)4, (int)-999, (Throwable)e1.getTargetException());
                                }
                                catch (InterruptedException e1) {
                                    MTJStatusHandler.throwCoreException((int)4, (int)-999, (Throwable)e1);
                                }
                            }
                        }
                    }
                    monitor.worked(1);
                }
                monitor.done();
            }
        };
    }

    private void handleException(Throwable e, Shell shell) {
        MTJLogger.log((int)4, (Throwable)e);
        MessageDialog.openError((Shell)shell, (String)MTJUIMessages.ConvertToMidletProjectAction_handleException_title, (String)e.toString());
    }
}

