/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.mtj.core.MTJCore;

public class WorkbenchRunnableAdapter
implements IRunnableWithProgress,
IThreadListener {
    private ISchedulingRule rule;
    private boolean transfer = false;
    private IWorkspaceRunnable workspaceRunnable;

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable) {
        this(runnable, (ISchedulingRule)MTJCore.getWorkspace().getRoot());
    }

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable, ISchedulingRule rule) {
        this.workspaceRunnable = runnable;
        this.rule = rule;
    }

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable, ISchedulingRule rule, boolean transfer) {
        this.workspaceRunnable = runnable;
        this.rule = rule;
        this.transfer = transfer;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.rule;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            JavaCore.run((IWorkspaceRunnable)this.workspaceRunnable, (ISchedulingRule)this.rule, (IProgressMonitor)monitor);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    public void runAsUserJob(String name, final Object jobFamiliy) {
        Job job = new Job(name){

            public boolean belongsTo(Object family) {
                return jobFamiliy == family;
            }

            /*
             * Loose catch block
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        WorkbenchRunnableAdapter.this.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof CoreException) {
                            IStatus iStatus = ((CoreException)cause).getStatus();
                            monitor.done();
                            return iStatus;
                        }
                        Status status = new Status(4, "org.eclipse.mtj.ui", cause.getMessage(), cause);
                        monitor.done();
                        return status;
                    }
                    catch (InterruptedException interruptedException) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(this.rule);
        job.setUser(true);
        job.schedule();
    }

    public void threadChange(Thread thread) {
        if (this.transfer) {
            Job.getJobManager().transferRule(this.rule, thread);
        }
    }
}

