/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.devices;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceFinder;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.DeviceFinder;
import org.eclipse.mtj.internal.core.sdk.device.IFoundDevicesList;
import org.eclipse.mtj.internal.core.sdk.device.SimpleFoundDevicesList;
import org.eclipse.mtj.internal.core.sdk.device.midp.Configuration;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.devices.DeviceTableLabelProvider;
import org.eclipse.mtj.internal.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.internal.ui.viewers.TableViewerConfiguration;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class DeviceImportWizardPage
extends WizardPage {
    public static final String NAME = "deviceImportPage";
    private static final TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(MTJUIMessages.DeviceImportWizardPage_import_columnInfo, 10.0f, null), new TableColumnInfo(MTJUIMessages.DeviceImportWizardPage_group_columnInfo, 22.5f, null), new TableColumnInfo(MTJUIMessages.DeviceImportWizardPage_name_columnInfo, 22.5f, null), new TableColumnInfo(MTJUIMessages.DeviceImportWizardPage_canfiguration_columnInfo, 22.5f, null), new TableColumnInfo(MTJUIMessages.DeviceImportWizardPage_profile_columnInfo, 22.5f, null)};
    private static final int DEFAULT_TABLE_WIDTH = 550;
    private static final String KEY_HEIGHT = "dialogHeight";
    private static final String KEY_WIDTH = "dialogWidth";
    private static final Object[] NO_ELEMENTS = new Object[0];
    private Button browseButton;
    private Button deselectAllButton;
    private UpdatingFoundDevicesList deviceList;
    private CheckboxTableViewer deviceViewer;
    private String lastRootText;
    private Button refreshButton;
    private Text rootText;
    private Button selectAllButton;
    private IDeviceFinder deviceFinder = DeviceFinder.getInstance();

    public DeviceImportWizardPage() {
        super(NAME, MTJUIMessages.DeviceImportWizardPage_title, null);
        this.setDescription(MTJUIMessages.DeviceImportWizardPage_SelectDirectoryMessage);
        this.setImageDescriptor(MTJUIPluginImages.DESC_IMPORT_DEV);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        parent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                DeviceImportWizardPage.this.storeSize();
            }
        });
        this.setControl((Control)composite);
        this.addRootDirectoryControls(composite);
        this.addDeviceSelectorControls(composite);
        Point size = this.retrieveSize();
        if (size != null) {
            composite.setSize(size);
        }
    }

    public IDevice[] getSelectedDevices() {
        Object[] checkedElements = this.deviceViewer.getCheckedElements();
        IDevice[] devices = new IDevice[checkedElements.length];
        System.arraycopy(checkedElements, 0, devices, 0, checkedElements.length);
        return devices;
    }

    public void searchRoots(String[] searchRootsList) {
        this.rootText.setEnabled(false);
        this.browseButton.setEnabled(false);
        ArrayList<File> files = new ArrayList<File>();
        String[] stringArray = searchRootsList;
        int n = searchRootsList.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            File file = new File(element);
            if (file.exists()) {
                files.add(file);
            }
            ++n2;
        }
        File[] searchFiles = files.toArray(new File[files.size()]);
        this.updateDevices(searchFiles);
    }

    private void addDeviceSelectorControls(Composite parent) {
        Label devicesLabel = new Label(parent, 0);
        devicesLabel.setText(MTJUIMessages.DeviceImportWizardPage_deviceSelector_label_text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        devicesLabel.setLayoutData((Object)gd);
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = 550;
        this.deviceViewer = this.createTableViewer(parent);
        this.deviceViewer.getTable().setLayoutData((Object)gridData);
        this.addDeviceTableButtons(parent);
    }

    private void addDeviceTableButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.selectAllButton = new Button(composite, 8);
        this.selectAllButton.setText(MTJUIMessages.DeviceImportWizardPage_selectAllButton_label_text);
        this.selectAllButton.setLayoutData((Object)new GridData(768));
        this.selectAllButton.setEnabled(false);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceImportWizardPage.this.deviceViewer.setAllChecked(true);
                DeviceImportWizardPage.this.updateFinishButton();
            }
        });
        this.deselectAllButton = new Button(composite, 8);
        this.deselectAllButton.setText(MTJUIMessages.DeviceImportWizardPage_deselectAllButton_label_text);
        this.deselectAllButton.setLayoutData((Object)new GridData(768));
        this.deselectAllButton.setEnabled(false);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceImportWizardPage.this.deviceViewer.setAllChecked(false);
                DeviceImportWizardPage.this.updateFinishButton();
            }
        });
        this.refreshButton = new Button(composite, 8);
        this.refreshButton.setText(MTJUIMessages.DeviceImportWizardPage_refreshButton_label_text);
        this.refreshButton.setLayoutData((Object)new GridData(768));
        this.refreshButton.setEnabled(false);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceImportWizardPage.this.updateDevices(true);
            }
        });
    }

    private void addRootDirectoryControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(MTJUIMessages.DeviceImportWizardPage_search_directory_label_text);
        this.rootText = new Text(composite, 2048);
        this.rootText.setLayoutData((Object)new GridData(768));
        DirectoryFocusListener listener = new DirectoryFocusListener();
        this.rootText.addFocusListener((FocusListener)listener);
        this.rootText.addTraverseListener((TraverseListener)listener);
        this.rootText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeviceImportWizardPage.this.updateRefreshButton();
            }
        });
        this.browseButton = new Button(parent, 8);
        this.browseButton.setText(MTJUIMessages.DeviceImportWizardPage_browseButton_label_text);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceImportWizardPage.this.handleBrowseButton();
            }
        });
    }

    private CheckboxTableViewer createTableViewer(Composite composite) {
        int styles = 68132;
        Table table = new Table(composite, styles);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        CheckboxTableViewer viewer = new CheckboxTableViewer(table);
        viewer.setContentProvider((IContentProvider)new TableContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DeviceTableLabelProvider());
        this.deviceList = new UpdatingFoundDevicesList();
        viewer.setInput((Object)this.deviceList);
        viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                DeviceImportWizardPage.this.updateFinishButton();
            }
        });
        IDialogSettings viewerSettings = MTJUIPlugin.getDialogSettings(this.getDialogSettings(), "viewerSettings");
        TableViewerConfiguration viewerConfiguration = new TableViewerConfiguration(viewerSettings, 550, COLUMN_INFO, 1);
        viewerConfiguration.configure((TableViewer)viewer);
        return viewer;
    }

    private IRunnableWithProgress getDeviceSearchRunnable(final File[] searchDirectories) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    DeviceImportWizardPage.this.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            DeviceImportWizardPage.this.deviceList.clear();
                        }
                    });
                    File[] fileArray = searchDirectories;
                    int n = searchDirectories.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File element = fileArray[n2];
                        DeviceImportWizardPage.this.deviceList.addDevices(DeviceImportWizardPage.this.deviceFinder.findDevices(element, monitor));
                        ++n2;
                    }
                    DeviceImportWizardPage.this.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            DeviceImportWizardPage.this.deviceViewer.refresh();
                            DeviceImportWizardPage.this.deviceViewer.setAllChecked(true);
                        }
                    });
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    private void handleBrowseButton() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(MTJUIMessages.DeviceImportWizardPage_handleBrowseButton_message);
        String directory = dialog.open();
        if (directory != null) {
            this.rootText.setText(directory);
            this.updateDevices(true);
        }
    }

    private void handleDeviceSearchException(Throwable t) {
        MTJUIPlugin.displayError(this.getShell(), 4, -999, MTJUIMessages.DeviceImportWizardPage_handleDeviceSearchException_title, MTJUIMessages.DeviceImportWizardPage_handleDeviceSearchException_message, t);
        MTJLogger.log((int)4, (String)t.getMessage(), (Throwable)t);
    }

    private Point retrieveSize() {
        Point size = null;
        IDialogSettings settings = this.getDialogSettings();
        if (settings.get(KEY_WIDTH) != null) {
            size = new Point(settings.getInt(KEY_WIDTH), settings.getInt(KEY_HEIGHT));
        }
        return size;
    }

    private void storeSize() {
        IDialogSettings settings = this.getDialogSettings();
        Point size = this.getControl().getSize();
        settings.put(KEY_WIDTH, size.x);
        settings.put(KEY_HEIGHT, size.y);
    }

    private void updateDevices(boolean force) {
        String newText = this.rootText.getText().trim();
        if (force || !newText.equals(this.lastRootText)) {
            this.lastRootText = newText;
            File searchDirectory = new File(newText);
            if (searchDirectory.exists()) {
                this.updateDevices(searchDirectory);
            }
        }
        this.updateSelectButtons();
        this.updateFinishButton();
    }

    private void updateDevices(File searchDirectory) {
        this.updateDevices(new File[]{searchDirectory});
    }

    private void updateDevices(File[] searchDirectories) {
        IRunnableWithProgress runnable = this.getDeviceSearchRunnable(searchDirectories);
        try {
            this.getContainer().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            this.handleDeviceSearchException(e.getCause());
        }
        catch (InterruptedException interruptedException) {}
    }

    private void updateFinishButton() {
        this.setPageComplete(this.deviceViewer.getCheckedElements().length > 0);
    }

    private void updateRefreshButton() {
        String rootDir = this.rootText.getText().trim();
        File searchDirectory = new File(rootDir);
        if (searchDirectory.exists()) {
            this.refreshButton.setEnabled(true);
        } else {
            this.refreshButton.setEnabled(false);
        }
    }

    private void updateSelectButtons() {
        UpdatingFoundDevicesList deviceList = (UpdatingFoundDevicesList)((Object)this.deviceViewer.getInput());
        int deviceAmount = deviceList.getDevices().size();
        if (deviceAmount > 0) {
            this.selectAllButton.setEnabled(true);
            this.deselectAllButton.setEnabled(true);
        } else {
            this.selectAllButton.setEnabled(false);
            this.deselectAllButton.setEnabled(false);
        }
    }

    private void updateStatusMessage(IStatus[] status) {
        if (status == null || status.length < 1) {
            this.setMessage(this.getDescription());
        } else {
            this.setMessage(status[0].getMessage(), status[0].getSeverity());
        }
    }

    private class DirectoryFocusListener
    implements FocusListener,
    TraverseListener {
        private DirectoryFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            DeviceImportWizardPage.this.updateDevices(false);
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 4) {
                e.doit = false;
                DeviceImportWizardPage.this.updateDevices(false);
            }
        }
    }

    private static class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return inputElement == null ? NO_ELEMENTS : ((IFoundDevicesList)inputElement).getDevices().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdatingFoundDevicesList
    extends SimpleFoundDevicesList {
        private UpdatingFoundDevicesList() {
        }

        public void addDevices(List<IDevice> devices) {
            super.addDevices(devices);
            this.refreshViewer();
        }

        public void clear() {
            super.clear();
            this.refreshViewer();
        }

        private void refreshViewer() {
            final IStatus[] status = this.validateDevices();
            DeviceImportWizardPage.this.getContainer().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    DeviceImportWizardPage.this.deviceViewer.refresh();
                    DeviceImportWizardPage.this.updateStatusMessage(status);
                }
            });
        }

        private IStatus[] validateDevices() {
            for (IDevice device : DeviceImportWizardPage.this.deviceList.getDevices()) {
                boolean requiresPreverifier;
                IMIDPDevice midpDevice = (IMIDPDevice)device;
                boolean bl = requiresPreverifier = midpDevice.getCLDCAPI().getVersion().compareTo(Configuration.CLDC_18.getVersion()) < 0;
                if (!requiresPreverifier || midpDevice.getPreverifier() != null || MTJCore.getDeviceRegistry().getDefaultPreferifier() != null) continue;
                return new Status[]{new Status(2, "org.eclipse.mtj.ui", MTJUIMessages.DeviceImportWizardPage_InvalidPreverifierMessage)};
            }
            return null;
        }
    }
}

