/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.dialog;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.ClassPathDetector;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteProject;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ArchiveUtils;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ProjectImporter;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ProjectImporterMessage;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ProjectRecord;
import org.eclipse.mtj.internal.ui.wizards.importer.netbeans.NetBeansProjectImporter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class CodeSampleProjectImport {
    protected static void loadEclipseProjectToWorkSpace(IPath projectPath) throws CoreException {
        final IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription(projectPath.append("/.project"));
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
        if (project.exists()) {
            System.err.println("Build.commandLine.projectExists" + project.getName());
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.create(description, monitor);
                project.open(0, monitor);
                project.build(6, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)ResourcesPlugin.getWorkspace().getRoot()), 0, null);
    }

    public static void importNetbeansProject(final IPath projectPath, IProgressMonitor monitor) throws CoreException {
        if (projectPath == null) {
            return;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                NetBeansProjectImporter importer = new NetBeansProjectImporter();
                ProjectRecord[] foundProjects = importer.searchProjectsFromDirectory(new File(projectPath.toFile().getAbsolutePath()), monitor);
                System.out.println("foundProjects!! " + foundProjects.length);
                if (foundProjects.length <= 0) {
                    throw new CoreException((IStatus)new Status(1, "org.eclipse.mtj.ui", "Project type not supported by MTJ."));
                }
                int i = 0;
                while (i < foundProjects.length) {
                    try {
                        CodeSampleProjectImport.createExistingProject(foundProjects[i], importer, monitor);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)ResourcesPlugin.getWorkspace().getRoot()), 0, null);
    }

    private static boolean createExistingProject(final ProjectRecord record, final ProjectImporter importer, final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Shell shell = new Shell(Display.getDefault());
                IOverwriteQuery overwriteQuery = new IOverwriteQuery(){

                    public String queryOverwrite(String pathString) {
                        return "YES";
                    }
                };
                String projectName = record.getProjectName();
                IWorkspace workspace = MTJCore.getWorkspace();
                IProject project = workspace.getRoot().getProject(projectName);
                IProjectDescription newProjectDescription = workspace.newProjectDescription(projectName);
                try {
                    ImportOperation operation;
                    monitor.beginTask(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_CreateProjectTask, (Object)record.getProjectName()), 100);
                    JavaCapabilityConfigurationPage.createProject((IProject)project, (URI)newProjectDescription.getLocationURI(), (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    if (record.getProvider() == null) {
                        Path locationPath = new Path(new File(record.getProjectRoot()).getAbsolutePath());
                        File importSource = locationPath.toFile();
                        if (!Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                            List filesToImport = FileSystemStructureProvider.INSTANCE.getChildren((Object)importSource);
                            operation = new ImportOperation(project.getFullPath(), (Object)importSource, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, overwriteQuery, filesToImport);
                            operation.setContext(shell);
                            operation.setOverwriteResources(true);
                            operation.setCreateContainerStructure(false);
                            operation.run((IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            monitor.worked(50);
                            importer.projectCreated(record, project, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                        }
                    } else {
                        Object root = ArchiveUtils.getChild(record.getProvider(), record.getProvider().getRoot(), record.getProjectRoot());
                        List fileSystemObjects = record.getProvider().getChildren(root);
                        int stripLevel = ArchiveUtils.guessStripLevel(record.getProjectRoot());
                        record.getProvider().setStrip(stripLevel);
                        operation = new ImportOperation(project.getFullPath(), record.getProvider().getRoot(), (IImportStructureProvider)record.getProvider(), overwriteQuery, fileSystemObjects);
                        operation.setContext(shell);
                        operation.run(monitor);
                        importer.projectCreated(record, project, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    }
                    monitor.setTaskName(ProjectImporterMessage.WizardProjectsImportPage_ProcessingMessage);
                    project.refreshLocal(2, null);
                    ClassPathDetector detector = new ClassPathDetector(project, null);
                    JavaCapabilityConfigurationPage javaPropPage = new JavaCapabilityConfigurationPage();
                    javaPropPage.init(JavaCore.create((IProject)project), detector.getOutputLocation(), detector.getClasspath(), false);
                    javaPropPage.configureJavaProject(null);
                    CodeSampleProjectImport.removeJ2SELibraries(javaPropPage.getJavaProject(), monitor);
                    IDevice device = importer.getProjectDevice(record);
                    MidletSuiteFactory.MidletSuiteCreationRunnable builder = MidletSuiteFactory.getMidletSuiteCreationRunnable((IProject)project, (IJavaProject)javaPropPage.getJavaProject(), (IMIDPDevice)((IMIDPDevice)device), (String)MidletSuiteProject.getDefaultJadFileName((IProject)project));
                    builder.run(monitor);
                    project.build(6, monitor);
                    monitor.done();
                }
                catch (CoreException coreException) {
                    try {
                        project.delete(true, monitor);
                    }
                    catch (CoreException coreException2) {}
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        return true;
    }

    private static void removeJ2SELibraries(IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < entries.length) {
            if (!CodeSampleProjectImport.isJ2SELibraryEntry(entries[i])) {
                list.add(entries[i]);
            }
            ++i;
        }
        entries = list.toArray(new IClasspathEntry[list.size()]);
        javaProject.setRawClasspath(entries, monitor);
    }

    private static boolean isJ2SELibraryEntry(IClasspathEntry entry) {
        boolean isJ2SEEntry = false;
        if (entry.getEntryKind() == 1) {
            if (entry.getPath().lastSegment().equals("JRE_LIB")) {
                isJ2SEEntry = true;
            }
        } else if (entry.getEntryKind() == 5 && entry.getPath().lastSegment().equals("org.eclipse.jdt.launching.JRE_CONTAINER")) {
            isJ2SEEntry = true;
        }
        return isJ2SEEntry;
    }
}

