/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.dialog;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.internal.core.security.meep.MEEPPermissionsProvider;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MEEPSecurityPermissionsDialog
extends Dialog {
    private static final RGB ERROR_FOREGROUND_RGB = new RGB(255, 0, 0);
    private static final CharsetEncoder ASCII_CHARSET_ENCODER = Charset.forName("US-ASCII").newEncoder();
    private Map<RGB, Color> colors = new HashMap<RGB, Color>();
    private Button okButton;
    private ComboViewer permissionsCombo;
    private Text nameField;
    private Button useNullName;
    private Text actionsField;
    private Button useNullActions;
    private Label errorLabel;
    private ParameterDefinition nameDefinition;
    private ParameterDefinition actionsDefinition;
    private MEEPPermissionsProvider.PermissionsFactory permissionsFactory;
    private MEEPPermissionsProvider.PermissionDefinition permission;
    private MEEPPermissionsProvider.PermissionDefinition selectPermission;

    private MEEPSecurityPermissionsDialog(Shell parentShell, MEEPPermissionsProvider permissionsProvider, Collection<String> existingPermissions, String permissionToEdit) {
        super(parentShell);
        this.setShellStyle(0x10860 | MEEPSecurityPermissionsDialog.getDefaultOrientation());
        if (permissionToEdit != null) {
            existingPermissions = new HashSet<String>(existingPermissions);
            existingPermissions.remove(permissionToEdit);
        }
        this.permissionsFactory = permissionsProvider.getPermissionsFactory(existingPermissions);
        this.selectPermission = permissionToEdit == null ? null : this.permissionsFactory.getPermission(permissionToEdit);
    }

    public static MEEPPermissionsProvider.PermissionDefinition getPermission(Shell parentShell, MEEPPermissionsProvider permissionsProvider, Collection<String> existingPermissions, String permissionToEdit) {
        MEEPSecurityPermissionsDialog dialog = new MEEPSecurityPermissionsDialog(parentShell, permissionsProvider, existingPermissions, permissionToEdit);
        dialog.open();
        return dialog.permission;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (Color color : MEEPSecurityPermissionsDialog.this.colors.values()) {
                    color.dispose();
                }
            }
        });
        newShell.setText(this.selectPermission == null ? MTJUIMessages.MEEPSecurityPermissionsDialog_titleAdd : MTJUIMessages.MEEPSecurityPermissionsDialog_titleEdit);
    }

    protected Control createButtonBar(Composite parent) {
        return this.createButtonBar(parent, true);
    }

    private Composite createButtonBar(Composite parent, boolean createButtons) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.marginBottom = 5;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        if (createButtons) {
            this.createButtonsForButtonBar(composite);
        }
        return composite;
    }

    private Composite createContainerForControlWithLabel(Composite parent, int numColumns) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = false;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(4, 4, true, true));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Color getColor(RGB rgb) {
        Map<RGB, Color> map = this.colors;
        synchronized (map) {
            Color color = this.colors.get(rgb);
            if (color == null) {
                color = new Color((Device)Display.getCurrent(), rgb);
                this.colors.put(rgb, color);
            }
            return color;
        }
    }

    protected void handleShellCloseEvent() {
        this.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        MEEPSecurityPermissionsDialog.applyDialogFont((Control)container);
        this.initializeDialogUnits((Control)container);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).applyTo(container);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite permissionsContainer = this.createContainerForControlWithLabel(container, 1);
        Label lblMeepPermissionClass = new Label(permissionsContainer, 0);
        lblMeepPermissionClass.setText(MTJUIMessages.MEEPSecurityPermissionsDialog_permissionLabel);
        lblMeepPermissionClass.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.permissionsCombo = new ComboViewer(permissionsContainer, 2060);
        this.permissionsCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.permissionsCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        MEEPPermissionsProvider.PermissionDescriptor[] availablePermissions = this.permissionsFactory.getAvailablePermissions();
        this.permissionsCombo.setInput((Object)availablePermissions);
        this.permissionsCombo.setSelection((ISelection)new StructuredSelection((Object)availablePermissions[0]));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(Math.max(400, this.permissionsCombo.getCombo().computeSize((int)-1, (int)-1).x), -1).applyTo((Control)this.permissionsCombo.getCombo());
        Composite nameContainer = this.createContainerForControlWithLabel(container, 2);
        this.nameDefinition = new ParameterDefinition(nameContainer, MTJUIMessages.MEEPSecurityPermissionsDialog_targetLabel, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MEEPSecurityPermissionsDialog.this.updateNameAndActions();
            }
        });
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.nameDefinition);
        this.nameField = new Text(nameContainer, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)this.nameField);
        this.useNullName = new Button(nameContainer, 32);
        this.useNullName.setText(MTJUIMessages.MEEPSecurityPermissionsDialog_useNull);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)this.useNullName);
        Composite actionsContainer = this.createContainerForControlWithLabel(container, 2);
        this.actionsDefinition = new ParameterDefinition(actionsContainer, MTJUIMessages.MEEPSecurityPermissionsDialog_actionLabel, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MEEPPermissionsProvider.PermissionDescriptor permissionDescr;
                if (!MEEPSecurityPermissionsDialog.this.actionsDefinition.useParameter() && !(permissionDescr = MEEPSecurityPermissionsDialog.this.getSelectedDescriptor()).actionsCanBeOptional(true)) {
                    MEEPSecurityPermissionsDialog.this.nameDefinition.setUseParameter(false);
                }
                MEEPSecurityPermissionsDialog.this.updateNameAndActions();
            }
        });
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.actionsDefinition);
        this.actionsField = new Text(actionsContainer, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)this.actionsField);
        this.useNullActions = new Button(actionsContainer, 32);
        this.useNullActions.setText(MTJUIMessages.MEEPSecurityPermissionsDialog_useNull);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)this.useNullActions);
        this.errorLabel = new Label(container, 0);
        this.errorLabel.setForeground(this.getColor(ERROR_FOREGROUND_RGB));
        this.errorLabel.setText(" ");
        this.errorLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        MEEPPermissionsProvider.PermissionDescriptor descriptor = null;
        if (this.selectPermission != null) {
            descriptor = this.permissionsFactory.getDescriptor(this.selectPermission);
            this.permissionsCombo.setSelection((ISelection)new StructuredSelection((Object)descriptor));
            if (this.selectPermission.getNumberOfParameters() > 0) {
                String nameValue;
                if (descriptor.nameCanBeOptional()) {
                    this.nameDefinition.setUseParameter(true);
                }
                this.useNullName.setSelection((nameValue = this.selectPermission.getName()) == null);
                if (nameValue != null) {
                    this.nameField.setText(nameValue);
                }
                if (this.selectPermission.getNumberOfParameters() > 1) {
                    String actionsValue;
                    if (descriptor.actionsCanBeOptional(true)) {
                        this.actionsDefinition.setUseParameter(true);
                    }
                    this.useNullActions.setSelection((actionsValue = this.selectPermission.getActions()) == null);
                    if (actionsValue != null) {
                        this.actionsField.setText(actionsValue);
                    }
                }
            }
        }
        this.nameField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.text != null && !ASCII_CHARSET_ENCODER.canEncode(e.text)) {
                    e.doit = false;
                }
            }
        });
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MEEPSecurityPermissionsDialog.this.updateOKButton();
            }
        });
        this.nameField.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = MTJUIMessages.MEEPSecurityPermissionsDialog_targetFieldAccessibleName;
            }
        });
        this.actionsField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.text != null && !ASCII_CHARSET_ENCODER.canEncode(e.text)) {
                    e.doit = false;
                }
            }
        });
        this.actionsField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MEEPSecurityPermissionsDialog.this.updateOKButton();
            }
        });
        this.actionsField.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = MTJUIMessages.MEEPSecurityPermissionsDialog_actionFieldAccessibleName;
            }
        });
        this.permissionsCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MEEPSecurityPermissionsDialog.this.updateNameAndActions();
            }
        });
        this.permissionsCombo.getCombo().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = MTJUIMessages.MEEPSecurityPermissionsDialog_permissionComboAccessibleName;
            }
        });
        this.useNullName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MEEPSecurityPermissionsDialog.this.updateNameAndActions();
            }
        });
        this.useNullActions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MEEPSecurityPermissionsDialog.this.updateNameAndActions();
            }
        });
        return container;
    }

    protected Control createContents(Composite parent) {
        try {
            Control control = super.createContents(parent);
            return control;
        }
        finally {
            this.updateNameAndActions();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.permission = this.permissionsFactory.getPermission(this.getSelectedDescriptor(), this.getNameValue(), this.getActionsValue(), this.getNumberOfParameters());
        super.okPressed();
    }

    protected void cancelPressed() {
        this.permission = null;
        super.cancelPressed();
    }

    private void updateNameAndActions() {
        MEEPPermissionsProvider.PermissionDescriptor permissionDescr = this.getSelectedDescriptor();
        this.nameDefinition.setEnabled(permissionDescr.supportsName());
        this.nameDefinition.setOptional(permissionDescr.supportsName() && permissionDescr.nameCanBeOptional());
        this.actionsDefinition.setEnabled(permissionDescr.supportsAction() && this.nameDefinition.useParameter());
        this.actionsDefinition.setOptional(permissionDescr.supportsAction() && this.nameDefinition.useParameter() && permissionDescr.actionsCanBeOptional(this.nameDefinition.useParameter()));
        this.useNullName.setEnabled(permissionDescr != null && permissionDescr.supportsName() && this.nameDefinition.useParameter());
        this.nameField.setEnabled(this.useNullName.isEnabled() && !this.useNullName.getSelection());
        this.useNullActions.setEnabled(permissionDescr != null && permissionDescr.supportsAction() && this.actionsDefinition.useParameter());
        this.actionsField.setEnabled(this.useNullActions.isEnabled() && !this.useNullActions.getSelection());
        this.updateOKButton();
    }

    private MEEPPermissionsProvider.PermissionDescriptor getSelectedDescriptor() {
        return (MEEPPermissionsProvider.PermissionDescriptor)((StructuredSelection)this.permissionsCombo.getSelection()).getFirstElement();
    }

    private String getNameValue() {
        return this.getParameterValue(this.useNullName, this.nameField, false);
    }

    private String getActionsValue() {
        return this.getParameterValue(this.useNullActions, this.actionsField, true);
    }

    private String getParameterValue(Button useNull, Text parameterField, boolean trim) {
        if (useNull.getSelection()) {
            return null;
        }
        String result = parameterField.getText();
        if (trim) {
            result = result.trim();
        }
        return result;
    }

    private int getNumberOfParameters() {
        int result = 0;
        if (this.nameDefinition.useParameter()) {
            ++result;
            if (this.actionsDefinition.useParameter()) {
                ++result;
            }
        }
        return result;
    }

    private void updateOKButton() {
        boolean enable;
        MEEPPermissionsProvider.PermissionDescriptor permissionDescr = this.getSelectedDescriptor();
        if (permissionDescr == null) {
            enable = false;
        } else {
            String errorMsg;
            MEEPPermissionsProvider.PermissionError valid = this.permissionsFactory.validatePermission(permissionDescr, this.getNameValue(), this.getActionsValue(), this.getNumberOfParameters());
            switch (valid) {
                case INVALID_NAME: {
                    errorMsg = MTJUIMessages.MEEPSecurityPermissionsDialog_Error_InvalidName;
                    break;
                }
                case INVALID_ACTION: {
                    errorMsg = MTJUIMessages.MEEPSecurityPermissionsDialog_Error_InvalidAction;
                    break;
                }
                case UNDEFINED_NAME: {
                    errorMsg = MTJUIMessages.MEEPSecurityPermissionsDialog_Error_UndefinedName;
                    break;
                }
                case UNDEFINED_ACTION: {
                    errorMsg = MTJUIMessages.MEEPSecurityPermissionsDialog_Error_UndefinedAction;
                    break;
                }
                case CONFLICT: {
                    errorMsg = MTJUIMessages.MEEPSecurityPermissionsDialog_Error_Conflict;
                    break;
                }
                default: {
                    errorMsg = null;
                }
            }
            boolean bl = enable = errorMsg == null;
            if (!enable) {
                this.errorLabel.setText(errorMsg);
            }
        }
        if (enable) {
            this.errorLabel.setText(" ");
        }
        this.errorLabel.getParent().layout();
        this.okButton.setEnabled(enable);
    }

    private static class ParameterDefinition
    extends Composite {
        private Button useParameter;
        private Label parameterLabel;

        public ParameterDefinition(Composite parent, String labelText, SelectionListener actionListener) {
            super(parent, 0);
            GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(2).applyTo((Composite)this);
            this.useParameter = new Button((Composite)this, 32);
            this.useParameter.setText(labelText);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).exclude(true).applyTo((Control)this.useParameter);
            if (actionListener != null) {
                this.useParameter.addSelectionListener(actionListener);
            }
            this.parameterLabel = new Label((Composite)this, 0);
            this.parameterLabel.setText(labelText);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).exclude(false).applyTo((Control)this.parameterLabel);
        }

        public boolean useParameter() {
            return this.isEnabled() && (((GridData)this.useParameter.getLayoutData()).exclude || this.useParameter.getSelection());
        }

        public void setUseParameter(boolean value) {
            this.useParameter.setSelection(value);
        }

        public void setOptional(boolean optional) {
            this.useParameter.setVisible(optional);
            ((GridData)this.useParameter.getLayoutData()).exclude = !optional;
            this.parameterLabel.setVisible(!optional);
            ((GridData)this.parameterLabel.getLayoutData()).exclude = optional;
            this.getParent().layout();
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.parameterLabel.setEnabled(enabled);
            this.useParameter.setEnabled(enabled);
        }
    }
}

