/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.dialog;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SigningPasswordsDialog
extends TitleAreaDialog {
    private String dialogMessage;
    private String keyPassword;
    private Text keyPasswordText;
    private String keystorePassword;
    private Text keystorePasswordText;
    private Button okButton;

    public SigningPasswordsDialog(Shell parentShell, IProject project) {
        super(parentShell);
        try {
            IProjectDescription description = project.getDescription();
            String projectName = description.getName();
            this.dialogMessage = NLS.bind((String)MTJUIMessages.SigningPasswordsDialog_message1, (Object)projectName);
        }
        catch (CoreException coreException) {
            this.dialogMessage = MTJUIMessages.SigningPasswordsDialog_message2;
        }
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeyPassword(String value) {
        this.keyPassword = value;
    }

    public void setKeystorePassword(String value) {
        this.keystorePassword = value;
    }

    private GridData buildGridData(int nFill, boolean bGrab, int nSpan) {
        GridData gd = new GridData();
        gd.horizontalAlignment = nFill;
        gd.grabExcessHorizontalSpace = bGrab;
        gd.horizontalSpan = nSpan;
        return gd;
    }

    private void updateButtons() {
        if (this.okButton == null || this.keystorePasswordText == null || this.keyPasswordText == null) {
            return;
        }
        String value = this.keystorePasswordText.getText();
        if (value == null) {
            this.okButton.setEnabled(false);
            return;
        }
        if (value.length() == 0) {
            this.okButton.setEnabled(false);
            return;
        }
        value = this.keyPasswordText.getText();
        if (value == null) {
            this.okButton.setEnabled(false);
            return;
        }
        if (value.length() == 0) {
            this.okButton.setEnabled(false);
            return;
        }
        this.okButton.setEnabled(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(MTJUIMessages.SigningPasswordsDialog_title);
        this.setMessage(this.dialogMessage, 1);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite((Composite)super.createDialogArea(parent), 0);
        dialogArea.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText(MTJUIMessages.SigningPasswordsDialog_keystore_password_label);
        this.keystorePasswordText = new Text(dialogArea, 0x400804);
        this.keystorePasswordText.setLayoutData((Object)this.buildGridData(4, true, 1));
        if (this.keystorePassword != null) {
            this.keystorePasswordText.setText(this.keystorePassword);
        }
        label = new Label(dialogArea, 0);
        label.setText(MTJUIMessages.SigningPasswordsDialog_kew_password_label);
        this.keyPasswordText = new Text(dialogArea, 0x400804);
        this.keyPasswordText.setLayoutData((Object)this.buildGridData(4, true, 1));
        if (this.keyPassword != null) {
            this.keyPasswordText.setText(this.keyPassword);
        }
        this.keystorePasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SigningPasswordsDialog.this.updateButtons();
            }
        });
        this.keyPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SigningPasswordsDialog.this.updateButtons();
            }
        });
        this.updateButtons();
        return dialogArea;
    }

    protected void okPressed() {
        this.keystorePassword = this.keystorePasswordText.getText();
        this.keyPassword = this.keyPasswordText.getText();
        super.okPressed();
    }
}

