/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mtj.internal.core.IBaseModel;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editor.IContextPart;
import org.eclipse.mtj.internal.ui.editor.MTJDetails;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJSection;
import org.eclipse.mtj.internal.ui.editors.FormLayoutFactory;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class MTJFormPage
extends FormPage {
    private Control lastFocusControl = null;
    private boolean newStyleHeader = true;
    private boolean stale = false;

    public MTJFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public MTJFormPage(FormEditor editor, String id, String title, boolean newStyleHeader) {
        this(editor, id, title);
        this.newStyleHeader = newStyleHeader;
    }

    public void addLastFocusListeners(Composite composite) {
        Control[] controls;
        Control[] controlArray = controls = composite.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Text || control instanceof Button || control instanceof Combo || control instanceof CCombo || control instanceof Tree || control instanceof Table || control instanceof Spinner || control instanceof Link || control instanceof List || control instanceof TabFolder || control instanceof CTabFolder || control instanceof Hyperlink || control instanceof FilteredTree) {
                this.addLastFocusListener(control);
            }
            if (control instanceof Composite) {
                this.addLastFocusListeners((Composite)control);
            }
            ++n2;
        }
    }

    public void alignSectionHeaders(Section masterSection, Section detailsSection) {
        detailsSection.descriptionVerticalSpacing += masterSection.getTextClientHeightDifference();
    }

    public void cancelEdit() {
        IFormPart[] parts;
        IFormPart[] iFormPartArray = parts = this.getManagedForm().getParts();
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPart part = iFormPartArray[n2];
            if (part instanceof IContextPart) {
                ((IContextPart)part).cancelEdit();
            }
            ++n2;
        }
    }

    public boolean canCopy(ISelection selection) {
        AbstractFormPart focusPart = this.getFocusSection();
        if (focusPart != null) {
            if (focusPart instanceof MTJSection) {
                return ((MTJSection)focusPart).canCopy(selection);
            }
            if (focusPart instanceof MTJDetails) {
                return ((MTJDetails)focusPart).canCopy(selection);
            }
        }
        return false;
    }

    public boolean canCut(ISelection selection) {
        AbstractFormPart focusPart = this.getFocusSection();
        if (focusPart != null) {
            if (focusPart instanceof MTJSection) {
                return ((MTJSection)focusPart).canCut(selection);
            }
            if (focusPart instanceof MTJDetails) {
                return ((MTJDetails)focusPart).canCut(selection);
            }
        }
        return false;
    }

    public boolean canPaste(Clipboard clipboard) {
        AbstractFormPart focusPart = this.getFocusSection();
        if (focusPart != null) {
            if (focusPart instanceof MTJSection) {
                return ((MTJSection)focusPart).canPaste(clipboard);
            }
            if (focusPart instanceof MTJDetails) {
                return ((MTJDetails)focusPart).canPaste(clipboard);
            }
        }
        return false;
    }

    public void contextMenuAboutToShow(IMenuManager menu) {
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IManagedForm managedForm = this.getManagedForm();
        if (managedForm != null) {
            this.addLastFocusListeners((Composite)managedForm.getForm());
        }
    }

    public Section createUISection(Composite parent, String text, String description, int style) {
        Section section = this.getManagedForm().getToolkit().createSection(parent, style);
        section.clientVerticalSpacing = 6;
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setText(text);
        section.setDescription(description);
        GridData data = new GridData(768);
        section.setLayoutData((Object)data);
        return section;
    }

    public Composite createUISectionContainer(Composite parent, int columns) {
        Composite container = this.getManagedForm().getToolkit().createComposite(parent);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, columns));
        return container;
    }

    public void dispose() {
        Menu menu;
        Control c = this.getPartControl();
        if (c != null && !c.isDisposed() && (menu = c.getMenu()) != null) {
            this.resetMenu(menu, c);
        }
        super.dispose();
    }

    public Control getLastFocusControl() {
        return this.lastFocusControl;
    }

    public IBaseModel getModel() {
        return this.getMTJEditor().getAggregateModel();
    }

    public MTJFormEditor getMTJEditor() {
        return (MTJFormEditor)this.getEditor();
    }

    public String getStackTrace(Throwable throwable) {
        StringWriter swriter = new StringWriter();
        PrintWriter pwriter = new PrintWriter(swriter);
        throwable.printStackTrace(pwriter);
        pwriter.flush();
        pwriter.close();
        return swriter.toString();
    }

    public boolean performGlobalAction(String actionId) {
        Control focusControl = this.getFocusControl();
        if (focusControl == null) {
            return false;
        }
        if (this.canPerformDirectly(actionId, focusControl)) {
            return true;
        }
        AbstractFormPart focusPart = this.getFocusSection();
        if (focusPart != null) {
            if (focusPart instanceof MTJSection) {
                return ((MTJSection)focusPart).doGlobalAction(actionId);
            }
            if (focusPart instanceof MTJDetails) {
                return ((MTJDetails)focusPart).doGlobalAction(actionId);
            }
        }
        return false;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active && this.isStale()) {
            this.refresh();
        }
    }

    public void setLastFocusControl(Control control) {
        this.lastFocusControl = control;
    }

    public void updateFormSelection() {
        if (this.lastFocusControl != null && !this.lastFocusControl.isDisposed()) {
            this.lastFocusControl.setFocus();
        } else {
            this.setFocus();
        }
    }

    private void addLastFocusListener(final Control control) {
        control.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                MTJFormPage.this.lastFocusControl = control;
            }
        });
    }

    private AbstractFormPart getFocusSection() {
        Control focusControl = this.getFocusControl();
        if (focusControl == null) {
            return null;
        }
        Composite parent = focusControl.getParent();
        AbstractFormPart targetPart = null;
        while (parent != null) {
            Object data = parent.getData("part");
            if (data != null && data instanceof AbstractFormPart) {
                targetPart = (AbstractFormPart)data;
                break;
            }
            parent = parent.getParent();
        }
        return targetPart;
    }

    private void resetMenu(Menu menu, Control c) {
        Menu cmenu;
        if (c instanceof Composite) {
            Control[] children;
            Composite comp = (Composite)c;
            Control[] controlArray = children = comp.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                this.resetMenu(menu, element);
                ++n2;
            }
        }
        if ((cmenu = c.getMenu()) != null && cmenu.equals(menu)) {
            c.setMenu(null);
        }
    }

    protected boolean canPerformDirectly(String id, Control control) {
        if (control instanceof Text) {
            Text text = (Text)control;
            if (id.equals(ActionFactory.CUT.getId())) {
                text.cut();
                return true;
            }
            if (id.equals(ActionFactory.COPY.getId())) {
                text.copy();
                return true;
            }
            if (id.equals(ActionFactory.PASTE.getId())) {
                text.paste();
                return true;
            }
            if (id.equals(ActionFactory.SELECT_ALL.getId())) {
                text.selectAll();
                return true;
            }
            if (id.equals(ActionFactory.DELETE.getId())) {
                int count = text.getSelectionCount();
                if (count == 0) {
                    int caretPos = text.getCaretPosition();
                    text.setSelection(caretPos, caretPos + 1);
                }
                text.insert("");
                return true;
            }
        }
        return false;
    }

    protected void createFormContent(IManagedForm managedForm) {
        IFormPart[] parts;
        final ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        if (this.newStyleHeader) {
            toolkit.decorateFormHeading(form.getForm());
        }
        IToolBarManager manager = form.getToolBarManager();
        this.getMTJEditor().contributeToToolbar(manager);
        final String href = this.getHelpResource();
        if (href != null) {
            Action helpAction = new Action("help"){

                public void run() {
                    BusyIndicator.showWhile((Display)form.getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(href);
                        }
                    });
                }
            };
            helpAction.setToolTipText(MTJUIMessages.MTJFormPage_helpAction_toolTipText);
            helpAction.setImageDescriptor(MTJUIPluginImages.DESC_HELP);
            manager.add((IAction)helpAction);
        }
        IFormPart[] iFormPartArray = parts = managedForm.getParts();
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable adapter;
            IAction[] actions;
            IFormPart part = iFormPartArray[n2];
            if (part instanceof IAdaptable && (actions = (IAction[])(adapter = (IAdaptable)part).getAdapter(IAction[].class)) != null) {
                IAction[] iActionArray = actions;
                int n3 = actions.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAction action = iActionArray[n4];
                    form.getToolBarManager().add(action);
                    ++n4;
                }
            }
            ++n2;
        }
        form.updateToolBar();
    }

    protected void createFormErrorContent(IManagedForm managedForm, String errorTitle, String errorMessage) {
        this.createFormErrorContent(managedForm, errorTitle, errorMessage, null);
    }

    protected void createFormErrorContent(IManagedForm managedForm, String errorTitle, String errorMessage, Exception e) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        if (this.newStyleHeader) {
            toolkit.decorateFormHeading(form.getForm());
        }
        Composite parent = form.getBody();
        GridLayout layout = new GridLayout();
        GridData data2 = new GridData(1808);
        layout.marginWidth = 7;
        layout.marginHeight = 7;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)data2);
        form.setText(errorTitle);
        form.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        int sectionStyle = 384;
        Section messageSection = this.createUISection(parent, MTJUIMessages.MTJFormPage_messageSection_title, errorMessage, sectionStyle);
        Composite messageClient = this.createUISectionContainer((Composite)messageSection, 1);
        toolkit.paintBordersFor(messageClient);
        messageSection.setClient((Control)messageClient);
        if (e == null) {
            return;
        }
        Section detailsSection = this.createUISection(parent, MTJUIMessages.MTJFormPage_detailsSection_title, e.getMessage(), sectionStyle);
        Composite detailsClient = this.createUISectionContainer((Composite)detailsSection, 1);
        int style = 778;
        Text text = toolkit.createText(detailsClient, this.getStackTrace(e), style);
        GridData data = new GridData(768);
        data.heightHint = 160;
        data.widthHint = 200;
        text.setLayoutData((Object)data);
        toolkit.paintBordersFor(detailsClient);
        detailsSection.setClient((Control)detailsClient);
    }

    protected Control getFocusControl() {
        IManagedForm form = this.getManagedForm();
        if (form == null) {
            return null;
        }
        ScrolledForm control = form.getForm();
        if (control == null || control.isDisposed()) {
            return null;
        }
        Display display = control.getDisplay();
        Control focusControl = display.getFocusControl();
        if (focusControl == null || focusControl.isDisposed()) {
            return null;
        }
        return focusControl;
    }

    protected String getHelpResource() {
        return null;
    }

    protected boolean isStale() {
        return this.stale;
    }

    protected void markStale() {
        this.stale = true;
    }

    protected void refresh() {
        this.stale = false;
    }
}

