/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.internal.core.IBaseModel;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editor.FoldingStructureProviderFactory;
import org.eclipse.mtj.internal.ui.editor.IFoldingStructureProvider;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJProjectionViewer;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.SourceViewerConfigurationFactory;
import org.eclipse.mtj.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.mtj.internal.ui.editor.text.ColorManager;
import org.eclipse.mtj.internal.ui.editor.text.IColorManager;
import org.eclipse.mtj.internal.ui.editor.text.ReconcilingStrategy;
import org.eclipse.swt.widgets.Composite;

public abstract class MTJProjectionSourcePage
extends MTJSourcePage
implements IProjectionListener {
    private IColorManager fColorManager = ColorManager.getDefault();
    private ChangeAwareSourceViewerConfiguration fConfiguration = SourceViewerConfigurationFactory.createSourceViewerConfiguration(this, this.fColorManager);
    private IFoldingStructureProvider fFoldingStructureProvider;
    private ProjectionSupport fProjectionSupport;

    public MTJProjectionSourcePage(MTJFormEditor editor, String id, String title) {
        super(editor, id, title);
        if (this.fConfiguration != null) {
            this.setSourceViewerConfiguration((SourceViewerConfiguration)this.fConfiguration);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.createFoldingSupport(projectionViewer);
        if (this.isFoldingEnabled()) {
            projectionViewer.doOperation(19);
        }
    }

    public void dispose() {
        ((ProjectionViewer)this.getSourceViewer()).removeProjectionListener((IProjectionListener)this);
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        this.fColorManager.dispose();
        if (this.fConfiguration != null) {
            this.fConfiguration.dispose();
        }
        super.dispose();
    }

    public Object getAdapter(Class key) {
        Object adapter;
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), key)) != null) {
            return adapter;
        }
        return super.getAdapter(key);
    }

    public abstract boolean isQuickOutlineEnabled();

    public void projectionDisabled() {
        this.fFoldingStructureProvider = null;
    }

    public void projectionEnabled() {
        IBaseModel model = this.getInputContext().getModel();
        if (model instanceof IEditingModel) {
            this.fFoldingStructureProvider = FoldingStructureProviderFactory.createProvider(this, (IEditingModel)model);
            if (this.fFoldingStructureProvider != null) {
                this.fFoldingStructureProvider.initialize();
                IReconciler rec = this.getSourceViewerConfiguration().getReconciler(this.getSourceViewer());
                IReconcilingStrategy startegy = rec.getReconcilingStrategy(new String());
                if (startegy instanceof ReconcilingStrategy) {
                    ((ReconcilingStrategy)startegy).addParticipant(this.fFoldingStructureProvider);
                }
            }
        }
    }

    private void addQuickOutlineMenuEntry(IMenuManager menu) {
        if (!this.isQuickOutlineEnabled()) {
            return;
        }
        IAction quickOutlineAction = this.getAction("org.eclipse.mtj.ui.quickOutline");
        if (quickOutlineAction == null) {
            return;
        }
        menu.add(quickOutlineAction);
    }

    private void createFoldingSupport(ProjectionViewer projectionViewer) {
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.install();
        ((ProjectionViewer)this.getSourceViewer()).addProjectionListener((IProjectionListener)this);
    }

    private boolean isFoldingEnabled() {
        IPreferenceStore store = MTJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("editor.folding");
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        if (this.fConfiguration == null) {
            return false;
        }
        return this.fConfiguration.affectsTextPresentation(event) || super.affectsTextPresentation(event);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        MTJProjectionViewer viewer = new MTJProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, this.isQuickOutlineEnabled());
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer.getDecoratedViewer();
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        this.addQuickOutlineMenuEntry(menu);
        super.editorContextMenuAboutToShow(menu);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            ISourceViewer sourceViewer;
            if (this.fConfiguration != null && (sourceViewer = this.getSourceViewer()) != null) {
                this.fConfiguration.adaptToPreferenceChange(event);
            }
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
    }
}

