/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.internal.core.IBaseModel;
import org.eclipse.mtj.internal.core.text.IReconcilingParticipant;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.outline.QuickOutlinePopupDialog;
import org.eclipse.mtj.internal.ui.editor.text.IColorManager;
import org.eclipse.mtj.internal.ui.editor.text.MTJSourceInfoProvider;
import org.eclipse.mtj.internal.ui.editor.text.ReconcilingStrategy;
import org.eclipse.mtj.internal.ui.editor.text.SourceInformationProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public abstract class ChangeAwareSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private InformationPresenter fInfoPresenter;
    private InformationPresenter fOutlinePresenter;
    private MonoReconciler fReconciler;
    protected IColorManager fColorManager;
    protected MTJSourcePage sourcePage;

    public ChangeAwareSourceViewerConfiguration(MTJSourcePage page, IColorManager manager) {
        this(page, manager, (IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{MTJUIPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()}));
    }

    public ChangeAwareSourceViewerConfiguration(MTJSourcePage page, IColorManager manager, IPreferenceStore store) {
        super(store);
        this.fColorManager = manager;
        this.sourcePage = page;
    }

    public abstract void adaptToPreferenceChange(PropertyChangeEvent var1);

    public abstract boolean affectsColorPresentation(PropertyChangeEvent var1);

    public abstract boolean affectsTextPresentation(PropertyChangeEvent var1);

    public abstract void dispose();

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] registeredDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (registeredDetectors == null) {
            return null;
        }
        if (this.sourcePage == null) {
            return registeredDetectors;
        }
        IHyperlinkDetector additionalDetector = (IHyperlinkDetector)this.sourcePage.getAdapter(IHyperlinkDetector.class);
        if (additionalDetector == null) {
            return registeredDetectors;
        }
        IHyperlinkDetector[] allDetectors = new IHyperlinkDetector[registeredDetectors.length + 1];
        System.arraycopy(registeredDetectors, 0, allDetectors, 0, registeredDetectors.length);
        allDetectors[registeredDetectors.length] = additionalDetector;
        return allDetectors;
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        if (this.sourcePage == null) {
            return null;
        }
        if (this.fInfoPresenter == null && this.getInfoImplementationType() != 0) {
            String[] contentTypes;
            IInformationControlCreator icc = this.getInformationControlCreator(false);
            this.fInfoPresenter = new InformationPresenter(icc);
            this.fInfoPresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            SourceInformationProvider provider = new SourceInformationProvider(this.sourcePage, icc, this.getInfoImplementationType());
            String[] stringArray = contentTypes = this.getConfiguredContentTypes(sourceViewer);
            int n = contentTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String contentType = stringArray[n2];
                this.fInfoPresenter.setInformationProvider((IInformationProvider)provider, contentType);
                ++n2;
            }
            this.fInfoPresenter.setSizeConstraints(60, 10, true, true);
        }
        return this.fInfoPresenter;
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer) {
        String[] contentTypes;
        if (this.sourcePage == null) {
            return null;
        }
        if (this.fOutlinePresenter != null) {
            return this.fOutlinePresenter;
        }
        this.fOutlinePresenter = new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, "org.eclipse.mtj.ui.quickOutline"));
        this.fOutlinePresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.fOutlinePresenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        MTJSourceInfoProvider provider = new MTJSourceInfoProvider(this.sourcePage);
        String[] stringArray = contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String contentType = stringArray[n2];
            this.fOutlinePresenter.setInformationProvider((IInformationProvider)provider, contentType);
            ++n2;
        }
        this.fOutlinePresenter.setSizeConstraints(50, 20, true, false);
        return this.fOutlinePresenter;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        IBaseModel model;
        if (this.sourcePage != null && this.fReconciler == null && (model = this.sourcePage.getInputContext().getModel()) instanceof IReconcilingParticipant) {
            ReconcilingStrategy strategy = new ReconcilingStrategy();
            strategy.addParticipant((IReconcilingParticipant)model);
            ISortableContentOutlinePage outline = this.sourcePage.getContentOutline();
            if (outline instanceof IReconcilingParticipant) {
                strategy.addParticipant((IReconcilingParticipant)outline);
            }
            this.fReconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
            this.fReconciler.setDelay(500);
        }
        return this.fReconciler;
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                QuickOutlinePopupDialog dialog = new QuickOutlinePopupDialog(parent, shellStyle, ChangeAwareSourceViewerConfiguration.this.sourcePage, ChangeAwareSourceViewerConfiguration.this.sourcePage);
                return dialog;
            }
        };
    }

    protected int getInfoImplementationType() {
        return 0;
    }

    protected IInformationControlCreator getInformationControlCreator(boolean cutDown) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        };
    }
}

