/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.build;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.editors.build.pages.BuildPropertiesPage;
import org.eclipse.mtj.internal.ui.editors.build.pages.BuildPropertiesSourcePage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class BuildPropertiesEditor
extends FormEditor {
    private IMTJProject mtjProject;
    private List<IFormPage> pages = new ArrayList<IFormPage>();
    private IFile file;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof IFileEditorInput) {
            this.file = ((IFileEditorInput)input).getFile();
            IJavaProject javaProject = JavaCore.create((IProject)this.file.getProject());
            if (javaProject != null) {
                this.mtjProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)javaProject);
            }
        }
    }

    protected void addPages() {
        if (this.mtjProject != null) {
            try {
                MTJBuildProperties buildProperties = MTJBuildProperties.getBuildProperties((IMTJProject)this.mtjProject);
                BuildPropertiesPage buildPropertiesPage = new BuildPropertiesPage(this, buildProperties);
                this.addPage((IFormPage)buildPropertiesPage);
                BuildPropertiesSourcePage sourcePage = new BuildPropertiesSourcePage(this, buildProperties);
                this.addPage((IFormPage)sourcePage);
                this.pages.add((IFormPage)buildPropertiesPage);
                this.pages.add((IFormPage)sourcePage);
            }
            catch (PartInitException e) {
                MTJLogger.log((int)4, (Throwable)e);
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
        for (IFormPage page : this.pages) {
            page.doSave(monitor);
        }
    }

    public void doSaveAs() {
        for (IFormPage page : this.pages) {
            page.doSaveAs();
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

