/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.device.pages;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IAPI;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.ILibraryImporter;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.persistence.PersistableUtilities;
import org.eclipse.mtj.internal.core.sdk.device.AbstractMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.DeviceClasspath;
import org.eclipse.mtj.internal.core.sdk.device.midp.MIDPLibrary;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.internal.ui.viewers.TableViewerConfiguration;
import org.eclipse.mtj.ui.editors.device.AbstractDeviceEditorPage;
import org.eclipse.mtj.ui.editors.device.LibraryApiEditorDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class DeviceLibrariesEditorPage
extends AbstractDeviceEditorPage {
    private static final TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(MTJUIMessages.DeviceLibrariesEditorPage_file_columnInfo, 15.0f, null), new TableColumnInfo(MTJUIMessages.DeviceLibrariesEditorPage_path_columnInfo, 20.0f, null), new TableColumnInfo(MTJUIMessages.DeviceLibrariesEditorPage_apis_columnInfo, 15.0f, null), new TableColumnInfo(MTJUIMessages.DeviceLibrariesEditorPage_javadoc_columnInfo, 25.0f, null), new TableColumnInfo(MTJUIMessages.DeviceLibrariesEditorPage_source_columnInfo, 25.0f, null)};
    private static final int DEFAULT_TABLE_WIDTH = 650;
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final String PROP_APIS = "apis";
    private static final String PROP_FILE = "file";
    private static final String PROP_JAVADOC = "javadoc";
    private static final String PROP_PATH = "path";
    private static final String PROP_SOURCE = "source";
    private static final String[] PROPERTIES = new String[]{"file", "path", "apis", "javadoc", "source"};
    private TableViewer viewer;

    public DeviceLibrariesEditorPage(Composite parent, int style) {
        super(parent, style);
    }

    public void commitDeviceChanges() {
        Object viewerInput = this.viewer.getInput();
        if (viewerInput instanceof IDeviceClasspath) {
            this.editDevice.setClasspath((IDeviceClasspath)((DeviceClasspath)viewerInput));
        }
    }

    public String getDescription() {
        return MTJUIMessages.DeviceLibrariesEditorPage_description;
    }

    public String getTitle() {
        return MTJUIMessages.DeviceLibrariesEditorPage_title;
    }

    public void setDevice(IMIDPDevice device) {
        super.setDevice(device);
        if (device instanceof AbstractMIDPDevice) {
            IDeviceClasspath deviceClasspath = ((AbstractMIDPDevice)device).getClasspath();
            try {
                IDeviceClasspath clone = (IDeviceClasspath)PersistableUtilities.clonePersistable((IPersistable)deviceClasspath);
                this.viewer.setInput((Object)clone);
            }
            catch (PersistenceException e) {
                MTJLogger.log((int)2, (String)MTJUIMessages.DeviceLibrariesEditorPage_error_cloning_device_classpath, (Throwable)e);
            }
        }
    }

    private TableViewer createTableViewer(Composite composite) {
        int styles = 68100;
        Table table = new Table(composite, styles);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new DeviceClasspathContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LibraryLabelProvider());
        IDialogSettings viewerSettings = MTJUIPlugin.getDialogSettings("deviceLibrariesViewerSettings");
        TableViewerConfiguration viewerConfiguration = new TableViewerConfiguration(viewerSettings, 650, COLUMN_INFO, 0);
        viewerConfiguration.configure(viewer);
        viewer.setCellModifier((ICellModifier)new CellModifier());
        viewer.setColumnProperties(PROPERTIES);
        viewer.setCellEditors(new CellEditor[]{new ArchiveFileSelectionDialogCellEditor((Composite)table, false), new ArchiveFileSelectionDialogCellEditor((Composite)table, true), new APIFileSelectionDialogCellEditor((Composite)table), new JavadocAttachDialogCellEditor((Composite)table), new SourceAttachDialogCellEditor((Composite)table)});
        return viewer;
    }

    private String getApisLabel(IAPI[] iapis) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < iapis.length) {
            IAPI api = iapis[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(api);
            ++i;
        }
        return sb.toString();
    }

    private IDeviceClasspath getClasspath() {
        return (IDeviceClasspath)this.viewer.getInput();
    }

    private ILibrary getSelectedLibrary() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return selection.size() > 0 ? (ILibrary)selection.getFirstElement() : null;
    }

    private void handleAddButton() {
        File archiveFile = this.promptForArchiveFile(this.getShell(), null);
        if (archiveFile != null) {
            ILibraryImporter importer = MTJCore.getLibraryImporter((String)"org.eclipse.mtj.libraryimporter.uei");
            ILibrary library = importer.createLibraryFor(archiveFile);
            this.getClasspath().addEntry(library);
            this.viewer.refresh();
        }
    }

    private void handleRemoveButton() {
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)MTJUIMessages.DeviceLibrariesEditorPage_handleRemoveButton_dialog_title, (String)MTJUIMessages.DeviceLibrariesEditorPage_handleRemoveButton_dialog_message)) {
            ILibrary selectedLibrary = this.getSelectedLibrary();
            this.getClasspath().removeEntry(selectedLibrary);
            this.viewer.refresh();
        }
    }

    private File promptForArchiveFile(Shell shell, File currentFile) {
        String filename;
        FileDialog fileDialog = new FileDialog(shell);
        fileDialog.setFilterNames(new String[]{"*.jar;*.zip"});
        if (currentFile != null && currentFile.exists()) {
            fileDialog.setFileName(currentFile.toString());
        }
        return (filename = fileDialog.open()) == null ? null : new File(filename);
    }

    protected void addPageControls(Composite parent) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = 650;
        gridData.heightHint = 400;
        this.viewer = this.createTableViewer(parent);
        this.viewer.getTable().setLayoutData((Object)gridData);
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        buttonComposite.setLayoutData((Object)new GridData(1040));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.setText(MTJUIMessages.DeviceLibrariesEditorPage_addButton);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceLibrariesEditorPage.this.handleAddButton();
            }
        });
        final Button removeButton = new Button(buttonComposite, 8);
        removeButton.setEnabled(false);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setText(MTJUIMessages.DeviceLibrariesEditorPage_removeButton);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceLibrariesEditorPage.this.handleRemoveButton();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ILibrary selectedLibrary = DeviceLibrariesEditorPage.this.getSelectedLibrary();
                removeButton.setEnabled(selectedLibrary != null);
            }
        });
    }

    protected URL getJavadocURL(IClasspathEntry entry) {
        URL url = null;
        if (entry != null && entry.getExtraAttributes() != null) {
            IClasspathAttribute[] attributes;
            IClasspathAttribute[] iClasspathAttributeArray = attributes = entry.getExtraAttributes();
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathAttribute attribute = iClasspathAttributeArray[n2];
                if (attribute.getName().equals("javadoc_location")) {
                    try {
                        url = new URL(attribute.getValue());
                    }
                    catch (MalformedURLException e) {
                        MTJLogger.log((int)2, (String)MTJUIMessages.DeviceLibrariesEditorPage_error_getting_new_Javadoc, (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return url;
    }

    private class APIFileSelectionDialogCellEditor
    extends DialogCellEditor {
        public APIFileSelectionDialogCellEditor(Composite parent) {
            super(parent);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            LibraryApiEditorDialog dialog = new LibraryApiEditorDialog(cellEditorWindow.getShell());
            IAPI[] apis = (IAPI[])this.doGetValue();
            dialog.setAPIs(apis.toArray(new IAPI[0]));
            return dialog.open() == 0 ? dialog.getAPIs() : apis;
        }

        protected void updateContents(Object value) {
            Label defaultLabel = this.getDefaultLabel();
            if (defaultLabel == null) {
                return;
            }
            String text = "";
            if (value != null && value instanceof IMIDPAPI[]) {
                IMIDPAPI[] apis = (IMIDPAPI[])value;
                text = DeviceLibrariesEditorPage.this.getApisLabel((IAPI[])apis);
            }
            defaultLabel.setText(text);
        }
    }

    private class ArchiveFileSelectionDialogCellEditor
    extends DialogCellEditor {
        private boolean filepath;

        public ArchiveFileSelectionDialogCellEditor(Composite parent, boolean filepath) {
            super(parent);
            this.filepath = filepath;
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            File value = (File)this.doGetValue();
            return DeviceLibrariesEditorPage.this.promptForArchiveFile(cellEditorWindow.getShell(), value);
        }

        protected void updateContents(Object value) {
            Label defaultLabel = this.getDefaultLabel();
            if (defaultLabel == null) {
                return;
            }
            String text = "";
            if (value != null) {
                File file = (File)value;
                text = this.filepath ? file.getParent() : file.getName();
            }
            defaultLabel.setText(text);
        }
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            Object value = null;
            MIDPLibrary library = (MIDPLibrary)element;
            switch (this.getColumnIndex(property)) {
                case 0: 
                case 1: {
                    value = library.getLibraryFile();
                    break;
                }
                case 2: {
                    value = library.getAPIs();
                    break;
                }
                case 3: 
                case 4: {
                    value = library.toClasspathEntry();
                }
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            ILibrary library = (ILibrary)item.getData();
            switch (this.getColumnIndex(property)) {
                case 0: 
                case 1: {
                    library.setLibraryFile((File)value);
                    break;
                }
                case 2: {
                    if (!(value instanceof IAPI[])) break;
                    IAPI[] apiArray = (IAPI[])value;
                    ArrayList<IAPI> apiList = new ArrayList<IAPI>();
                    IAPI[] iAPIArray = apiArray;
                    int n = apiArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAPI element2 = iAPIArray[n2];
                        apiList.add(element2);
                        ++n2;
                    }
                    library.setApis(apiList);
                    break;
                }
                case 3: {
                    URL url = DeviceLibrariesEditorPage.this.getJavadocURL((IClasspathEntry)value);
                    library.setJavadocURL(url);
                    break;
                }
                case 4: {
                    IClasspathEntry entry = (IClasspathEntry)value;
                    library.setSourceAttachmentPath(entry.getSourceAttachmentPath());
                    library.setSourceAttachmentRootPath(entry.getSourceAttachmentRootPath());
                }
            }
            DeviceLibrariesEditorPage.this.viewer.refresh((Object)library, true);
        }

        private int getColumnIndex(String property) {
            int index = -1;
            int i = 0;
            while (i < PROPERTIES.length) {
                if (PROPERTIES[i].equals(property)) {
                    index = i;
                    break;
                }
                ++i;
            }
            return index;
        }
    }

    private static class DeviceClasspathContentProvider
    implements IStructuredContentProvider {
        private DeviceClasspathContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            IDeviceClasspath deviceClasspath;
            List libList;
            Object[] elements = NO_ELEMENTS;
            if (inputElement instanceof IDeviceClasspath && (libList = (deviceClasspath = (IDeviceClasspath)inputElement).getEntries()) != null) {
                elements = libList.toArray();
            }
            return elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class JavadocAttachDialogCellEditor
    extends DialogCellEditor {
        public JavadocAttachDialogCellEditor(Composite parent) {
            super(parent);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            Shell shell = cellEditorWindow.getShell();
            IClasspathEntry newEntry = null;
            IClasspathEntry entry = (IClasspathEntry)this.doGetValue();
            if (entry != null) {
                newEntry = BuildPathDialogAccess.configureJavadocLocation((Shell)shell, (IClasspathEntry)entry);
            }
            return newEntry;
        }

        protected void updateContents(Object value) {
            IClasspathEntry entry;
            URL url;
            Label defaultLabel = this.getDefaultLabel();
            if (defaultLabel == null) {
                return;
            }
            String text = "";
            if (value != null && (url = DeviceLibrariesEditorPage.this.getJavadocURL(entry = (IClasspathEntry)value)) != null) {
                text = url.toString();
            }
            defaultLabel.setText(text);
        }
    }

    private class LibraryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private LibraryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            MIDPLibrary library = (MIDPLibrary)element;
            String text = "";
            if (library != null) {
                switch (columnIndex) {
                    case 0: {
                        text = library.getLibraryFile().getName();
                        break;
                    }
                    case 1: {
                        text = library.getLibraryFile().getParent();
                        break;
                    }
                    case 2: {
                        text = DeviceLibrariesEditorPage.this.getApisLabel(library.getAPIs().toArray(new IAPI[0]));
                        break;
                    }
                    case 3: {
                        URL url = library.getJavadocURL();
                        if (url == null) break;
                        text = url.toString();
                        break;
                    }
                    case 4: {
                        IPath path = library.getSourceAttachmentPath();
                        if (path == null) break;
                        text = path.toString();
                    }
                }
            }
            return text;
        }
    }

    private static class SourceAttachDialogCellEditor
    extends DialogCellEditor {
        public SourceAttachDialogCellEditor(Composite parent) {
            super(parent);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            Shell shell = cellEditorWindow.getShell();
            IClasspathEntry newEntry = null;
            IClasspathEntry entry = (IClasspathEntry)this.doGetValue();
            if (entry != null) {
                newEntry = BuildPathDialogAccess.configureSourceAttachment((Shell)shell, (IClasspathEntry)entry);
            }
            return newEntry;
        }

        protected void updateContents(Object value) {
            IClasspathEntry entry;
            IPath attachPath;
            Label defaultLabel = this.getDefaultLabel();
            if (defaultLabel == null) {
                return;
            }
            String text = "";
            if (value != null && (attachPath = (entry = (IClasspathEntry)value).getSourceAttachmentPath()) != null) {
                text = attachPath.toString();
            }
            defaultLabel.setText(text);
        }
    }
}

