/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.DescriptorPropertyDescription;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.event.AddMTJRuntimeEvent;
import org.eclipse.mtj.core.project.runtime.event.IMTJRuntimeChangeListener;
import org.eclipse.mtj.core.project.runtime.event.IMTJRuntimeListChangeListener;
import org.eclipse.mtj.core.project.runtime.event.MTJRuntimeDeviceChangeEvent;
import org.eclipse.mtj.core.project.runtime.event.MTJRuntimeNameChangeEvent;
import org.eclipse.mtj.core.project.runtime.event.MTJRuntimeWorkspaceSymbolSetsChangeEvent;
import org.eclipse.mtj.core.project.runtime.event.RemoveMTJRuntimeEvent;
import org.eclipse.mtj.core.project.runtime.event.SwitchActiveMTJRuntimeEvent;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.project.runtime.MTJRuntimeListUtils;
import org.eclipse.mtj.internal.core.sdk.device.midp.Configuration;
import org.eclipse.mtj.internal.core.sdk.device.midp.PackagingModel;
import org.eclipse.mtj.internal.core.sdk.device.midp.Profile;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.configurations.ConfigManageComponent;
import org.eclipse.mtj.internal.ui.editors.FormLayoutFactory;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.internal.ui.preferences.ExtendedStringFieldEditor;
import org.eclipse.mtj.internal.ui.wizards.export.antenna.AntennaExportAction;
import org.eclipse.mtj.internal.ui.wizards.export.packaging.ExportPackageAction;
import org.eclipse.mtj.ui.editors.jad.IFilteredJADPropertyEditor;
import org.eclipse.mtj.ui.editors.jad.IManifestPreferenceStore;
import org.eclipse.mtj.ui.editors.jad.JADPropertiesEditorPage;
import org.eclipse.mtj.ui.editors.jad.ListDescriptorPropertyDescription;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverviewEditorPage
extends JADPropertiesEditorPage
implements IPropertyChangeListener,
IMTJRuntimeListChangeListener,
IMTJRuntimeChangeListener {
    public static final String PACKAGING_MODEL_PROPERTY = "PACKAGING_MODEL";
    public static final String[][] MIDLET_LIBLET_KEYS = new String[][]{{"MIDlet-Jar-URL", "LIBlet-Jar-URL"}, {"MIDlet-Name", "LIBlet-Name"}, {"MIDlet-Vendor", "LIBlet-Vendor"}, {"MIDlet-Version", "LIBlet-Version"}};
    private Map<String, FieldEditor> fieldEditorsMap = new HashMap<String, FieldEditor>();
    private Map<String, FieldEditor> libletFieldEditorsMap = new HashMap<String, FieldEditor>();
    private Map<String, FieldEditor> sharedFieldEditorsMap = new HashMap<String, FieldEditor>();
    private List<DescriptorPropertyDescription> midletDescriptors = new ArrayList<DescriptorPropertyDescription>();
    private List<DescriptorPropertyDescription> libletDescriptors = new ArrayList<DescriptorPropertyDescription>();
    private List<DescriptorPropertyDescription> sharedDescriptors = new ArrayList<DescriptorPropertyDescription>();
    private Combo packagingModelCombo;
    private Composite midletComposite;
    private Composite libletComposite;
    private Composite activePanel;
    private List<Label> propertyLabels = new ArrayList<Label>();
    private PackagingModel packagingModel = PackagingModel.MIDLET;
    private List<ActiveDeviceChangeListener> activeDeviceChangeListeners = new ArrayList<ActiveDeviceChangeListener>();
    private List<DeviceProfileChangeListener> deviceProfileChangeListeners = new ArrayList<DeviceProfileChangeListener>();
    private List<PackagingModelChangeListener> packagingModelChangeListeners = new ArrayList<PackagingModelChangeListener>();
    private static final String OVERVIEW_PAGEID = "overview";
    private ConfigManageComponent configManager;
    private String loadedJarUrl;
    private IMidletSuiteProject midletProject;
    private IJavaProject project = JavaCore.create((IProject)((JADFormEditor)this.getEditor()).getJadFile().getProject());

    public OverviewEditorPage(JADFormEditor editor) {
        super(editor, OVERVIEW_PAGEID, MTJUIMessages.OverviewEditorPage_title);
        this.midletProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.project);
    }

    public void addActiveDeviceChangeListener(ActiveDeviceChangeListener listener) {
        this.activeDeviceChangeListeners.add(listener);
    }

    public void addDeviceProfileChangeListener(DeviceProfileChangeListener listener) {
        this.deviceProfileChangeListeners.add(listener);
    }

    public void addPackagingModelChangeListener(PackagingModelChangeListener listener) {
        this.packagingModelChangeListeners.add(listener);
    }

    public void activeMTJRuntimeSwitched(SwitchActiveMTJRuntimeEvent event) {
        IDevice newActiveDevice;
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
        MTJRuntime newActiveMTJRuntime = event.getNewActiveMTJRuntime();
        IDevice iDevice = newActiveDevice = newActiveMTJRuntime == null ? null : newActiveMTJRuntime.getDevice();
        if (newActiveDevice != null) {
            for (ActiveDeviceChangeListener listener : this.activeDeviceChangeListeners) {
                listener.activeDeviceChanged(newActiveDevice);
            }
        }
    }

    public void mtjRuntimeAdded(AddMTJRuntimeEvent event) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    public void mtjRuntimeRemoved(RemoveMTJRuntimeEvent event) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    public void deviceChanged(MTJRuntimeDeviceChangeEvent event) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.isDirty()) {
            this.configManager.performCancel();
        }
        this.configManager.dispose();
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        monitor.setTaskName(this.getTitle());
        if (this.packagingModelCombo.getText().equals(PackagingModel.MIDLET.getName())) {
            for (FieldEditor element : this.libletFieldEditorsMap.values()) {
                if (!(element instanceof StringFieldEditor)) continue;
                ((StringFieldEditor)element).setStringValue("");
            }
        } else {
            for (FieldEditor element : this.fieldEditorsMap.values()) {
                if (!(element instanceof StringFieldEditor)) continue;
                ((StringFieldEditor)element).setStringValue("");
            }
        }
        for (FieldEditor element : this.libletFieldEditorsMap.values()) {
            element.store();
        }
        for (FieldEditor element : this.fieldEditorsMap.values()) {
            element.store();
        }
        for (FieldEditor element : this.sharedFieldEditorsMap.values()) {
            element.store();
        }
        this.setDirty(false);
        this.validateFields();
        String jarPropertyName = "MIDlet-Jar-URL";
        if (this.packagingModelCombo.getText().equals(PackagingModel.LIBLET.getName())) {
            jarPropertyName = "LIBlet-Jar-URL";
        }
        String currentJarUrl = this.getPreferenceStore().getString(jarPropertyName);
        Text jarURLControl = null;
        for (FieldEditor field : this.fieldEditorsMap.values()) {
            String fieldEditorLabel;
            if (!(field instanceof ExtendedStringFieldEditor) || !(fieldEditorLabel = field.getLabelText()).equals(MTJUIMessages.RequiredJADDesciptorsProvider_midlet_jar_url)) continue;
            jarURLControl = ((ExtendedStringFieldEditor)field).getFieldEditorTextControl();
            break;
        }
        if (!Utils.isValidFileName((String)currentJarUrl)) {
            this.getPreferenceStore().putValue(jarPropertyName, this.loadedJarUrl);
            this.getErrorMessageManager().removeMessage((Object)("textLength_" + MTJUIMessages.RequiredJADDesciptorsProvider_midlet_jar_url), (Control)jarURLControl);
        } else if (!currentJarUrl.substring(currentJarUrl.length() - 4).equalsIgnoreCase(".jar")) {
            this.getPreferenceStore().putValue(jarPropertyName, this.loadedJarUrl);
            this.getErrorMessageManager().removeMessage((Object)("textLength_" + MTJUIMessages.RequiredJADDesciptorsProvider_midlet_jar_url), (Control)jarURLControl);
        }
        if (!currentJarUrl.equals(this.loadedJarUrl)) {
            ((JADFormEditor)this.getEditor()).setCleanRequired(true);
        }
        IDevice device = this.configManager.getActiveConfiguration().getDevice();
        if (this.midletProject != null && device != null) {
            try {
                this.midletProject.refreshClasspath(monitor, this.getPreferenceStore().getString("MicroEdition-Configuration"), this.getPreferenceStore().getString("MicroEdition-Profile"));
                this.configManager.performFinish();
                this.midletProject.saveMetaData();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void validateFields() {
        Collection<FieldEditor> verifiedFields = null;
        if (this.packagingModelCombo.getText().equals(PackagingModel.MIDLET.getName())) {
            verifiedFields = this.fieldEditorsMap.values();
        } else if (this.packagingModelCombo.getText().equals(PackagingModel.LIBLET.getName())) {
            verifiedFields = this.libletFieldEditorsMap.values();
        }
        for (FieldEditor field : verifiedFields) {
            if (!(field instanceof ExtendedStringFieldEditor)) continue;
            String fieldEditorLabel = field.getLabelText();
            Text control = ((ExtendedStringFieldEditor)field).getFieldEditorTextControl();
            if (!control.getText().equals("")) continue;
            this.getErrorMessageManager().addMessage((Object)("textLength_" + fieldEditorLabel), MTJUIMessages.OverviewEditorPage_empty_field_error_msg, null, 3, (Control)control);
        }
    }

    @Override
    public String getTitle() {
        return MTJUIMessages.OverviewEditorPage_title;
    }

    @Override
    public void linkActivated(HyperlinkEvent e) {
        String href = (String)e.getHref();
        if (href.equals("package")) {
            new ExportPackageAction(this.getJavaProject()).run();
        } else if (href.equals("antenna")) {
            new AntennaExportAction(this.project).run();
        } else if (href.startsWith("launchShortcut.")) {
            this.handleLaunchShortcut(href);
        }
    }

    public void nameChanged(MTJRuntimeNameChangeEvent event) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_value")) {
            if (event.getSource() instanceof FieldEditor) {
                boolean isLiblet;
                String preferenceName = ((FieldEditor)event.getSource()).getPreferenceName();
                if (event.getSource() instanceof ExtendedStringFieldEditor && (!(isLiblet = this.packagingModelCombo.getText().equals(PackagingModel.LIBLET.getName())) && this.fieldEditorsMap.containsKey(preferenceName) || isLiblet && this.libletFieldEditorsMap.containsKey(preferenceName))) {
                    String fieldEditorLabel = ((FieldEditor)event.getSource()).getLabelText();
                    Text c = ((ExtendedStringFieldEditor)((Object)event.getSource())).getFieldEditorTextControl();
                    if (event.getNewValue().equals("")) {
                        this.getErrorMessageManager().addMessage((Object)("textLength_" + fieldEditorLabel), MTJUIMessages.OverviewEditorPage_empty_field_error_msg, null, 3, (Control)c);
                    } else if (((ExtendedStringFieldEditor)((Object)event.getSource())).getPreferenceName().equals("MIDlet-Jar-URL")) {
                        String jarFileName = (String)event.getNewValue();
                        if (jarFileName.length() < 4 || !jarFileName.substring(jarFileName.length() - 4).equalsIgnoreCase(".jar")) {
                            this.getErrorMessageManager().addMessage((Object)("textLength_" + fieldEditorLabel), MTJUIMessages.J2MEProjectPropertiesPage_validatePage_jar_error, null, 3, (Control)c);
                        } else if (!Utils.isValidFileName((String)jarFileName)) {
                            this.getErrorMessageManager().addMessage((Object)("textLength_" + fieldEditorLabel), MTJUIMessages.OverviewEditorPage_invalid_jar_file_name, null, 3, (Control)c);
                        } else {
                            this.getErrorMessageManager().removeMessage((Object)("textLength_" + fieldEditorLabel), (Control)c);
                        }
                    } else {
                        this.getErrorMessageManager().removeMessage((Object)("textLength_" + fieldEditorLabel), (Control)c);
                    }
                }
                if ("MicroEdition-Profile".equals(preferenceName)) {
                    for (DeviceProfileChangeListener listener : this.deviceProfileChangeListeners) {
                        listener.deviceProfileChanged((String)event.getNewValue());
                    }
                }
            }
            this.setDirty(true);
        }
    }

    public void symbolSetChanged() {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    public void workspaceScopeSymbolSetsChanged(MTJRuntimeWorkspaceSymbolSetsChangeEvent event) {
        this.setDirty(MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)this.midletProject));
    }

    private void createDebuginSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(toolkit, parent, MTJUIMessages.OverviewEditorPage_debugging_section_title);
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section, null);
        FormText text = this.createClient(container, MTJUIMessages.overviewPage_launchsection_debuglinks, toolkit, this);
        text.setImage("debugMidlet", MTJUIPluginImages.DESC_DEBUG_MIDLET.createImage());
        text.setImage("debugjad", MTJUIPluginImages.DESC_DEBUG_JAD.createImage());
        text.setImage("debugOta", MTJUIPluginImages.DESC_DEBUG_OTA.createImage());
        section.setClient((Control)container);
    }

    private void createExportingSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(toolkit, parent, MTJUIMessages.OverviewEditorPage_exporting_section_title);
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section, null);
        FormText text = this.createClient(container, MTJUIMessages.overviewPage_exporting, toolkit, this);
        text.setImage("antenna", MTJUIPluginImages.DESC_ANT.createImage());
        section.setClient((Control)container);
    }

    private void createOverviewSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticBasicSection(toolkit, parent, MTJUIMessages.overviewPage_requiredsection_title, MTJUIMessages.overviewPage_requiredsection_description);
        Composite sectionClient = this.createStaticSectionClient(toolkit, (Composite)section, null);
        sectionClient.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 1));
        this.createSectionContent(managedForm, sectionClient, this);
        section.setClient((Control)sectionClient);
    }

    @Override
    protected void createSectionContent(IManagedForm managedForm, Composite composite, IPropertyChangeListener propertyChangeListener) {
        FormToolkit toolkit = managedForm.getToolkit();
        composite.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        new Label(composite, 0);
        new Label(composite, 0);
        this.initPropertyDescriptors();
        Label packagingModelLabel = new Label(composite, 0);
        packagingModelLabel.setText(MTJUIMessages.jadPropertiesEditorPage_PackagingModel_text);
        this.propertyLabels.add(packagingModelLabel);
        this.packagingModelCombo = new Combo(composite, 8);
        this.packagingModelCombo.add(PackagingModel.MIDLET.getName());
        this.packagingModelCombo.add(PackagingModel.LIBLET.getName());
        this.packagingModelCombo.select(0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.packagingModelCombo.setLayoutData((Object)gridData);
        this.activePanel = new Composite(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        this.activePanel.setLayoutData((Object)gridData);
        StackLayout stackLayout = new StackLayout();
        this.activePanel.setLayout((Layout)stackLayout);
        this.packagingModelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagingModel newPackagingModel = null;
                if (OverviewEditorPage.this.packagingModelCombo.getText().equals(PackagingModel.MIDLET.getName())) {
                    newPackagingModel = PackagingModel.MIDLET;
                    if (newPackagingModel == OverviewEditorPage.this.packagingModel) {
                        return;
                    }
                    int i = 0;
                    while (i < MIDLET_LIBLET_KEYS.length) {
                        ((StringFieldEditor)OverviewEditorPage.this.fieldEditorsMap.get(MIDLET_LIBLET_KEYS[i][0])).setStringValue(((StringFieldEditor)OverviewEditorPage.this.libletFieldEditorsMap.get(MIDLET_LIBLET_KEYS[i][1])).getStringValue());
                        ((StringFieldEditor)OverviewEditorPage.this.fieldEditorsMap.get(MIDLET_LIBLET_KEYS[i][0])).setEmptyStringAllowed(false);
                        ((StringFieldEditor)OverviewEditorPage.this.libletFieldEditorsMap.get(MIDLET_LIBLET_KEYS[i][1])).setEmptyStringAllowed(true);
                        ++i;
                    }
                } else {
                    newPackagingModel = PackagingModel.LIBLET;
                    if (newPackagingModel == OverviewEditorPage.this.packagingModel) {
                        return;
                    }
                    int i = 0;
                    while (i < MIDLET_LIBLET_KEYS.length) {
                        ((StringFieldEditor)OverviewEditorPage.this.libletFieldEditorsMap.get(MIDLET_LIBLET_KEYS[i][1])).setStringValue(((StringFieldEditor)OverviewEditorPage.this.fieldEditorsMap.get(MIDLET_LIBLET_KEYS[i][0])).getStringValue());
                        ((StringFieldEditor)OverviewEditorPage.this.fieldEditorsMap.get(MIDLET_LIBLET_KEYS[i][0])).setEmptyStringAllowed(true);
                        ((StringFieldEditor)OverviewEditorPage.this.libletFieldEditorsMap.get(MIDLET_LIBLET_KEYS[i][1])).setEmptyStringAllowed(false);
                        ++i;
                    }
                }
                OverviewEditorPage.this.setPackagingModel(newPackagingModel);
            }
        });
        this.libletComposite = new Composite(this.activePanel, 0);
        this.libletComposite.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        this.initPropertyEditors(this.libletDescriptors, this.libletFieldEditorsMap, propertyChangeListener, this.libletComposite, toolkit);
        this.midletComposite = new Composite(this.activePanel, 0);
        this.midletComposite.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        this.initPropertyEditors(this.midletDescriptors, this.fieldEditorsMap, propertyChangeListener, this.midletComposite, toolkit);
        this.initPropertyEditors(this.sharedDescriptors, this.sharedFieldEditorsMap, propertyChangeListener, composite, toolkit);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PackagingModel newPackagingModel = PackagingModel.MIDLET;
                if (((StringFieldEditor)OverviewEditorPage.this.fieldEditorsMap.get("MIDlet-Name")).getStringValue().equals("") && !((StringFieldEditor)OverviewEditorPage.this.libletFieldEditorsMap.get("LIBlet-Name")).getStringValue().equals("")) {
                    OverviewEditorPage.this.packagingModelCombo.select(1);
                    newPackagingModel = PackagingModel.LIBLET;
                }
                OverviewEditorPage.this.setPackagingModel(newPackagingModel);
            }
        });
        int maxLabelWidth = 0;
        for (Label label : this.propertyLabels) {
            int labelWidth = label.computeSize((int)-1, (int)-1).x;
            int n = maxLabelWidth = labelWidth > maxLabelWidth ? labelWidth : maxLabelWidth;
        }
        for (Label label : this.propertyLabels) {
            gridData = new GridData();
            gridData.widthHint = maxLabelWidth;
            label.setLayoutData((Object)gridData);
        }
        this.updateEditComponents();
        this.addContextHelp(this.midletComposite);
    }

    private void setPackagingModel(PackagingModel packagingModel) {
        FieldEditor profileEditor;
        this.packagingModel = packagingModel;
        if (this.activePanel != null) {
            if (packagingModel == PackagingModel.MIDLET) {
                ((StackLayout)this.activePanel.getLayout()).topControl = this.midletComposite;
            } else if (packagingModel == PackagingModel.LIBLET) {
                ((StackLayout)this.activePanel.getLayout()).topControl = this.libletComposite;
            }
            this.activePanel.layout();
        }
        if ((profileEditor = this.sharedFieldEditorsMap.get("MicroEdition-Profile")) != null) {
            ((IFilteredJADPropertyEditor)profileEditor).performFiltering(PACKAGING_MODEL_PROPERTY, packagingModel.toString());
        }
        for (PackagingModelChangeListener listener : this.packagingModelChangeListeners) {
            listener.packagingModelChanged(packagingModel);
        }
    }

    private void initPropertyDescriptors() {
        DescriptorPropertyDescription[] descriptorPropertyDescriptionArray = this.getDescriptors();
        int n = descriptorPropertyDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            DescriptorPropertyDescription d = descriptorPropertyDescriptionArray[n2];
            if (d.isLibletDescriptor()) {
                this.libletDescriptors.add(d);
            } else if (d.getPropertyName().equals("MicroEdition-Configuration") || d.getPropertyName().equals("MicroEdition-Profile")) {
                this.sharedDescriptors.add(d);
                if (d.getPropertyName().equals("MicroEdition-Profile")) {
                    ((ListDescriptorPropertyDescription)d).setFilter(new ListDescriptorPropertyDescription.IListDescriptorPropertyFilter(){
                        private String[][] libletSupportedProfiles = new String[][]{{Profile.MEEP_80.getName(), Profile.MEEP_80.toString()}};

                        @Override
                        public String[] getFilterPropertyNames() {
                            return new String[]{OverviewEditorPage.PACKAGING_MODEL_PROPERTY};
                        }

                        @Override
                        public String[][] filterNamesAndValues(Map<String, Object> filterProperties, String[][] namesAndValues) {
                            if (PackagingModel.LIBLET.toString().equals(filterProperties.get(OverviewEditorPage.PACKAGING_MODEL_PROPERTY))) {
                                return this.libletSupportedProfiles;
                            }
                            return namesAndValues;
                        }
                    });
                }
            } else {
                this.midletDescriptors.add(d);
            }
            ++n2;
        }
    }

    private void initPropertyEditors(List<DescriptorPropertyDescription> descriptors, Map<String, FieldEditor> editorsMap, final IPropertyChangeListener propertyChangeListener, Composite parent, FormToolkit toolkit) {
        Control[] controlArray;
        HashMap<String, ArrayList<IFilteredJADPropertyEditor>> dependentEditors = new HashMap<String, ArrayList<IFilteredJADPropertyEditor>>();
        for (DescriptorPropertyDescription descriptorPropertyDescription : descriptors) {
            IFilteredJADPropertyEditor filteredEditor;
            String[] filterPropertyNames;
            IntegerFieldEditor fieldEditor = null;
            switch (descriptorPropertyDescription.getDataType()) {
                case 3: {
                    fieldEditor = this.createIntegerFieldEditor(toolkit, parent, descriptorPropertyDescription);
                    break;
                }
                case 4: {
                    fieldEditor = this.createComboFieldEditor(toolkit, parent, descriptorPropertyDescription);
                    break;
                }
                default: {
                    fieldEditor = this.createStringFieldEditor(toolkit, parent, descriptorPropertyDescription);
                }
            }
            editorsMap.put(descriptorPropertyDescription.getPropertyName(), (FieldEditor)fieldEditor);
            if (fieldEditor instanceof IFilteredJADPropertyEditor && (filterPropertyNames = (filteredEditor = (IFilteredJADPropertyEditor)fieldEditor).getFilterPropertyNames()) != null) {
                String[] stringArray = filterPropertyNames;
                int n = filterPropertyNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String filterPropertyName = stringArray[n2];
                    ArrayList<IFilteredJADPropertyEditor> propertyDependentEditors = (ArrayList<IFilteredJADPropertyEditor>)dependentEditors.get(filterPropertyName);
                    if (propertyDependentEditors == null) {
                        propertyDependentEditors = new ArrayList<IFilteredJADPropertyEditor>();
                        dependentEditors.put(filterPropertyName, propertyDependentEditors);
                    }
                    propertyDependentEditors.add(filteredEditor);
                    ++n2;
                }
            }
            Label label = fieldEditor.getLabelControl(parent);
            toolkit.adapt((Control)label, false, false);
            this.propertyLabels.add(label);
            fieldEditor.setPropertyChangeListener(propertyChangeListener);
        }
        for (Map.Entry entry : dependentEditors.entrySet()) {
            final String masterEditorPropertyName = (String)entry.getKey();
            FieldEditor masterEditor = editorsMap.get(masterEditorPropertyName);
            if (masterEditor == null) continue;
            final List propertyDependentEditors = (List)entry.getValue();
            masterEditor.setPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    propertyChangeListener.propertyChange(event);
                    if ("mtj_update_jad_filter".equals(event.getProperty())) {
                        for (IFilteredJADPropertyEditor propertyDependentEditor : propertyDependentEditors) {
                            propertyDependentEditor.performFiltering(masterEditorPropertyName, event.getNewValue());
                        }
                    }
                }
            });
        }
        Control[] controlArray2 = controlArray = parent.getChildren();
        int n = controlArray.length;
        int n3 = 0;
        while (n3 < n) {
            Control control = controlArray2[n3];
            if (control instanceof Combo) {
                toolkit.adapt(control, false, false);
            }
            ++n3;
        }
    }

    @Override
    protected void updateEditComponents() {
        IManifestPreferenceStore store = this.getPreferenceStore();
        this.validateStore((IPreferenceStore)store);
        for (FieldEditor fieldEditor : this.fieldEditorsMap.values()) {
            fieldEditor.setPreferenceStore((IPreferenceStore)store);
            fieldEditor.load();
        }
        for (FieldEditor fieldEditor : this.libletFieldEditorsMap.values()) {
            fieldEditor.setPreferenceStore((IPreferenceStore)store);
            fieldEditor.load();
        }
        for (FieldEditor fieldEditor : this.sharedFieldEditorsMap.values()) {
            fieldEditor.setPreferenceStore((IPreferenceStore)store);
            fieldEditor.load();
        }
        for (FieldEditor fieldEditor : this.fieldEditorsMap.values()) {
            if (!(fieldEditor instanceof IFilteredJADPropertyEditor)) continue;
            ((IFilteredJADPropertyEditor)fieldEditor).updateDependencies();
        }
        for (FieldEditor fieldEditor : this.libletFieldEditorsMap.values()) {
            if (!(fieldEditor instanceof IFilteredJADPropertyEditor)) continue;
            ((IFilteredJADPropertyEditor)fieldEditor).updateDependencies();
        }
        for (FieldEditor fieldEditor : this.sharedFieldEditorsMap.values()) {
            if (!(fieldEditor instanceof IFilteredJADPropertyEditor)) continue;
            ((IFilteredJADPropertyEditor)fieldEditor).updateDependencies();
        }
    }

    private PackagingModel extractPackagingModel(IPreferenceStore store) {
        PackagingModel result = PackagingModel.MIDLET;
        if (store.getString("MIDlet-Name").equals("") && !store.getString("LIBlet-Name").equals("")) {
            result = PackagingModel.LIBLET;
        }
        return result;
    }

    private void validateStore(IPreferenceStore store) {
        String[] keys;
        int secondIndex;
        PackagingModel newPackagingModel = this.extractPackagingModel(store);
        int firstIndex = newPackagingModel == PackagingModel.MIDLET ? 0 : 1;
        int n = secondIndex = newPackagingModel == PackagingModel.MIDLET ? 1 : 0;
        if (this.packagingModelCombo != null) {
            this.packagingModelCombo.select(firstIndex);
        }
        if (newPackagingModel != this.packagingModel) {
            this.setPackagingModel(newPackagingModel);
        }
        int i = 0;
        while (i < MIDLET_LIBLET_KEYS.length) {
            if (store.getString(MIDLET_LIBLET_KEYS[i][firstIndex]).equals("") && !store.getString(MIDLET_LIBLET_KEYS[i][secondIndex]).equals("")) {
                store.setValue(MIDLET_LIBLET_KEYS[i][firstIndex], store.getString(MIDLET_LIBLET_KEYS[i][secondIndex]));
            }
            store.setValue(MIDLET_LIBLET_KEYS[i][secondIndex], "");
            ++i;
        }
        if (newPackagingModel == PackagingModel.LIBLET) {
            if (!store.getString("MicroEdition-Profile").equals(Profile.MEEP_80.toString())) {
                store.setValue("MicroEdition-Profile", Profile.MEEP_80.toString());
            }
            if (!store.getString("MicroEdition-Configuration").equals(Configuration.CLDC_18.toString())) {
                store.setValue("MicroEdition-Configuration", Configuration.CLDC_18.toString());
            }
        }
        String tagRegEx = "[1-9]+[0-9]*";
        String[] stringArray = keys = ((IManifestPreferenceStore)store).preferenceNames();
        int n2 = keys.length;
        int n3 = 0;
        while (n3 < n2) {
            String key = stringArray[n3];
            if (key.matches("MIDlet-Dependency-" + tagRegEx) || key.matches("LIBlet-Dependency-" + tagRegEx) || key.matches("MIDlet-Dependency-JAD-URL-" + tagRegEx) || key.matches("LIBlet-Dependency-JAD-URL-" + tagRegEx)) {
                store.setValue(key, "");
            }
            ++n3;
        }
    }

    private void createPackagingSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(toolkit, parent, MTJUIMessages.OverviewEditorPage_packaging_section_title);
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section, null);
        FormText text = this.createClient(container, MTJUIMessages.overviewPage_deploying, toolkit, this);
        text.setImage("package", MTJUIPluginImages.DESC_PACKAGE.createImage());
        section.setClient((Control)container);
    }

    private void createRunningSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(toolkit, parent, MTJUIMessages.OverviewEditorPage_running_section_title);
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section, null);
        FormText text = this.createClient(container, MTJUIMessages.overviewPage_launchsection_runlinks, toolkit, this);
        text.setImage("runMidlet", MTJUIPluginImages.DESC_RUN_MIDLET.createImage());
        text.setImage("runjad", MTJUIPluginImages.DESC_RUN_JAD.createImage());
        text.setImage("runOta", MTJUIPluginImages.DESC_RUN_OTA.createImage());
        section.setClient((Control)container);
    }

    private void createRuntimeSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticBasicSection(toolkit, parent, MTJUIMessages.overviewPage_runtimesection_title, MTJUIMessages.overviewPage_runtimesection_description);
        Composite sectionClient = this.createStaticSectionClient(toolkit, (Composite)section, null);
        sectionClient.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(true, 1));
        this.createRuntimeSectionContent(managedForm, sectionClient, this);
        section.setClient((Control)sectionClient);
    }

    private void createRuntimeSectionContent(IManagedForm managedForm, Composite sectionClient, OverviewEditorPage overviewEditorPage) {
        this.configManager = new ConfigManageComponent(this.midletProject);
        this.configManager.setIncludeGroup(false);
        this.configManager.createContents(sectionClient);
        this.configManager.setConfigurationsChangeListener(this);
        this.configManager.setConfigurationChangeListener(this);
    }

    private void fillEditorPageBody(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout(true, 2));
        Composite left = toolkit.createComposite(body);
        left.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        left.setLayoutData((Object)new TableWrapData(256));
        this.createOverviewSection(managedForm, left, toolkit);
        this.createPackagingSection(managedForm, left, toolkit);
        this.createExportingSection(managedForm, left, toolkit);
        Composite right = toolkit.createComposite(body);
        right.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        right.setLayoutData((Object)new TableWrapData(256));
        this.createRunningSection(managedForm, right, toolkit);
        this.createDebuginSection(managedForm, right, toolkit);
        this.createRuntimeSection(managedForm, right, toolkit);
    }

    private void handleLaunchShortcut(String href) {
        IConfigurationElement[] elements;
        int index = (href = href.substring(15)).indexOf(46);
        if (index < 0) {
            return;
        }
        String mode = href.substring(0, index);
        String id = href.substring(index + 1);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.debug.ui.launchShortcuts");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (id.equals(element.getAttribute("id"))) {
                try {
                    ILaunchShortcut shortcut = (ILaunchShortcut)element.createExecutableExtension("class");
                    shortcut.launch((ISelection)new StructuredSelection((Object)this.project), mode);
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
    }

    @Override
    protected void addContextHelp(Composite c) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)c, "org.eclipse.mtj.ui.help_JADRequiredPropertiesEditorPage");
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(this.getTitle());
        toolkit.decorateFormHeading(form.getForm());
        this.createErrorMessageHandler(managedForm);
        final String href = this.getHelpResource();
        if (href != null) {
            IToolBarManager manager = form.getToolBarManager();
            Action helpAction = new Action(MTJUIMessages.OverviewEditorPage_help_action){

                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(href);
                }
            };
            helpAction.setImageDescriptor(MTJUIPluginImages.DESC_LINKTOHELP);
            manager.add((IAction)helpAction);
        }
        form.updateToolBar();
        this.fillEditorPageBody(managedForm);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                OverviewEditorPage.this.validateFields();
            }
        });
    }

    @Override
    protected String getHelpResource() {
        return "/org.eclipse.mtj.doc.user/html/reference/editors/jad_editor/overview.html";
    }

    @Override
    protected String getSectionDescription() {
        return "";
    }

    @Override
    protected String getSectionTitle() {
        return "";
    }

    @Override
    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.loadedJarUrl = this.getPreferenceStore().getString("MIDlet-Jar-URL");
    }

    public static interface ActiveDeviceChangeListener {
        public void activeDeviceChanged(IDevice var1);
    }

    public static interface DeviceProfileChangeListener {
        public void deviceProfileChanged(String var1);
    }

    public static interface PackagingModelChangeListener {
        public void packagingModelChanged(PackagingModel var1);
    }
}

