/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L10nUtil {
    public static List<L10nLocale> findConflictedLocales(L10nLocales locales) {
        IDocumentElementNode[] localeNodes;
        LinkedList<L10nLocale> conflicted = new LinkedList<L10nLocale>();
        IDocumentElementNode[] iDocumentElementNodeArray = localeNodes = locales.getChildNodes();
        int n = localeNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode localeNode = iDocumentElementNodeArray[n2];
            L10nLocale locale = (L10nLocale)localeNode;
            if (L10nUtil.localeHasKeyConflicts(locale)) {
                conflicted.add(locale);
            }
            ++n2;
        }
        return conflicted;
    }

    private static boolean localeHasKeyConflicts(L10nLocale locale) {
        IDocumentElementNode[] nodes;
        IDocumentElementNode[] iDocumentElementNodeArray = nodes = locale.getChildNodes();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode node = iDocumentElementNodeArray[n2];
            L10nEntry entry = (L10nEntry)node;
            if (entry.getStatus().getSeverity() == 4) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

