/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mtj.internal.core.IModelChangedEvent;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editor.FormFilteredTree;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJFormPage;
import org.eclipse.mtj.internal.ui.editor.TreeSection;
import org.eclipse.mtj.internal.ui.editor.actions.CollapseAction;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nContentProvider;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalizationDataEditor;
import org.eclipse.mtj.internal.ui.editors.l10n.actions.L10nAddLocaleAction;
import org.eclipse.mtj.internal.ui.editors.l10n.actions.L10nAddLocaleEntryAction;
import org.eclipse.mtj.internal.ui.editors.l10n.actions.L10nAddObjectAction;
import org.eclipse.mtj.internal.ui.editors.l10n.actions.L10nRemoveObjectAction;
import org.eclipse.mtj.internal.ui.parts.TreePart;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.keys.IBindingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalesTreeSection
extends TreeSection {
    private static final int F_BUTTON_ADD_LOCALE = 0;
    private static final int F_BUTTON_ADD_ENTRY = 1;
    private static final int F_BUTTON_REMOVE = 2;
    private static final int F_BUTTON_UP = 4;
    private static final int F_BUTTON_DOWN = 5;
    private static final int F_DOWN_FLAG = 1;
    private static final int F_UP_FLAG = -1;
    private L10nAddLocaleAction addLocaleAction;
    private L10nAddLocaleEntryAction addLocaleEntryAction;
    private CollapseAction fCollapseAction;
    private boolean fDragFromHere;
    private FormFilteredTree filteredTree;
    private L10nModel model;
    private L10nRemoveObjectAction removeObjectAction;
    private TreeViewer localesTree;

    public LocalesTreeSection(MTJFormPage formPage, Composite parent) {
        String[] stringArray = new String[6];
        stringArray[0] = MTJUIMessages.LocalesTreeSection_addLocale_button_label;
        stringArray[1] = MTJUIMessages.LocalesTreeSection_addEntry_button_label;
        stringArray[2] = MTJUIMessages.LocalesTreeSection_remove_button_label;
        stringArray[4] = MTJUIMessages.LocalesTreeSection_up_button_label;
        stringArray[5] = MTJUIMessages.LocalesTreeSection_down_button_label;
        super(formPage, parent, 128, stringArray);
        this.addLocaleAction = new L10nAddLocaleAction();
        this.addLocaleEntryAction = new L10nAddLocaleEntryAction();
        this.removeObjectAction = new L10nRemoveObjectAction();
    }

    public void dispose() {
        MTJUIPlugin.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        boolean cutAction = actionId.equals(ActionFactory.CUT.getId());
        if (cutAction || actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDeleteAction();
            return !cutAction;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    public void fireSelection() {
        this.localesTree.setSelection(this.localesTree.getSelection());
    }

    public ISelection getSelection() {
        return this.localesTree.getSelection();
    }

    public void handleDrag(List<IStructuredSelection> itemsDragged) {
        this.handleRemove(itemsDragged);
        this.fDragFromHere = false;
    }

    public void handleRemove(List<IStructuredSelection> itemsToRemove) {
        if (!itemsToRemove.isEmpty()) {
            this.removeObjectAction.setToRemove(itemsToRemove.toArray(new L10nObject[itemsToRemove.size()]));
            this.removeObjectAction.run();
        }
    }

    @Override
    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.handleModelEventWorldChanged(event);
        } else if (event.getChangeType() == 1) {
            this.handleModelInsertType(event);
        } else if (event.getChangeType() == 2) {
            this.handleModelRemoveType(event);
        } else if (event.getChangeType() == 3 && event.getChangedProperty().equals("type_swap")) {
            this.handleModelChangeTypeSwap(event);
        } else if (event.getChangeType() == 3) {
            this.handleModelChangeType(event);
        }
    }

    public boolean performDrop(Object currentTarget, Object dropped, int location) {
        return false;
    }

    public void refresh() {
        L10nModel model = (L10nModel)this.getPage().getModel();
        model.validate();
        this.localesTree.setInput((Object)model);
        this.localesTree.expandToLevel(2);
        this.localesTree.setSelection((ISelection)new StructuredSelection((Object)model.getLocales()), true);
        this.getManagedForm().fireSelectionChanged((IFormPart)this, this.localesTree.getSelection());
        super.refresh();
    }

    public boolean setFormInput(Object object) {
        if (object instanceof L10nObject) {
            ((L10nObject)object).validate();
            this.localesTree.setSelection((ISelection)new StructuredSelection(object), true);
            ISelection selection = this.localesTree.getSelection();
            if (selection != null && !selection.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public void setSelection(ISelection selection) {
        this.localesTree.setSelection(selection);
    }

    public void updateButtons() {
        if (!this.model.isEditable()) {
            return;
        }
        boolean canAddLocale = false;
        boolean canAddEntry = false;
        boolean canRemove = false;
        IStructuredSelection sel = (IStructuredSelection)this.localesTree.getSelection();
        boolean canMoveUp = sel.size() == 1;
        boolean canMoveDown = sel.size() == 1;
        for (L10nObject l10nObject : sel) {
            if (l10nObject != null) {
                if (l10nObject.canBeRemoved()) {
                    canRemove = true;
                }
                L10nObject parent = l10nObject.getParent();
                if (sel.size() == 1) {
                    if (l10nObject.getType() == 0) {
                        canAddLocale = true;
                        canAddEntry = false;
                    } else if (l10nObject.getType() == 1) {
                        canAddLocale = false;
                        canAddEntry = true;
                    } else if (l10nObject.getType() == 2) {
                        canAddLocale = false;
                        canAddEntry = false;
                    }
                }
                if (l10nObject.getType() == 0) {
                    canMoveUp = false;
                    canMoveDown = false;
                    continue;
                }
                if (parent == null) continue;
                L10nObject parentNode = parent;
                if (parentNode.isFirstChildNode((IDocumentElementNode)l10nObject, L10nObject.class)) {
                    canMoveUp = false;
                }
                if (!parentNode.isLastChildNode((IDocumentElementNode)l10nObject, L10nObject.class)) continue;
                canMoveDown = false;
                continue;
            }
            canAddLocale = false;
            canAddEntry = false;
            canRemove = false;
            canMoveUp = false;
            canMoveDown = false;
            break;
        }
        this.getTreePart().setButtonEnabled(0, canAddLocale);
        this.getTreePart().setButtonEnabled(1, canAddEntry);
        this.getTreePart().setButtonEnabled(2, canRemove);
        this.getTreePart().setButtonEnabled(4, canMoveUp);
        this.getTreePart().setButtonEnabled(5, canMoveDown);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        this.fCollapseAction = new CollapseAction((AbstractTreeViewer)this.localesTree, MTJUIMessages.LocalesTreeSection_collapseAllAction_Text, 1, this.model.getLocales());
        toolBarManager.add((IAction)this.fCollapseAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private void createTree(Composite container, FormToolkit toolkit) {
        TreePart treePart = this.getTreePart();
        this.createViewerPartControl(container, 2, 2, toolkit);
        this.localesTree = treePart.getTreeViewer();
        this.localesTree.setContentProvider((IContentProvider)new L10nContentProvider());
        this.localesTree.setLabelProvider((IBaseLabelProvider)MTJUIPlugin.getDefault().getLabelProvider());
        MTJUIPlugin.getDefault().getLabelProvider().connect(this);
        this.createTreeListeners();
    }

    private void createTreeListeners() {
        this.localesTree.addPostSelectionChangedListener((ISelectionChangedListener)new MTJFormEditor.MTJFormEditorChangeListener(this.getPage().getMTJEditor()));
    }

    private void fillContextMenuAddActions(MenuManager submenu, L10nObject l10nObject) {
        if (l10nObject != null && l10nObject.canBeParent()) {
            if (l10nObject instanceof L10nLocales) {
                this.addLocaleAction.setParentObject(l10nObject);
                this.addLocaleAction.setEnabled(this.model.isEditable());
                submenu.add((IAction)this.addLocaleAction);
            } else if (l10nObject instanceof L10nLocale) {
                this.addLocaleEntryAction.setParentObject(l10nObject);
                this.addLocaleEntryAction.setEnabled(this.model.isEditable());
                submenu.add((IAction)this.addLocaleEntryAction);
            }
        }
    }

    private void fillContextMenuRemoveAction(IMenuManager manager, L10nObject l10nObject) {
        this.removeObjectAction.setToRemove(l10nObject);
        manager.add((IAction)this.removeObjectAction);
        this.removeObjectAction.setEnabled(l10nObject.canBeRemoved() && this.model.isEditable());
    }

    private void fillContextMenuShowInAction(IMenuManager manager) {
        String keyBinding;
        String showInLabel = MTJUIMessages.LocalesTreeSection_showInLabel;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null && (keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu")) != null) {
            showInLabel = String.valueOf(showInLabel) + '\t' + keyBinding;
        }
        MenuManager showInMenu = new MenuManager(showInLabel);
        showInMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getPage().getSite().getWorkbenchWindow()));
        manager.add((IContributionItem)showInMenu);
    }

    private void handleAddAction(L10nAddObjectAction action) {
        ISelection sel = this.localesTree.getSelection();
        Object object = ((IStructuredSelection)sel).getFirstElement();
        if (object == null) {
            return;
        }
        L10nObject l10nObject = (L10nObject)object;
        if (l10nObject.canBeParent()) {
            action.setParentObject(l10nObject);
            action.run();
        } else {
            action.setParentObject(l10nObject.getParent());
            action.setTargetObject(l10nObject);
            action.run();
        }
        this.model.getLocales().validate();
        FormEditor editor = this.getPage().getEditor();
        if (editor instanceof LocalizationDataEditor) {
            ((LocalizationDataEditor)editor).updateMessageManager(this.model.getLocales());
        }
        this.localesTree.refresh();
    }

    private void handleDeleteAction() {
        ArrayList<IStructuredSelection> objects = new ArrayList<IStructuredSelection>(((IStructuredSelection)this.localesTree.getSelection()).toList());
        boolean beep = false;
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            L10nObject l10nObject;
            Object object = i.next();
            if (!(object instanceof L10nObject) || (l10nObject = (L10nObject)object).canBeRemoved()) continue;
            i.remove();
            beep = true;
        }
        if (beep) {
            Display.getCurrent().beep();
        }
        this.handleRemove(objects);
        this.model.getLocales().validate();
        FormEditor editor = this.getPage().getEditor();
        if (editor instanceof LocalizationDataEditor) {
            ((LocalizationDataEditor)editor).updateMessageManager(this.model.getLocales());
        }
        this.localesTree.refresh();
    }

    private void handleModelChangeType(final IModelChangedEvent event) {
        this.localesTree.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (LocalesTreeSection.this.localesTree.getControl().isDisposed()) {
                    return;
                }
                LocalesTreeSection.this.model.getLocales().validate();
                Object[] objects = event.getChangedObjects();
                L10nObject object = (L10nObject)objects[0];
                if (object != null) {
                    LocalesTreeSection.this.localesTree.update((Object)object, null);
                    LocalesTreeSection.this.localesTree.refresh();
                }
            }
        });
    }

    private void handleModelChangeTypeSwap(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        L10nObject object = (L10nObject)objects[0];
        if (object != null) {
            object.validate();
            this.localesTree.refresh((Object)object);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.markStale();
    }

    private void handleModelInsertType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        L10nObject object = (L10nObject)objects[0];
        if (object != null) {
            object.validate();
            this.localesTree.refresh((Object)object.getParent());
            this.localesTree.setSelection((ISelection)new StructuredSelection((Object)object), true);
        }
    }

    private void handleModelRemoveType(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        L10nObject object = (L10nObject)objects[0];
        if (object != null && object.getType() != 0) {
            this.handleTaskObjectRemove(object);
        }
    }

    private void handleMoveAction(int positionFlag) {
        IStructuredSelection sel = (IStructuredSelection)this.localesTree.getSelection();
        for (Object object : sel) {
            L10nObject l10nObject;
            L10nObject parent;
            if (object == null) {
                return;
            }
            if (!(object instanceof L10nObject) || (parent = (l10nObject = (L10nObject)object).getParent()) == null) continue;
            parent.moveChildNode((IDocumentElementNode)l10nObject, positionFlag, true);
            this.updateButtons();
        }
    }

    private void handleTaskObjectRemove(L10nObject object) {
        this.localesTree.remove((Object)object);
        L10nObject l10nObject = this.removeObjectAction.getNextSelection();
        if (l10nObject == null) {
            l10nObject = object.getParent();
        }
        if (l10nObject.equals(object.getParent())) {
            this.localesTree.refresh((Object)object.getParent());
        }
        if (!this.fDragFromHere) {
            this.localesTree.setSelection((ISelection)new StructuredSelection((Object)l10nObject), true);
        }
    }

    private void initializeTreeViewer() {
        if (this.model == null) {
            return;
        }
        this.localesTree.setInput((Object)this.model);
        L10nLocales localesModel = this.model.getLocales();
        this.getTreePart().setButtonEnabled(0, this.isEditable());
        this.getTreePart().setButtonEnabled(1, this.isEditable());
        this.getTreePart().setButtonEnabled(2, false);
        this.getTreePart().setButtonEnabled(4, false);
        this.getTreePart().setButtonEnabled(5, false);
        this.localesTree.setSelection((ISelection)new StructuredSelection((Object)localesModel), true);
        this.localesTree.expandToLevel(2);
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAddAction(this.addLocaleAction);
                break;
            }
            case 1: {
                this.handleAddAction(this.addLocaleEntryAction);
                break;
            }
            case 2: {
                this.handleDeleteAction();
                break;
            }
            case 4: {
                this.handleMoveAction(-1);
                break;
            }
            case 5: {
                this.handleMoveAction(1);
            }
        }
    }

    @Override
    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        return true;
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        this.model = (L10nModel)this.getPage().getModel();
        this.model.validate();
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createTree(container, toolkit);
        toolkit.paintBordersFor(container);
        section.setText(MTJUIMessages.LocalesTreeSection_title);
        section.setDescription(MTJUIMessages.LocalesTreeSection_description);
        section.setClient((Control)container);
        this.initializeTreeViewer();
        this.createSectionToolbar(section, toolkit);
        this.filteredTree.createUIListenerEntryFilter(this);
        L10nLocales locales = this.model.getLocales();
        locales.validate();
        FormEditor editor = this.getPage().getEditor();
        if (editor instanceof LocalizationDataEditor) {
            ((LocalizationDataEditor)editor).updateMessageManager(locales);
        }
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent, int style) {
        this.filteredTree = new FormFilteredTree(parent, style, new PatternFilter());
        parent.setData("filtered", (Object)Boolean.TRUE);
        return this.filteredTree.getViewer();
    }

    @Override
    protected void doPaste(Object targetObject, Object[] sourceObjects) {
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.localesTree.getSelection();
        Object object = ((IStructuredSelection)selection).getFirstElement();
        L10nObject l10nObject = (L10nObject)object;
        if (l10nObject != null) {
            boolean emptyMenu = true;
            if (l10nObject.canBeParent()) {
                MenuManager submenu = new MenuManager(MTJUIMessages.LocalesTreeSection_new_submenu_text);
                this.fillContextMenuAddActions(submenu, l10nObject);
                manager.add((IContributionItem)submenu);
                emptyMenu = false;
            }
            if (!emptyMenu) {
                manager.add((IContributionItem)new Separator());
            }
        }
        this.getPage().getMTJEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
        if (l10nObject != null) {
            this.fillContextMenuRemoveAction(manager, l10nObject);
            manager.add((IContributionItem)new Separator());
            this.fillContextMenuShowInAction(manager);
            manager.add((IContributionItem)new Separator());
        }
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection selection) {
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getMTJEditor().setSelection((ISelection)selection);
        this.updateButtons();
    }
}

