/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.util.TestCaseSelectionDialogCreator;
import org.eclipse.mtj.internal.ui.util.TestSuiteSelectionDialogCreator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class JMUnitTab
extends JavaLaunchTab {
    private Button projectButton;
    private Label projectLabel;
    private Text projectText;
    Group groupExecutable;
    private Button testSuiteRadio;
    private Text testSuiteText;
    private Button testSuiteSearchButton;
    private Button testCaseRadio;
    private Text testCaseText;
    private Button testCaseSearchButton;

    public String getName() {
        return null;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(comp, 3);
        this.createProjectComponents(comp);
        this.createVerticalSpacer(comp, 3);
        this.createExecutableComponents(comp);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateProjectFromConfig(config);
        boolean doTestCase = false;
        try {
            doTestCase = config.getAttribute("mtj.do_test_case_launch", false);
        }
        catch (CoreException coreException) {}
        this.testSuiteRadio.setSelection(!doTestCase);
        this.testCaseRadio.setSelection(doTestCase);
        if (!doTestCase) {
            String testSuiteName = this.getStringOrDefault(config, IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
            this.testSuiteText.setText(testSuiteName);
        }
        if (doTestCase) {
            String testCaseName = this.getStringOrDefault(config, IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
            this.testCaseText.setText(testCaseName);
        }
        this.updateEnablement();
    }

    public boolean isValid(ILaunchConfiguration config) {
        String errorMessage = null;
        String name = this.projectText.getText().trim();
        if (name.length() > 0) {
            IProject selectedProject = MTJCore.getWorkspace().getRoot().getProject(name);
            if (!selectedProject.exists()) {
                errorMessage = MTJUIMessages.JMUnitTab_project_does_not_exist_error;
            } else {
                try {
                    if (errorMessage == null && !selectedProject.hasNature("org.eclipse.mtj.jmunit.jmunitNature")) {
                        errorMessage = MTJUIMessages.JMUnitTab_project_isnt_JMUnit_enabled_error;
                        this.testSuiteSearchButton.setEnabled(false);
                        this.testSuiteText.setEnabled(false);
                        this.testCaseSearchButton.setEnabled(false);
                        this.testCaseText.setEnabled(false);
                    } else {
                        this.updateEnablement();
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        if (errorMessage == null && this.testCaseRadio.getSelection() && (name = this.testCaseText.getText().trim()).length() == 0) {
            errorMessage = MTJUIMessages.JMUnit_test_case_not_specified_error;
        }
        if (errorMessage == null && this.testSuiteRadio.getSelection() && (name = this.testSuiteText.getText().trim()).length() == 0) {
            errorMessage = MTJUIMessages.JMUnit_test_suite_not_specified_error;
        }
        this.setErrorMessage(errorMessage);
        return errorMessage == null;
    }

    private void createExecutableComponents(Composite parent) {
        Font font = parent.getFont();
        this.groupExecutable = new Group(parent, 0);
        this.groupExecutable.setText(MTJUIMessages.JMUnitTab_testType_text);
        GridLayout mainLayout = new GridLayout(3, false);
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        this.groupExecutable.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        this.groupExecutable.setLayoutData((Object)gd);
        this.groupExecutable.setFont(font);
        this.createSuiteComponents(this.groupExecutable);
        this.createTestCaseComponents(this.groupExecutable);
    }

    private void createProjectComponents(Composite parent) {
        Font font = parent.getFont();
        Composite projComp = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        projComp.setLayoutData((Object)gd);
        projComp.setFont(font);
        this.projectLabel = new Label(projComp, 0);
        this.projectLabel.setText(MTJUIMessages.JMUnitTab_project_text);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.projectLabel.setLayoutData((Object)gd);
        this.projectLabel.setFont(font);
        this.projectText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.projectText.setLayoutData((Object)gd);
        this.projectText.setFont(font);
        this.projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JMUnitTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.projectButton = this.createPushButton(projComp, MTJUIMessages.JMUnitTab_browse_btn, null);
        this.projectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IJavaProject project = JMUnitTab.this.chooseJavaProject();
                if (project != null) {
                    String projectName = project.getElementName();
                    JMUnitTab.this.projectText.setText(projectName);
                }
            }
        });
    }

    private void createSuiteComponents(Group parent) {
        Font font = parent.getFont();
        this.testSuiteRadio = new Button((Composite)parent, 16);
        this.testSuiteRadio.setText(MTJUIMessages.JMUnitTab_Suite_text);
        this.testSuiteRadio.setSelection(true);
        this.testSuiteRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JMUnitTab.this.updateEnablement();
                JMUnitTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.testSuiteText = new Text((Composite)parent, 2052);
        GridData gd = new GridData(768);
        this.testSuiteText.setLayoutData((Object)gd);
        this.testSuiteText.setFont(font);
        this.testSuiteText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JMUnitTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.testSuiteSearchButton = this.createPushButton((Composite)parent, MTJUIMessages.JMUnitTab_browse_btn, null);
        this.testSuiteSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JMUnitTab.this.handleSuiteSearchButtonSelected();
            }
        });
    }

    private void createTestCaseComponents(Group parent) {
        Font font = parent.getFont();
        this.testCaseRadio = new Button((Composite)parent, 16);
        this.testCaseRadio.setText(MTJUIMessages.JMUnitTab_TestCase_text);
        this.testCaseRadio.setSelection(true);
        this.testCaseRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JMUnitTab.this.updateEnablement();
                JMUnitTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.testCaseText = new Text((Composite)parent, 2052);
        GridData gd = new GridData(768);
        this.testCaseText.setLayoutData((Object)gd);
        this.testCaseText.setFont(font);
        this.testCaseText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JMUnitTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.testCaseSearchButton = this.createPushButton((Composite)parent, MTJUIMessages.JMUnitTab_browse_btn, null);
        this.testCaseSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JMUnitTab.this.handleTestCaseSearchButtonSelected();
            }
        });
    }

    private IJavaProject chooseJavaProject() {
        IJavaProject project = null;
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(MTJUIMessages.JMUnitTab_chooseJavaProject_title);
        dialog.setMessage(MTJUIMessages.JMUnitTab_chooseJavaProject_message);
        try {
            IWorkspaceRoot root = MTJCore.getWorkspace().getRoot();
            dialog.setElements((Object[])JavaCore.create((IWorkspaceRoot)root).getJavaProjects());
        }
        catch (JavaModelException jme) {
            MTJLogger.log((int)2, (Throwable)jme);
        }
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            project = (IJavaProject)dialog.getFirstResult();
        }
        return project;
    }

    protected IJavaProject getJavaProject() {
        IJavaProject javaProject = null;
        String projectName = this.projectText.getText().trim();
        if (projectName.length() > 0) {
            IProject project = MTJCore.getWorkspace().getRoot().getProject(projectName);
            javaProject = JavaCore.create((IProject)project);
        }
        return javaProject;
    }

    private void updateEnablement() {
        boolean doSuite = this.testSuiteRadio.getSelection();
        this.testSuiteText.setEnabled(doSuite);
        this.testSuiteSearchButton.setEnabled(doSuite);
        boolean doTestCase = this.testCaseRadio.getSelection();
        this.testCaseText.setEnabled(doTestCase);
        this.testCaseSearchButton.setEnabled(doTestCase);
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = "";
        try {
            projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException ce) {
            MTJLogger.log((int)2, (String)MTJUIMessages.JMUnitTab_updateProjectFromConfig_error, (Throwable)ce);
        }
        this.projectText.setText(projectName);
    }

    private String getStringOrDefault(ILaunchConfiguration launchConfig, String attributeName, String defaultValue) {
        String value = null;
        try {
            value = launchConfig.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            MTJLogger.log((int)2, (Throwable)e);
            value = defaultValue;
        }
        return value;
    }

    protected void handleSuiteSearchButtonSelected() {
        try {
            IType type;
            Object[] results;
            IJavaProject javaProject = this.getJavaProject();
            SelectionDialog dialog = TestSuiteSelectionDialogCreator.createTestSuiteSelectionDialog(this.getShell(), (IRunnableContext)this.getLaunchConfigurationDialog(), javaProject, false);
            if (dialog.open() == 0 && (results = dialog.getResult()) != null && results.length > 0 && (type = (IType)results[0]) != null) {
                this.testSuiteText.setText(type.getFullyQualifiedName());
                javaProject = type.getJavaProject();
                this.projectText.setText(javaProject.getElementName());
            }
        }
        catch (JavaModelException e) {
            MTJLogger.log((int)4, (String)MTJUIMessages.JMUnitTab_handleSearchTestSuiteButtonSelected_error, (Throwable)e);
        }
    }

    protected void handleTestCaseSearchButtonSelected() {
        try {
            IType type;
            Object[] results;
            IJavaProject javaProject = this.getJavaProject();
            SelectionDialog dialog = TestCaseSelectionDialogCreator.createTestCaseSelectionDialog(this.getShell(), (IRunnableContext)this.getLaunchConfigurationDialog(), javaProject, false);
            if (dialog.open() == 0 && (results = dialog.getResult()) != null && results.length > 0 && (type = (IType)results[0]) != null) {
                this.testCaseText.setText(type.getFullyQualifiedName());
                javaProject = type.getJavaProject();
                this.projectText.setText(javaProject.getElementName());
            }
        }
        catch (JavaModelException e) {
            MTJLogger.log((int)4, (String)MTJUIMessages.JMUnitTab_handleSearchTestCaseButtonSelected_error, (Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.projectText.getText().trim());
        if (this.testCaseRadio.getSelection()) {
            config.setAttribute("mtj.do_test_case_launch", true);
            config.setAttribute("mtj.do_test_suite_launch", false);
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.testCaseText.getText());
        } else if (this.testSuiteRadio.getSelection()) {
            config.setAttribute("mtj.do_test_suite_launch", true);
            config.setAttribute("mtj.do_test_case_launch", false);
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.testSuiteText.getText());
        }
        config.setAttribute("mtj.do_ota", false);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
    }
}

