/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidletLaunchConfigUtils {
    private static List<IType> collectMidletTypesInProject(IProgressMonitor monitor, IJavaProject project) {
        HashSet<IType> result = new HashSet<IType>(5);
        try {
            IType midlet = project.findType("javax.microedition.midlet.MIDlet");
            ITypeHierarchy hierarchy = midlet.newTypeHierarchy(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IType[] types = hierarchy.getAllSubtypes(midlet);
            int length = types.length;
            if (length != 0) {
                int i = 0;
                while (i < length) {
                    if (!types[i].isBinary() && !Flags.isAbstract((int)types[i].getFlags())) {
                        result.add(types[i]);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        monitor.done();
        return new ArrayList<IType>(result);
    }

    private static void collectTypes(Object element, SubProgressMonitor monitor, Set<IType> result) {
        element = MidletLaunchConfigUtils.computeScope(element);
        try {
            while (element instanceof IMember) {
                if (element instanceof IType && Utils.isMidlet((IType)((IType)element), (IProgressMonitor)monitor)) {
                    result.add((IType)element);
                    monitor.done();
                    return;
                }
                element = ((IJavaElement)element).getParent();
            }
            if (element instanceof ICompilationUnit) {
                IType[] types;
                ICompilationUnit cu = (ICompilationUnit)element;
                IType[] iTypeArray = types = cu.getAllTypes();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType element2 = iTypeArray[n2];
                    if (Utils.isMidlet((IType)element2, (IProgressMonitor)monitor)) {
                        result.add(element2);
                    }
                    ++n2;
                }
            } else if (element instanceof IClassFile) {
                IType type = ((IClassFile)element).getType();
                if (Utils.isMidlet((IType)type, (IProgressMonitor)monitor)) {
                    result.add(type);
                }
            } else if (element instanceof IJavaElement) {
                IJavaElement parent = (IJavaElement)element;
                List<IType> found = MidletLaunchConfigUtils.collectMidletTypesInProject((IProgressMonitor)monitor, parent.getJavaProject());
                Iterator<IType> iterator = found.iterator();
                block4: while (iterator.hasNext()) {
                    IJavaElement target;
                    IJavaElement child = target = (IJavaElement)iterator.next();
                    while (child != null) {
                        if (child.equals(parent)) {
                            result.add((IType)target);
                            continue block4;
                        }
                        child = child.getParent();
                    }
                }
            }
        }
        catch (JavaModelException e) {
            MTJLogger.log((int)2, (String)"collectTypes", (Throwable)e);
        }
    }

    private static Object computeScope(Object element) {
        if (element instanceof IJavaElement) {
            return element;
        }
        if (element instanceof IAdaptable) {
            element = ((IAdaptable)element).getAdapter(IResource.class);
        }
        if (element instanceof IResource) {
            IJavaElement javaElement = JavaCore.create((IResource)((IResource)element));
            element = javaElement != null && !javaElement.exists() ? null : javaElement;
        }
        return element;
    }

    public static IType[] findMidlets(IRunnableContext context, final Object[] elements) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Object[] objectArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        MidletLaunchConfigUtils.collectTypes(element, new SubProgressMonitor(monitor, 1), result);
                        ++n2;
                    }
                }
            };
            context.run(true, true, runnable);
        }
        IType[] types = result.toArray(new IType[result.size()]);
        return types;
    }
}

