/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.CodeValidator;
import org.eclipse.mtj.internal.core.build.CodeValidationBuilder;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.IEmbeddableWorkbenchPreferencePage;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeValidationPreferencePage
extends PreferencePage
implements IEmbeddableWorkbenchPreferencePage {
    private static final String SETTINGS_SECTION_NAME = "CodeValidationSettings";
    private static final String SETTINGS_EXPANDED = "expanded";
    private IJavaProject project;
    private List<CodeValidator> codeValidators;
    private List<ExpandableComposite> expandableComposites;
    private List<Map<String, ComboViewer>> markersCombos;

    public CodeValidationPreferencePage() {
        this(MTJUIPlugin.getDefault().getCorePreferenceStore(), null);
    }

    public CodeValidationPreferencePage(IPreferenceStore preferenceStore, IJavaProject project) {
        this.project = project;
        this.setPreferenceStore(preferenceStore);
    }

    public Point computeSize() {
        Point size = super.computeSize();
        size.y = 10;
        return size;
    }

    protected Control createContents(Composite parent) {
        if (this.project != null) {
            this.noDefaultAndApplyButton();
        }
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setFont(parent.getFont());
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(mainPanel);
        ScrolledPageContent scroll = new ScrolledPageContent(mainPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(-1, pixelConverter.convertHeightInCharsToPixels(30)).applyTo((Control)scroll);
        this.codeValidators = new ArrayList<CodeValidator>();
        this.codeValidators.addAll(CodeValidationBuilder.getCodeValidators((IJavaProject)this.project));
        Collections.sort(this.codeValidators, new Comparator<CodeValidator>(){

            @Override
            public int compare(CodeValidator cv1, CodeValidator cv2) {
                return cv1.getValidatorName().compareTo(cv2.getValidatorName());
            }
        });
        this.expandableComposites = new ArrayList<ExpandableComposite>();
        this.markersCombos = new ArrayList<Map<String, ComboViewer>>();
        for (CodeValidator codeValidator : this.codeValidators) {
            this.createCodeValidatorSection(codeValidator, scroll);
        }
        IDialogSettings settings = MTJUIPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION_NAME);
        this.restoreSectionExpansionStates(settings);
        return mainPanel;
    }

    private CodeValidator.Severity readSeverity(IPreferenceStore preferenceStore, CodeValidator codeValidator, String markerID, CodeValidator.Severity defaultValue) {
        String key = this.getMarkerStoreKey(codeValidator, markerID);
        if (preferenceStore.contains(key)) {
            try {
                return CodeValidator.Severity.valueOf((String)preferenceStore.getString(key));
            }
            catch (Throwable throwable) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private String getMarkerStoreKey(CodeValidator codeValidator, String markerID) {
        return String.valueOf(codeValidator.getClass().getName()) + "." + markerID;
    }

    private CodeValidator.Severity getDefaultSeverity(CodeValidator codeValidator, String markerID) {
        if (this.project == null) {
            return codeValidator.getDefaultSeverity(markerID);
        }
        return this.readSeverity(MTJUIPlugin.getDefault().getCorePreferenceStore(), codeValidator, markerID, codeValidator.getDefaultSeverity(markerID));
    }

    private CodeValidator.Severity getSeverity(CodeValidator codeValidator, String markerID) {
        return this.readSeverity(this.getPreferenceStore(), codeValidator, markerID, this.getDefaultSeverity(codeValidator, markerID));
    }

    public void dispose() {
        IDialogSettings settings = MTJUIPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION_NAME);
        this.storeSectionExpansionStates(settings);
        super.dispose();
    }

    private void restoreSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.expandableComposites.size()) {
            ExpandableComposite excomposite = this.expandableComposites.get(i);
            if (settings == null) {
                excomposite.setExpanded(i == 0);
            } else {
                excomposite.setExpanded(settings.getBoolean(SETTINGS_EXPANDED + String.valueOf(i)));
            }
            ++i;
        }
    }

    private void storeSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.expandableComposites.size()) {
            ExpandableComposite expandableComposite = this.expandableComposites.get(i);
            settings.put(SETTINGS_EXPANDED + String.valueOf(i), expandableComposite.isExpanded());
            ++i;
        }
    }

    private void createCodeValidatorSection(CodeValidator codeValidator, final ScrolledPageContent scroll) {
        ExpandableComposite result = new ExpandableComposite(scroll.getBody(), 0, 18);
        result.setText(codeValidator.getValidatorName());
        result.setExpanded(false);
        result.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)result);
        result.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                scroll.reflow(true);
            }
        });
        scroll.adaptChild((Control)result);
        Composite inner = new Composite((Composite)result, 0);
        inner.setFont(scroll.getBody().getFont());
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(5, 5).applyTo(inner);
        result.setClient((Control)inner);
        LinkedHashMap<String, ComboViewer> markerCombos = new LinkedHashMap<String, ComboViewer>();
        for (Map.Entry supportedMarkerConfigurations : codeValidator.getSupportedMarkersConfigurations().entrySet()) {
            String markerID = (String)supportedMarkerConfigurations.getKey();
            markerCombos.put(markerID, this.addComboBox(inner, markerID, codeValidator, (CodeValidator.Severity[])supportedMarkerConfigurations.getValue(), scroll));
        }
        this.expandableComposites.add(result);
        this.markersCombos.add(markerCombos);
    }

    private ComboViewer addComboBox(Composite parent, String markerID, CodeValidator codeValidator, CodeValidator.Severity[] supportedSeverities, ScrolledPageContent scroll) {
        Label label = new Label(parent, 16384);
        label.setFont(JFaceResources.getDialogFont());
        label.setText(MessageFormat.format(MTJUIMessages.CodeValidator_Marker_Label_Pattern, codeValidator.getMarkerName(markerID)));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)label);
        ComboViewer comboViewer = new ComboViewer(parent, 8);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof CodeValidator.Severity) {
                    switch ((CodeValidator.Severity)element) {
                        case ERROR: {
                            return MTJUIMessages.CodeValidator_Severity_Error;
                        }
                        case WARNING: {
                            return MTJUIMessages.CodeValidator_Severity_Warning;
                        }
                        case IGNORE: {
                            return MTJUIMessages.CodeValidator_Severity_Ignore;
                        }
                    }
                }
                return super.getText(element);
            }
        });
        comboViewer.setInput((Object)supportedSeverities);
        Combo comboBox = comboViewer.getCombo();
        comboBox.setFont(JFaceResources.getDialogFont());
        scroll.adaptChild((Control)comboBox);
        comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.getSeverity(codeValidator, markerID)));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)comboBox);
        this.addHighlight(parent, label, comboBox);
        return comboViewer;
    }

    private void addHighlight(final Composite parent, final Label label, final Combo comboBox) {
        comboBox.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                CodeValidationPreferencePage.this.highlight(parent, label, comboBox, 0);
            }

            public void focusGained(FocusEvent e) {
                CodeValidationPreferencePage.this.highlight(parent, label, comboBox, 17);
            }
        });
        MouseTrackAdapter labelComboListener = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                CodeValidationPreferencePage.this.highlight(parent, label, comboBox, comboBox.isEnabled() ? (comboBox.isFocusControl() ? 17 : 18) : 0);
            }

            public void mouseExit(MouseEvent e) {
                if (!comboBox.isFocusControl()) {
                    CodeValidationPreferencePage.this.highlight(parent, label, comboBox, 0);
                }
            }
        };
        comboBox.addMouseTrackListener((MouseTrackListener)labelComboListener);
        label.addMouseTrackListener((MouseTrackListener)labelComboListener);
        HighligherMouseMoveTrackListener parentListener = new HighligherMouseMoveTrackListener(parent, label, comboBox);
        parent.addMouseMoveListener((MouseMoveListener)parentListener);
        parent.addMouseTrackListener((MouseTrackListener)parentListener);
        parent.addMouseListener((MouseListener)parentListener);
        MouseAdapter labelClickListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                comboBox.setFocus();
            }
        };
        label.addMouseListener((MouseListener)labelClickListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void highlight(Composite parent, Label label, Combo comboBox, int color) {
        Object data = label.getData();
        if (data == null) {
            if (color == 0) return;
            HighlightPainter painter = new HighlightPainter(parent, label, comboBox, color);
            parent.addPaintListener((PaintListener)painter);
            label.setData((Object)painter);
        } else if (color == 0) {
            parent.removePaintListener((PaintListener)data);
            label.setData(null);
        } else {
            if (color == ((HighlightPainter)data).getColor()) return;
            ((HighlightPainter)data).setColor(color);
        }
        parent.redraw();
    }

    private boolean usesProjectSpecificSettings(IProject project) {
        return MTJUIPlugin.getCoreProjectPreferenceStore(project).getBoolean("code_validation_use_project");
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.codeValidators.size()) {
            CodeValidator codeValidator = this.codeValidators.get(i);
            Map<String, ComboViewer> markerCombos = this.markersCombos.get(i);
            for (Map.Entry<String, ComboViewer> markerEntry : markerCombos.entrySet()) {
                String markerID = markerEntry.getKey();
                ComboViewer comboViewer = markerEntry.getValue();
                store.setValue(this.getMarkerStoreKey(codeValidator, markerID), ((CodeValidator.Severity)((IStructuredSelection)comboViewer.getSelection()).getFirstElement()).name());
            }
            ++i;
        }
        this.buildSuites();
        return super.performOk();
    }

    @Override
    public void performDefaults() {
        int i = 0;
        while (i < this.codeValidators.size()) {
            CodeValidator codeValidator = this.codeValidators.get(i);
            Map<String, ComboViewer> markerCombos = this.markersCombos.get(i);
            for (Map.Entry<String, ComboViewer> markerEntry : markerCombos.entrySet()) {
                String markerID = markerEntry.getKey();
                ComboViewer comboViewer = markerEntry.getValue();
                comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.getDefaultSeverity(codeValidator, markerID)));
            }
            ++i;
        }
        super.performDefaults();
    }

    @Override
    public void performApply() {
        super.performApply();
    }

    private void buildSuites() {
        ArrayList<IProject> toBuild = new ArrayList<IProject>();
        if (this.project == null) {
            IProject[] projects;
            IWorkspaceRoot root = MTJCore.getWorkspace().getRoot();
            IProject[] iProjectArray = projects = root.getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                try {
                    if (project.isOpen() && project.hasNature("org.eclipse.mtj.core.nature") && !this.usesProjectSpecificSettings(project) && !CodeValidationBuilder.getCodeValidators((IJavaProject)JavaCore.create((IProject)project)).isEmpty()) {
                        toBuild.add(project);
                    }
                }
                catch (CoreException e) {
                    MTJLogger.log((int)4, (String)MTJUIMessages.CodeValidationPreferencePage_error_build_midlet_suite, (Throwable)e);
                }
                ++n2;
            }
        } else {
            toBuild.add(this.project.getProject());
        }
        this.doBuild(toBuild);
    }

    public void doBuild(final List<IProject> toBuild) {
        if (toBuild == null || toBuild.size() == 0) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                for (IProject element : toBuild) {
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, -1);
                    try {
                        try {
                            element.build(6, (IProgressMonitor)subMonitor);
                        }
                        catch (CoreException e) {
                            MTJLogger.log((int)2, (String)MTJUIMessages.CodeValidationPreferencePage_error_build_suite, (Throwable)e);
                            subMonitor.done();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        subMonitor.done();
                        throw throwable;
                    }
                    subMonitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (Throwable t) {
            MTJLogger.log((int)2, (String)MTJUIMessages.CodeValidationPreferencePage_error_build_suite, (Throwable)t);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private class HighligherMouseMoveTrackListener
    extends MouseTrackAdapter
    implements MouseMoveListener,
    MouseListener {
        private Composite parent;
        private Label label;
        private Combo comboBox;

        public HighligherMouseMoveTrackListener(Composite parent, Label label, Combo comboBox) {
            this.parent = parent;
            this.label = label;
            this.comboBox = comboBox;
        }

        public void mouseExit(MouseEvent e) {
            if (!this.comboBox.isFocusControl()) {
                CodeValidationPreferencePage.this.highlight(this.parent, this.label, this.comboBox, 0);
            }
        }

        public void mouseMove(MouseEvent e) {
            int color = this.comboBox.isEnabled() ? (this.comboBox.isFocusControl() ? 17 : (this.isAroundLabel(e) ? 18 : 0)) : 0;
            CodeValidationPreferencePage.this.highlight(this.parent, this.label, this.comboBox, color);
        }

        public void mouseDown(MouseEvent e) {
            if (this.isAroundLabel(e)) {
                this.comboBox.setFocus();
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }

        private boolean isAroundLabel(MouseEvent e) {
            int lx = this.label.getLocation().x;
            Rectangle c = this.comboBox.getBounds();
            int x = e.x;
            int y = e.y;
            boolean isAroundLabel = lx - 5 < x && x < c.x && c.y - 2 < y && y < c.y + c.height + 2;
            return isAroundLabel;
        }
    }

    private static class HighlightPainter
    implements PaintListener {
        private final Composite parent;
        private final Label label;
        private final Combo comboBox;
        private int color;

        public HighlightPainter(Composite parent, Label label, Combo comboBox, int color) {
            this.parent = parent;
            this.label = label;
            this.comboBox = comboBox;
            this.color = color;
        }

        public void paintControl(PaintEvent e) {
            if (((GridData)this.label.getLayoutData()).exclude) {
                this.parent.removePaintListener((PaintListener)this);
                this.label.setData(null);
                return;
            }
            int gap = 7;
            int arrow = 3;
            Rectangle l = this.label.getBounds();
            Point c = this.comboBox.getLocation();
            e.gc.setForeground(e.display.getSystemColor(this.color));
            int x2 = c.x - gap;
            int y = l.y + l.height / 2 + 1;
            e.gc.drawLine(l.x + l.width + gap, y, x2, y);
            e.gc.drawLine(x2 - arrow, y - arrow, x2, y);
            e.gc.drawLine(x2 - arrow, y + arrow, x2, y);
        }

        public int getColor() {
            return this.color;
        }

        public void setColor(int color) {
            this.color = color;
        }
    }

    private class ScrolledPageContent
    extends SharedScrolledComposite {
        private FormToolkit formToolkit;

        public ScrolledPageContent(Composite parent) {
            this(parent, 768);
        }

        public ScrolledPageContent(Composite parent, int style) {
            super(parent, style);
            FormColors colors = new FormColors(Display.getCurrent());
            colors.setBackground(null);
            colors.setForeground(null);
            this.formToolkit = new FormToolkit(colors);
            this.setFont(parent.getFont());
            this.setExpandHorizontal(true);
            this.setExpandVertical(true);
            Composite body = new Composite((Composite)this, 0);
            body.setFont(parent.getFont());
            GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(body);
            this.setContent((Control)body);
        }

        public void adaptChild(Control childControl) {
            this.formToolkit.adapt(childControl, true, true);
        }

        public Composite getBody() {
            return (Composite)this.getContent();
        }
    }
}

