/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.internal.ui.IPreferenceConstants;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editor.text.ColorManager;
import org.eclipse.mtj.internal.ui.preferences.TabFolderLayout;
import org.eclipse.mtj.internal.ui.preferences.XMLSyntaxColorTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class EditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    private ColorManager fColorManager;
    private XMLSyntaxColorTab fXMLTab;

    public EditorPreferencePage() {
        this.setDescription(MTJUIMessages.EditorPreferencePage_description);
        this.fColorManager = new ColorManager();
    }

    public void dispose() {
        this.fColorManager.disposeColors(false);
        this.fXMLTab.dispose();
        super.dispose();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.fXMLTab.performOk();
        try {
            ((IPersistentPreferenceStore)MTJUIPlugin.getDefault().getCorePreferenceStore()).save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.performOk();
    }

    private void createXMLTab(TabFolder folder) {
        this.fXMLTab = new XMLSyntaxColorTab(this.fColorManager);
        TabItem item = new TabItem(folder, 0);
        item.setText(MTJUIMessages.EditorPreferencePage_localization_tab_title);
        item.setControl(this.fXMLTab.createContents((Composite)folder));
    }

    protected Control createContents(Composite parent) {
        final Link link = new Link(parent, 0);
        link.setText(MTJUIMessages.EditorPreferencePage_generalTextEditor_link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)"org.eclipse.ui.preferencePages.GeneralTextEditor", null, null);
            }
        });
        GridData gd = new GridData(32);
        Button foldingButton = new Button(parent, 16480);
        foldingButton.setText(MTJUIMessages.EditorPreferencePage_folding_label);
        foldingButton.setLayoutData((Object)gd);
        foldingButton.setSelection(MTJUIPlugin.getDefault().getPreferenceStore().getBoolean("editor.folding"));
        foldingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPreferenceStore store = MTJUIPlugin.getDefault().getPreferenceStore();
                store.setValue("editor.folding", ((Button)e.getSource()).getSelection());
            }
        });
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        this.createXMLTab(folder);
        Dialog.applyDialogFont((Control)this.getControl());
        return parent;
    }

    protected void performDefaults() {
        this.fXMLTab.performDefaults();
        super.performDefaults();
    }
}

