/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WorkspaceAndExternalFileFieldEditor
extends FieldEditor {
    private static final IStatus ERROR_STATUS = MTJStatusHandler.newStatus((int)4, (int)1, (String)MTJUIMessages.WorkspaceAndExternalFileFieldEditor_error_status_message);
    private static final IStatus OK_STATUS = MTJStatusHandler.newStatus((int)0, (int)0, (String)"");
    private Button browseExternalButton;
    private Button browseWorkspaceButton;
    private Text fileText;
    private String[] filterExtensions;
    private Group group;

    public WorkspaceAndExternalFileFieldEditor(String name, String labelText, String[] filterExtensions, Composite parent) {
        super(name, labelText, parent);
        this.filterExtensions = filterExtensions;
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.group.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void browseExternal() {
        FileDialog dialog = new FileDialog(this.fileText.getShell());
        dialog.setText(MTJUIMessages.WorkspaceAndExternalFileFieldEditor_browseExternal_dialog_text);
        dialog.setFilterExtensions(this.filterExtensions);
        String filename = dialog.open();
        if (filename != null) {
            this.fileText.setText(filename);
        }
    }

    protected void browseWorkspace() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.fileText.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IFile file;
                IStatus status = ERROR_STATUS;
                if (selection.length == 1 && selection[0] instanceof IFile && (file = (IFile)selection[0]).getFullPath().getFileExtension().equals("xml")) {
                    status = OK_STATUS;
                }
                return status;
            }
        };
        dialog.setTitle(MTJUIMessages.WorkspaceAndExternalFileFieldEditor_browseWorkspace_dialog_text);
        dialog.setMessage(MTJUIMessages.WorkspaceAndExternalFileFieldEditor_browseWorkspace_dialog_message);
        dialog.setInput((Object)MTJCore.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.setEmptyListMessage(MTJUIMessages.WorkspaceAndExternalFileFieldEditor_browseWorkspace_dialog_emptyListMessage);
        dialog.setStatusLineAboveButtons(true);
        dialog.setValidator(validator);
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            IFile theFile = (IFile)result[0];
            IPath fullPath = theFile.getFullPath();
            this.fileText.setText(fullPath.toString());
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.group = new Group(parent, 0);
        this.group.setText(this.getLabelText());
        this.group.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        this.group.setLayoutData((Object)gd);
        this.fileText = new Text((Composite)this.group, 2048);
        gd = new GridData(768);
        gd.minimumWidth = 350;
        this.fileText.setLayoutData((Object)gd);
        this.browseWorkspaceButton = new Button((Composite)this.group, 8);
        this.browseWorkspaceButton.setText(MTJUIMessages.WorkspaceAndExternalFileFieldEditor_browseWorkspaceButton_text);
        this.browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceAndExternalFileFieldEditor.this.browseWorkspace();
            }
        });
        this.browseExternalButton = new Button((Composite)this.group, 8);
        this.browseExternalButton.setText(MTJUIMessages.WorkspaceAndExternalFileFieldEditor_browseExternalButton_text);
        this.browseExternalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceAndExternalFileFieldEditor.this.browseExternal();
            }
        });
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }
}

