/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preprocess.contentAssistant;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.IPreprocessContentAssistModel;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessContentAssistMessages;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class PreprocessCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension4 {
    PreprocessContext ppContext;
    Image image;
    IPreprocessContentAssistModel model;
    private String fDisplayString;

    public PreprocessCompletionProposal(IPreprocessContentAssistModel model, PreprocessContext ppContext, Image image) {
        this.model = model;
        this.ppContext = ppContext;
        this.image = image;
    }

    public void apply(IDocument document) {
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        int replaceOffset = this.getReplacementOffset();
        int length = offset - replaceOffset;
        String replacementString = this.getReplacementString();
        try {
            viewer.getDocument().replace(replaceOffset, length, replacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getAdditionalProposalInfo() {
        return this.getJavaDoc();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        if (this.fDisplayString == null) {
            this.fDisplayString = this.model.getName();
            if (this.model.getDescription() != null) {
                Object[] arguments = new String[]{this.model.getName(), this.model.getDescription()};
                this.fDisplayString = PreprocessContentAssistMessages.getFormattedString(PreprocessContentAssistMessages.PreprocessProposal_displayString, arguments);
            }
        }
        return this.fDisplayString;
    }

    public Image getImage() {
        return this.image;
    }

    protected String getJavaDoc() {
        return this.model.getJavaDoc();
    }

    public int getReplacementOffset() {
        return this.ppContext.getCompletionOffset();
    }

    public String getReplacementString() {
        return this.model.getName();
    }

    public Point getSelection(IDocument document) {
        return new Point(this.getReplacementOffset() + this.getReplacementString().length(), 0);
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        boolean valid = false;
        try {
            String content = document.get(this.getReplacementOffset(), offset - this.getReplacementOffset());
            if (this.getReplacementString().toLowerCase().startsWith(content.toLowerCase())) {
                valid = true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return valid;
    }
}

