/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.mtj.ui.editors.jad.IManifestPreferenceStore;

public class ManifestPreferenceStore
implements IManifestPreferenceStore {
    private boolean dirty;
    private String filename;
    private PreferenceStore wrappedPrefStore;

    public ManifestPreferenceStore() {
        this(null);
    }

    public ManifestPreferenceStore(String filename) {
        this.filename = filename;
        this.wrappedPrefStore = new PreferenceStore();
        this.dirty = false;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.wrappedPrefStore.addPropertyChangeListener(listener);
    }

    public boolean contains(String name) {
        return this.wrappedPrefStore.contains(name);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.wrappedPrefStore.firePropertyChangeEvent(name, oldValue, newValue);
    }

    public boolean getBoolean(String name) {
        return this.wrappedPrefStore.getBoolean(name);
    }

    public boolean getDefaultBoolean(String name) {
        return this.wrappedPrefStore.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.wrappedPrefStore.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.wrappedPrefStore.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.wrappedPrefStore.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.wrappedPrefStore.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.wrappedPrefStore.getDefaultString(name);
    }

    public double getDouble(String name) {
        return this.wrappedPrefStore.getDouble(name);
    }

    public float getFloat(String name) {
        return this.wrappedPrefStore.getFloat(name);
    }

    public int getInt(String name) {
        return this.wrappedPrefStore.getInt(name);
    }

    public long getLong(String name) {
        return this.wrappedPrefStore.getLong(name);
    }

    public String getString(String name) {
        return this.wrappedPrefStore.getString(name);
    }

    public boolean isDefault(String name) {
        return this.wrappedPrefStore.isDefault(name);
    }

    public void load() throws IOException {
        if (this.filename == null) {
            throw new IOException("File name not specified");
        }
        FileInputStream in = new FileInputStream(this.filename);
        this.load(in);
        in.close();
    }

    public void load(InputStream in) throws IOException {
        InputStreamReader dataReader = new InputStreamReader(in, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(dataReader);
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            int colonIndex = line.indexOf(58);
            if (colonIndex == -1) continue;
            String name = line.substring(0, colonIndex);
            String value = line.substring(colonIndex + 2);
            this.setValue(name, value);
        }
        this.dirty = false;
    }

    public boolean needsSaving() {
        return this.dirty;
    }

    public String[] preferenceNames() {
        return this.wrappedPrefStore.preferenceNames();
    }

    public void putValue(String name, String value) {
        String oldValue = this.getString(name);
        if (oldValue == null || !oldValue.equals(value)) {
            this.wrappedPrefStore.putValue(name, value);
            this.dirty = true;
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.wrappedPrefStore.removePropertyChangeListener(listener);
    }

    public void save() throws IOException {
        if (this.filename == null) {
            throw new IOException("File name not specified");
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.filename);
            this.save(out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void save(OutputStream out) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(out, "UTF-8");
        PrintWriter writer = new PrintWriter(osw);
        String[] prefNames = this.preferenceNames();
        int i = 0;
        while (i < prefNames.length) {
            String name = prefNames[i];
            String value = this.getString(name);
            if (value.trim().length() > 0) {
                writer.println(String.valueOf(name) + ": " + value);
            }
            ++i;
        }
        writer.flush();
        this.dirty = false;
    }

    public void setDefault(String name, double value) {
        this.wrappedPrefStore.setDefault(name, value);
    }

    public void setDefault(String name, float value) {
        this.wrappedPrefStore.setDefault(name, value);
    }

    public void setDefault(String name, int value) {
        this.wrappedPrefStore.setDefault(name, value);
    }

    public void setDefault(String name, long value) {
        this.wrappedPrefStore.setDefault(name, value);
    }

    public void setDefault(String name, String defaultObject) {
        this.wrappedPrefStore.setDefault(name, defaultObject);
    }

    public void setDefault(String name, boolean value) {
        this.wrappedPrefStore.setDefault(name, value);
    }

    public void setToDefault(String name) {
        this.dirty = true;
        this.wrappedPrefStore.setToDefault(name);
    }

    public void setValue(String name, double value) {
        double oldValue = this.getDouble(name);
        if (value != oldValue) {
            this.dirty = true;
            this.wrappedPrefStore.setValue(name, value);
        }
    }

    public void setValue(String name, float value) {
        float oldValue = this.getFloat(name);
        if (value != oldValue) {
            this.dirty = true;
            this.wrappedPrefStore.setValue(name, value);
        }
    }

    public void setValue(String name, int value) {
        int oldValue = this.getInt(name);
        if (value != oldValue) {
            this.dirty = true;
            this.wrappedPrefStore.setValue(name, value);
        }
    }

    public void setValue(String name, long value) {
        long oldValue = this.getLong(name);
        if (value != oldValue) {
            this.dirty = true;
            this.wrappedPrefStore.setValue(name, value);
        }
    }

    public void setValue(String name, String value) {
        String oldValue = this.getString(name);
        if (oldValue == null || !oldValue.equals(value)) {
            this.dirty = true;
            this.wrappedPrefStore.setValue(name, value);
        }
    }

    public void setValue(String name, boolean value) {
        boolean oldValue = this.getBoolean(name);
        if (value != oldValue) {
            this.dirty = true;
            this.wrappedPrefStore.setValue(name, value);
        }
    }
}

