/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.export.packaging;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.wizards.export.packaging.MTJRuntimeLabelProvider;
import org.eclipse.mtj.internal.ui.wizards.export.packaging.MTJRuntimeListContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidletPackageExportPage
extends WizardPage {
    private List<IJavaProject> fSelectedJavaProjects = new ArrayList<IJavaProject>();
    private Table configurationTable;
    private Table projectsTable;
    private CheckboxTableViewer configurationTableViewer;
    private CheckboxTableViewer projectsTableViewer;
    private Button btnObfuscate;
    private HashMap<IJavaProject, List<MTJRuntime>> selections = new HashMap();
    private Combo destinationFolder;
    private static final int DESTINARTION_HISTORY_LENGTH = 5;
    private static final String SETTINGS_KEY_DESTINATION_NAMES = "MidletPackageExportPage.KEY_DESTINATION_NAMES";
    private static final String SETTINGS_KEY_OVERWRITE_EXISTING_FILES = "MidletPackageExportPage.KEY_OVERWRITE_EXISTING_FILES";
    private static final String SETTINGS_KEY_OBFUSCATE = "MidletPackageExportPage.KEY_OBFUSCATE";
    private Button btnUseDeployedDirectory;
    private Button btnBrowse;

    protected MidletPackageExportPage() {
        super("MidletPackageExportPage");
        this.setTitle(MTJUIMessages.MidletExportPageTitle);
        this.setDescription(MTJUIMessages.MidletExportPageDescription);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout(1, false));
        Composite projectConfigurationGroup = new Composite(workArea, 0);
        projectConfigurationGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        projectConfigurationGroup.setLayout((Layout)new GridLayout(2, true));
        Label lblConfigurations = new Label(projectConfigurationGroup, 0);
        lblConfigurations.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        lblConfigurations.setSize(217, 13);
        lblConfigurations.setText(MTJUIMessages.MidletExportPageConfigurationDescription);
        this.projectsTableViewer = CheckboxTableViewer.newCheckList((Composite)projectConfigurationGroup, (int)67584);
        this.projectsTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IJavaProject project = (IJavaProject)event.getElement();
                if (MidletPackageExportPage.this.selections.containsKey(project)) {
                    MidletPackageExportPage.this.removeSelection(project);
                } else {
                    MidletPackageExportPage.this.addToSelection(project);
                }
                MidletPackageExportPage.this.updateSelectedState();
                MidletPackageExportPage.this.updatePageStatus();
            }
        });
        this.projectsTable = this.projectsTableViewer.getTable();
        this.projectsTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.projectsTableViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getElements(Object element) {
                if (element instanceof IJavaProject[]) {
                    return (IJavaProject[])element;
                }
                return null;
            }
        });
        this.projectsTableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.projectsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MidletPackageExportPage.this.updateSelectedState();
            }
        });
        this.configurationTableViewer = CheckboxTableViewer.newCheckList((Composite)projectConfigurationGroup, (int)67584);
        this.configurationTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MTJRuntime runtime = (MTJRuntime)event.getElement();
                IJavaProject project = MidletPackageExportPage.this.getSelectedProject();
                if (event.getChecked()) {
                    MidletPackageExportPage.this.addToSelection(project, runtime);
                } else {
                    MidletPackageExportPage.this.removeSelection(project, runtime);
                }
                MidletPackageExportPage.this.updateSelectedState();
            }
        });
        this.configurationTable = this.configurationTableViewer.getTable();
        this.configurationTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.configurationTableViewer.setContentProvider((IContentProvider)new MTJRuntimeListContentProvider());
        this.configurationTableViewer.setLabelProvider((IBaseLabelProvider)new MTJRuntimeLabelProvider());
        Group destinationGroup = new Group(workArea, 0);
        destinationGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        destinationGroup.setText(MTJUIMessages.MidletExportPageDestinationDirectoryGroupLabel);
        GridLayout gl_destinationGroup = new GridLayout(3, false);
        destinationGroup.setLayout((Layout)gl_destinationGroup);
        Label lblDestinationDirectory = new Label((Composite)destinationGroup, 0);
        lblDestinationDirectory.setText(MTJUIMessages.MidletExportPageDestinationDirectoryLabel);
        this.destinationFolder = new Combo((Composite)destinationGroup, 0);
        this.destinationFolder.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.destinationFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MidletPackageExportPage.this.updatePageStatus();
            }
        });
        this.btnBrowse = new Button((Composite)destinationGroup, 0);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MidletPackageExportPage.this.handleDestinationButtonBrowseSelected();
            }
        });
        this.btnBrowse.setText(MTJUIMessages.MidletExportPageDestinationDirectoryBrowseButton);
        Link deploymentOption = new Link((Composite)destinationGroup, 0);
        deploymentOption.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        deploymentOption.setText(MTJUIMessages.MidletPackageExportPage_deploymentOption_text);
        deploymentOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)MidletPackageExportPage.this.getShell(), (String)"org.eclipse.mtj.ui.preferences.J2MEPreferencePage", null, null).open();
            }
        });
        this.btnUseDeployedDirectory = new Button((Composite)destinationGroup, 32);
        this.btnUseDeployedDirectory.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.btnUseDeployedDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MidletPackageExportPage.this.btnUseDeployedDirectory.getSelection()) {
                    MidletPackageExportPage.this.destinationFolder.setEnabled(false);
                    MidletPackageExportPage.this.btnBrowse.setEnabled(false);
                } else {
                    MidletPackageExportPage.this.destinationFolder.setEnabled(true);
                    MidletPackageExportPage.this.btnBrowse.setEnabled(true);
                }
                MidletPackageExportPage.this.updatePageStatus();
            }
        });
        this.btnUseDeployedDirectory.setText(MTJUIMessages.MidletExportPageDestinationDirectoryDeploymentOption);
        Group grpOptions = new Group(workArea, 0);
        grpOptions.setText(MTJUIMessages.MidletExportPageOptionsGroupLabel);
        grpOptions.setLayout((Layout)new GridLayout(1, false));
        grpOptions.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        Link proguardPreferencesLink = new Link((Composite)grpOptions, 0);
        proguardPreferencesLink.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        proguardPreferencesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)MidletPackageExportPage.this.getShell(), (String)"org.eclipse.mtj.ui.preferences.J2MEPreferencePage", null, null).open();
                MidletPackageExportPage.this.updatePageStatus();
            }
        });
        proguardPreferencesLink.setText(MTJUIMessages.MidletExportPageObfuscatorOptionPreferencesLink);
        this.btnObfuscate = new Button((Composite)grpOptions, 32);
        this.btnObfuscate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MidletPackageExportPage.this.updatePageStatus();
            }
        });
        this.btnObfuscate.setText(MTJUIMessages.MidletExportPageObfuscatorOptionLabel);
        Dialog.applyDialogFont((Control)parent);
        this.initializeProjects();
        this.restoreWizardValues();
        this.updatePageStatus();
    }

    private void handleDestinationButtonBrowseSelected() {
        DirectoryDialog dialog = new DirectoryDialog(this.getContainer().getShell(), 0x10002000);
        dialog.setMessage(MTJUIMessages.MidletExportPageDestinationDirectoryDialogMessage);
        dialog.setText(MTJUIMessages.MidletExportPageDestinationDirectoryDialogTitle);
        dialog.setFilterPath(this.getDestinationDirectory());
        String selectedDirectoryName = dialog.open();
        if (selectedDirectoryName != null) {
            this.setErrorMessage(null);
            this.destinationFolder.setText(selectedDirectoryName);
        }
    }

    String getDestinationDirectory() {
        return this.destinationFolder.getText().trim();
    }

    private void updatePageStatus() {
        if (this.btnObfuscate.getSelection() && !MTJCore.getProguardJarFile().exists()) {
            this.setErrorMessage(MTJUIMessages.AbstractCreatePackageAction_warnAboutProguardConfiguration_message);
            this.setPageComplete(false);
            return;
        }
        if (this.projectsTableViewer.getCheckedElements().length < 1) {
            this.setPageComplete(false);
            return;
        }
        if (!this.getUseDeployed()) {
            if (this.getUseDeployed() && this.getDestinationDirectory().isEmpty()) {
                this.setErrorMessage(MTJUIMessages.MidletExportPageDestinationNoDirectoryErrorMessage);
                this.setPageComplete(false);
                return;
            }
            File f = new File(this.getDestinationDirectory());
            if (!f.exists()) {
                this.setErrorMessage(MTJUIMessages.MidletExportPageDestinationDirectoryNotExsitsDialogErrorMessage);
                this.setPageComplete(false);
                return;
            }
            if (!f.isDirectory()) {
                this.setErrorMessage(MTJUIMessages.MidletExportPageDestinationDirectoryNotAdirectoryErrormMessage);
                this.setPageComplete(false);
                return;
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void initializeProjects() {
        IJavaProject[] javaProjects;
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        try {
            javaProjects = javaModel.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            javaProjects = new IJavaProject[]{};
        }
        ArrayList<IJavaProject> midlets = new ArrayList<IJavaProject>(javaProjects.length);
        int i = 0;
        while (i < javaProjects.length) {
            if (MidletSuiteFactory.isMidletSuiteProject((IProject)javaProjects[i].getProject())) {
                midlets.add(javaProjects[i]);
            }
            ++i;
        }
        if (midlets.size() > 0) {
            this.projectsTableViewer.setInput((Object)midlets.toArray(new IJavaProject[midlets.size()]));
            this.projectsTableViewer.setSelection((ISelection)new StructuredSelection(midlets.get(0)));
        }
        if (this.fSelectedJavaProjects != null && !this.fSelectedJavaProjects.isEmpty()) {
            for (IJavaProject iJavaProject : this.fSelectedJavaProjects) {
                this.addToSelection(iJavaProject);
            }
            this.updateSelectedState();
        }
        this.projectsTableViewer.getTable().setFocus();
    }

    public void setSelectedProjects(List<IJavaProject> projects) {
        this.fSelectedJavaProjects.addAll(projects);
    }

    private void updateSelectedState() {
        List<Object> runtimes;
        IJavaProject project = this.getSelectedProject();
        if (this.configurationTableViewer.getInput() != project) {
            this.configurationTableViewer.setInput((Object)project);
        }
        if ((runtimes = this.selections.get(project)) == null) {
            runtimes = Collections.emptyList();
        }
        Set<IJavaProject> keySet = this.selections.keySet();
        this.projectsTableViewer.setCheckedElements((Object[])keySet.toArray(new IJavaProject[keySet.size()]));
        this.configurationTableViewer.setCheckedElements((Object[])runtimes.toArray(new MTJRuntime[runtimes.size()]));
    }

    private IJavaProject getSelectedProject() {
        return (IJavaProject)((IStructuredSelection)this.projectsTableViewer.getSelection()).getFirstElement();
    }

    private void addToSelection(IJavaProject project) {
        IMidletSuiteProject msp = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)project);
        MTJRuntimeList list = msp.getRuntimeList();
        this.addToSelection(project, list.getActiveMTJRuntime());
    }

    private void addToSelection(IJavaProject project, MTJRuntime runtime) {
        List<Object> list = this.selections.containsKey(project) ? this.selections.get(project) : new ArrayList();
        if (!list.contains(runtime)) {
            list.add(runtime);
        }
        this.selections.put(project, list);
    }

    private void removeSelection(IJavaProject project) {
        this.selections.remove(project);
    }

    private void removeSelection(IJavaProject project, MTJRuntime runtime) {
        List<MTJRuntime> list = this.selections.get(project);
        if (list != null) {
            list.remove(runtime);
        }
        if (list == null || list.isEmpty()) {
            this.removeSelection(project);
        }
    }

    private void saveWizardValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(SETTINGS_KEY_DESTINATION_NAMES);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationDirectory());
            settings.put(SETTINGS_KEY_DESTINATION_NAMES, directoryNames);
            settings.put(SETTINGS_KEY_OVERWRITE_EXISTING_FILES, this.btnUseDeployedDirectory.getSelection());
            settings.put(SETTINGS_KEY_OBFUSCATE, this.btnObfuscate.getSelection());
        }
    }

    private String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(Arrays.asList(history));
        l.remove(newEntry);
        l.add(0, newEntry);
        if (l.size() > 5) {
            l.remove(5);
        }
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    private void restoreWizardValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(SETTINGS_KEY_DESTINATION_NAMES);
            if (directoryNames != null) {
                int i = 0;
                while (i < directoryNames.length) {
                    this.destinationFolder.add(directoryNames[i]);
                    ++i;
                }
            }
            this.btnObfuscate.setSelection(settings.getBoolean(SETTINGS_KEY_OBFUSCATE));
            boolean useDeployed = settings.getBoolean(SETTINGS_KEY_OVERWRITE_EXISTING_FILES);
            this.btnUseDeployedDirectory.setSelection(useDeployed);
            this.destinationFolder.setEnabled(!useDeployed);
            this.btnBrowse.setEnabled(!useDeployed);
        }
    }

    public void finish() {
        this.saveWizardValues();
    }

    Map<IJavaProject, List<MTJRuntime>> getProjectSelections() {
        return this.selections;
    }

    boolean getObfuscate() {
        return this.btnObfuscate.getSelection();
    }

    boolean getUseDeployed() {
        return this.btnUseDeployedDirectory.getSelection();
    }
}

