/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.importer.common;

import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ILeveledImportStructureProvider;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ProjectImporterMessage;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarException;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarFile;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarLeveledStructureProvider;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ZipLeveledStructureProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ArchiveFileManipulations {
    public static boolean isTarFile(String fileName) {
        block18: {
            if (fileName.length() == 0) {
                return false;
            }
            TarFile tarFile = null;
            try {
                tarFile = new TarFile(fileName);
            }
            catch (TarException tarException) {
                if (tarFile != null) {
                    try {
                        tarFile.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
            catch (IOException iOException) {
                block17: {
                    try {
                        if (tarFile == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (tarFile != null) {
                            try {
                                tarFile.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                    try {
                        tarFile.close();
                    }
                    catch (IOException iOException3) {}
                }
                return false;
            }
            if (tarFile == null) break block18;
            try {
                tarFile.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static boolean isZipFile(String fileName) {
        if (fileName.length() == 0) {
            return false;
        }
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(fileName);
            }
            catch (IOException iOException) {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException2) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static void closeStructureProvider(ILeveledImportStructureProvider structureProvider, Shell shell) {
        if (structureProvider instanceof ZipLeveledStructureProvider) {
            ArchiveFileManipulations.closeZipFile(((ZipLeveledStructureProvider)structureProvider).getZipFile(), shell);
        }
        if (structureProvider instanceof TarLeveledStructureProvider) {
            ArchiveFileManipulations.closeTarFile(((TarLeveledStructureProvider)structureProvider).getTarFile(), shell);
        }
    }

    public static boolean closeZipFile(ZipFile file, Shell shell) {
        try {
            file.close();
        }
        catch (IOException iOException) {
            ArchiveFileManipulations.displayErrorDialog(NLS.bind((String)ProjectImporterMessage.ZipImport_couldNotClose, (Object)file.getName()), shell);
            return false;
        }
        return true;
    }

    public static boolean closeTarFile(TarFile file, Shell shell) {
        try {
            file.close();
        }
        catch (IOException iOException) {
            ArchiveFileManipulations.displayErrorDialog(NLS.bind((String)ProjectImporterMessage.ZipImport_couldNotClose, (Object)file.getName()), shell);
            return false;
        }
        return true;
    }

    protected static void displayErrorDialog(final String message, final Shell shell) {
        Runnable runnable = new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)shell, (String)ArchiveFileManipulations.getErrorDialogTitle(), (String)message);
            }
        };
        shell.getDisplay().syncExec(runnable);
    }

    protected static String getErrorDialogTitle() {
        return ProjectImporterMessage.WizardImportPage_internalErrorTitle;
    }
}

