/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.importer.common;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.ClassPathDetector;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteProject;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ArchiveFileManipulations;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ArchiveUtils;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ILeveledImportStructureProvider;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ProjectImporter;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ProjectImporterMessage;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ProjectRecord;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarException;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarFile;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarLeveledStructureProvider;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ZipLeveledStructureProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class ImportProjectWizardPage
extends WizardPage
implements IOverwriteQuery {
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    private static String previouslyBrowsedArchive = "";
    private static String previouslyBrowsedDirectory = "";
    private static final String STORE_ARCHIVE_SELECTED = "ProjectImportWizard.STORE_ARCHIVE_SELECTED";
    private Text archivePathField;
    private Button browseArchivesButton;
    private Button browseDirectoriesButton;
    private Text directoryPathField;
    private ProjectRecord[] foundProjects = new ProjectRecord[0];
    private ProjectImporter importer;
    private long lastModified;
    private String lastPath;
    private String productName;
    private Button projectFromArchiveRadio;
    private Button projectFromDirectoryRadio;
    private CheckboxTreeViewer projectsList;
    private ILeveledImportStructureProvider structureProvider;
    private IProject[] wsProjects;

    public ImportProjectWizardPage(ProjectImporter importer, String productName) {
        this("wizardExternalProjectsPage", importer, productName);
    }

    public ImportProjectWizardPage(String pageName, ProjectImporter importer, String productName) {
        super(pageName);
        this.importer = importer;
        this.productName = productName;
        this.setPageComplete(false);
        this.setTitle(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_ImportProjectsTitle, (Object)productName));
        this.setDescription(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_ImportProjectsDescription, (Object)productName));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createProjectsList(workArea);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)workArea);
    }

    public boolean createProjects() {
        this.saveWidgetValues();
        final Object[] selected = this.projectsList.getCheckedElements();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("", selected.length);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    int i = 0;
                    while (i < selected.length) {
                        ImportProjectWizardPage.this.createExistingProject((ProjectRecord)selected[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ++i;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String message = ProjectImporterMessage.WizardExternalProjectImportPage_errorMessage;
            Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "org.eclipse.mtj.ui", 1, message, t);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
            return false;
        }
        ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
        return true;
    }

    public ProjectRecord[] getFoundProjects() {
        return this.foundProjects;
    }

    public Button getProjectFromDirectoryRadio() {
        return this.projectFromDirectoryRadio;
    }

    public CheckboxTreeViewer getProjectsList() {
        return this.projectsList;
    }

    public void performCancel() {
        ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
    }

    public String queryOverwrite(String pathString) {
        Path path = new Path(pathString);
        String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)ProjectImporterMessage.WizardDataTransfer_existsQuestion, (Object)pathString) : NLS.bind((String)ProjectImporterMessage.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), ProjectImporterMessage.Question, null, messageString, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }

    public void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            boolean archiveSelected = settings.getBoolean(STORE_ARCHIVE_SELECTED);
            this.projectFromDirectoryRadio.setSelection(!archiveSelected);
            this.projectFromArchiveRadio.setSelection(archiveSelected);
            if (archiveSelected) {
                this.archiveRadioSelected();
            } else {
                this.directoryRadioSelected();
            }
        }
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_ARCHIVE_SELECTED, this.projectFromArchiveRadio.getSelection());
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setFocus();
        }
        if (visible && this.projectFromArchiveRadio.getSelection()) {
            this.archivePathField.setFocus();
        }
    }

    public void updateProjectsList(final String path) {
        if (path == null || path.length() == 0) {
            this.foundProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements((Object[])this.foundProjects);
            this.checkPageComplete();
            this.lastPath = path;
            return;
        }
        final File directory = new File(path);
        long modified = directory.lastModified();
        if (path.equals(this.lastPath) && this.lastModified == modified) {
            return;
        }
        this.lastPath = path;
        this.lastModified = modified;
        final boolean dirSelected = this.projectFromDirectoryRadio.getSelection();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(ProjectImporterMessage.WizardProjectsImportPage_SearchingMessage, 100);
                    ImportProjectWizardPage.this.foundProjects = new ProjectRecord[0];
                    if (!dirSelected) {
                        if (ArchiveFileManipulations.isTarFile(path)) {
                            TarFile sourceTarFile = ImportProjectWizardPage.this.getSpecifiedTarSourceFile(path);
                            if (sourceTarFile == null) {
                                return;
                            }
                            ImportProjectWizardPage.this.structureProvider = new TarLeveledStructureProvider(sourceTarFile);
                        } else if (ArchiveFileManipulations.isZipFile(path)) {
                            ZipFile sourceFile = ImportProjectWizardPage.this.getSpecifiedZipSourceFile(path);
                            if (sourceFile == null) {
                                return;
                            }
                            ImportProjectWizardPage.this.structureProvider = new ZipLeveledStructureProvider(sourceFile);
                        }
                        ImportProjectWizardPage.this.foundProjects = ImportProjectWizardPage.this.importer.searchProjectsFromProvider(ImportProjectWizardPage.this.structureProvider, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100).newChild(100));
                    } else if (dirSelected && directory.isDirectory()) {
                        ImportProjectWizardPage.this.foundProjects = ImportProjectWizardPage.this.importer.searchProjectsFromDirectory(directory, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100).newChild(100));
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            MTJLogger.log((int)4, (String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        this.projectsList.setCheckedElements((Object[])this.foundProjects);
        this.checkPageComplete();
    }

    private void archiveRadioSelected() {
        if (this.projectFromArchiveRadio.getSelection()) {
            this.directoryPathField.setEnabled(false);
            this.browseDirectoriesButton.setEnabled(false);
            this.archivePathField.setEnabled(true);
            this.browseArchivesButton.setEnabled(true);
            this.updateProjectsList(this.archivePathField.getText());
            this.archivePathField.setFocus();
        }
    }

    private void checkPageComplete() {
        Object[] objectArray = this.projectsList.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            ProjectRecord project = (ProjectRecord)element;
            if (this.isProjectInWorkspace(project.getProjectName())) {
                this.setMessage(NLS.bind((String)ProjectImporterMessage.ImportProjectWizardPage_ProjectAlreadyInWorkpace, (Object)project.getProjectName()), 3);
                this.setPageComplete(false);
                return;
            }
            ++n2;
        }
        this.setMessage(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_ImportProjectsDescription, (Object)this.productName));
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
    }

    private boolean createExistingProject(ProjectRecord record, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String projectName = record.getProjectName();
        IWorkspace workspace = MTJCore.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        IProjectDescription newProjectDescription = workspace.newProjectDescription(projectName);
        try {
            ImportOperation operation;
            monitor.beginTask(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_CreateProjectTask, (Object)record.getProjectName()), 100);
            JavaCapabilityConfigurationPage.createProject((IProject)project, (URI)newProjectDescription.getLocationURI(), (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            if (record.getProvider() == null) {
                Path locationPath = new Path(new File(record.getProjectRoot()).getAbsolutePath());
                File importSource = locationPath.toFile();
                if (!Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                    List filesToImport = FileSystemStructureProvider.INSTANCE.getChildren((Object)importSource);
                    operation = new ImportOperation(project.getFullPath(), (Object)importSource, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, filesToImport);
                    operation.setContext(this.getShell());
                    operation.setOverwriteResources(true);
                    operation.setCreateContainerStructure(false);
                    operation.run((IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    monitor.worked(50);
                    this.importer.projectCreated(record, project, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                }
            } else {
                Object root = ArchiveUtils.getChild(record.getProvider(), record.getProvider().getRoot(), record.getProjectRoot());
                List fileSystemObjects = record.getProvider().getChildren(root);
                int stripLevel = ArchiveUtils.guessStripLevel(record.getProjectRoot());
                record.getProvider().setStrip(stripLevel);
                operation = new ImportOperation(project.getFullPath(), record.getProvider().getRoot(), (IImportStructureProvider)record.getProvider(), (IOverwriteQuery)this, fileSystemObjects);
                operation.setContext(this.getShell());
                operation.run(monitor);
                this.importer.projectCreated(record, project, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            }
            monitor.setTaskName(ProjectImporterMessage.WizardProjectsImportPage_ProcessingMessage);
            project.refreshLocal(2, null);
            ClassPathDetector detector = new ClassPathDetector(project, null);
            JavaCapabilityConfigurationPage javaPropPage = new JavaCapabilityConfigurationPage();
            javaPropPage.init(JavaCore.create((IProject)project), detector.getOutputLocation(), detector.getClasspath(), false);
            javaPropPage.configureJavaProject(null);
            this.removeJ2SELibraries(javaPropPage.getJavaProject(), monitor);
            IDevice device = this.importer.getProjectDevice(record);
            MidletSuiteFactory.MidletSuiteCreationRunnable builder = MidletSuiteFactory.getMidletSuiteCreationRunnable((IProject)project, (IJavaProject)javaPropPage.getJavaProject(), (IMIDPDevice)((IMIDPDevice)device), (String)MidletSuiteProject.getDefaultJadFileName((IProject)project));
            builder.run(monitor);
            project.build(6, monitor);
            monitor.done();
        }
        catch (CoreException e) {
            try {
                project.delete(true, monitor);
            }
            catch (CoreException coreException) {}
            throw new InvocationTargetException(e);
        }
        return true;
    }

    private void createProjectsList(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText(ProjectImporterMessage.WizardProjectsImportPage_ProjectsListTitle);
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.projectsList = new CheckboxTreeViewer(listComposite, 2048);
        GridData listData = new GridData(1808);
        this.projectsList.getControl().setLayoutData((Object)listData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return ImportProjectWizardPage.this.getFoundProjects();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ProjectRecord)element).getProjectLabel();
            }
        });
        this.projectsList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImportProjectWizardPage.this.checkPageComplete();
            }
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(listComposite);
    }

    private void createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.projectFromDirectoryRadio = new Button(projectGroup, 16);
        this.projectFromDirectoryRadio.setText(ProjectImporterMessage.WizardProjectsImportPage_RootSelectTitle);
        this.directoryPathField = new Text(projectGroup, 2048);
        this.directoryPathField.setLayoutData((Object)new GridData(768));
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText(ProjectImporterMessage.DataTransfer_browse);
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.projectFromArchiveRadio = new Button(projectGroup, 16);
        this.projectFromArchiveRadio.setText(ProjectImporterMessage.WizardProjectsImportPage_ArchiveSelectTitle);
        this.archivePathField = new Text(projectGroup, 2048);
        this.archivePathField.setLayoutData((Object)new GridData(768));
        this.browseArchivesButton = new Button(projectGroup, 8);
        this.browseArchivesButton.setText(ProjectImporterMessage.DataTransfer_browse);
        this.setButtonLayoutData(this.browseArchivesButton);
        this.projectFromDirectoryRadio.setSelection(true);
        this.archivePathField.setEnabled(false);
        this.browseArchivesButton.setEnabled(false);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectWizardPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        this.browseArchivesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectWizardPage.this.handleLocationArchiveButtonPressed();
            }
        });
        this.directoryPathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.directoryPathField.getText().trim());
                }
            }
        });
        this.directoryPathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.directoryPathField.getText().trim());
            }
        });
        this.archivePathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.archivePathField.getText().trim());
                }
            }
        });
        this.archivePathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.archivePathField.getText().trim());
            }
        });
        this.projectFromDirectoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectWizardPage.this.directoryRadioSelected();
            }
        });
        this.projectFromArchiveRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectWizardPage.this.archiveRadioSelected();
            }
        });
    }

    private void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(ProjectImporterMessage.DataTransfer_selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectWizardPage.this.projectsList.setCheckedElements((Object[])ImportProjectWizardPage.this.foundProjects);
                ImportProjectWizardPage.this.checkPageComplete();
            }
        });
        Dialog.applyDialogFont((Control)selectAll);
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(ProjectImporterMessage.DataTransfer_deselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectWizardPage.this.projectsList.setCheckedElements(new Object[0]);
                ImportProjectWizardPage.this.checkPageComplete();
            }
        });
        Dialog.applyDialogFont((Control)deselectAll);
        this.setButtonLayoutData(deselectAll);
        Button refresh = new Button(buttonsComposite, 8);
        refresh.setText(ProjectImporterMessage.DataTransfer_refresh);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ImportProjectWizardPage.this.projectFromDirectoryRadio.getSelection()) {
                    ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.directoryPathField.getText().trim());
                } else {
                    ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.archivePathField.getText().trim());
                }
            }
        });
        Dialog.applyDialogFont((Control)refresh);
        this.setButtonLayoutData(refresh);
    }

    private void directoryRadioSelected() {
        if (this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setEnabled(true);
            this.browseDirectoriesButton.setEnabled(true);
            this.archivePathField.setEnabled(false);
            this.browseArchivesButton.setEnabled(false);
            this.updateProjectsList(this.directoryPathField.getText());
            this.directoryPathField.setFocus();
        }
    }

    private void displayErrorMessageDialog(final String title, final String message) {
        Runnable runnable = new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)ImportProjectWizardPage.this.getShell(), (String)title, (String)message);
            }
        };
        this.getShell().getDisplay().syncExec(runnable);
    }

    private IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = MTJCore.getWorkspace().getRoot().getProjects();
        }
        return this.wsProjects;
    }

    private TarFile getSpecifiedTarSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new TarFile(fileName);
        }
        catch (TarException tarException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.TarImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    private ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.ZipImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    private boolean isJ2SELibraryEntry(IClasspathEntry entry) {
        boolean isJ2SEEntry = false;
        if (entry.getEntryKind() == 1) {
            if (entry.getPath().lastSegment().equals("JRE_LIB")) {
                isJ2SEEntry = true;
            }
        } else if (entry.getEntryKind() == 5 && entry.getPath().lastSegment().equals("org.eclipse.jdt.launching.JRE_CONTAINER")) {
            isJ2SEEntry = true;
        }
        return isJ2SEEntry;
    }

    private boolean isProjectInWorkspace(String projectName) {
        if (projectName == null) {
            return false;
        }
        IProject[] workspaceProjects = this.getProjectsInWorkspace();
        int i = 0;
        while (i < workspaceProjects.length) {
            if (projectName.equals(workspaceProjects[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void removeJ2SELibraries(IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < entries.length) {
            if (!this.isJ2SELibraryEntry(entries[i])) {
                list.add(entries[i]);
            }
            ++i;
        }
        entries = list.toArray(new IClasspathEntry[list.size()]);
        javaProject.setRawClasspath(entries, monitor);
    }

    protected void handleLocationArchiveButtonPressed() {
        FileDialog dialog = new FileDialog(this.archivePathField.getShell());
        dialog.setFilterExtensions(FILE_IMPORT_MASK);
        dialog.setText(ProjectImporterMessage.WizardProjectsImportPage_SelectArchiveDialogTitle);
        String fileName = this.archivePathField.getText().trim();
        if (fileName.length() == 0) {
            fileName = previouslyBrowsedArchive;
        }
        if (fileName.length() == 0) {
            dialog.setFilterPath(MTJCore.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(fileName).getParentFile();
            if (path != null && path.exists()) {
                dialog.setFilterPath(path.toString());
            }
        }
        String selectedArchive = dialog.open();
        if (selectedArchive != null) {
            previouslyBrowsedArchive = selectedArchive;
            this.archivePathField.setText(previouslyBrowsedArchive);
            this.updateProjectsList(selectedArchive);
        }
    }

    protected void handleLocationDirectoryButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell());
        dialog.setMessage(ProjectImporterMessage.WizardProjectsImportPage_SelectDialogTitle);
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(MTJCore.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
            this.updateProjectsList(selectedDirectory);
        }
    }
}

