/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.importer.eclipseme;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.midp.ProjectConvertionException;
import org.eclipse.mtj.internal.core.project.midp.MTJProjectConverter;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ArchiveFileManipulations;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ILeveledImportStructureProvider;
import org.eclipse.mtj.internal.ui.wizards.importer.common.StatusUtil;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarEntry;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarException;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarFile;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarLeveledStructureProvider;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ZipLeveledStructureProvider;
import org.eclipse.mtj.internal.ui.wizards.importer.eclipseme.ProjectImporterMessage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportEclipseMEProjectWizardPage
extends WizardPage
implements IOverwriteQuery {
    private static final String EclipseME_NATURE = "eclipseme.core.nature";
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    private static final String METADATA_FOLDER = ".metadata";
    private static String previouslyBrowsedArchive = "";
    private static String previouslyBrowsedDirectory = "";
    private static final String STORE_ARCHIVE_SELECTED = "EclipseMEProjectImportWizard.STORE_ARCHIVE_SELECTED";
    private Text archivePathField;
    private Button browseArchivesButton;
    private Button browseDirectoriesButton;
    private Text directoryPathField;
    private long lastModified;
    private String lastPath;
    private Button projectFromArchiveRadio;
    private Button projectFromDirectoryRadio;
    private CheckboxTreeViewer projectsList;
    private ProjectRecord[] selectedProjects = new ProjectRecord[0];
    private boolean showProjectInWorkspaceWorning = false;
    private ILeveledImportStructureProvider structureProvider;
    private IProject[] wsProjects;

    public ImportEclipseMEProjectWizardPage() {
        this("wizardExternalProjectsPage");
    }

    public ImportEclipseMEProjectWizardPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.setTitle(ProjectImporterMessage.WizardProjectsImportPage_ImportProjectsTitle);
        this.setDescription(ProjectImporterMessage.WizardProjectsImportPage_ImportProjectsDescription);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createProjectsList(workArea);
        this.createOptionsArea(workArea);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)workArea);
    }

    public boolean createProjects() {
        this.saveWidgetValues();
        final Object[] selected = this.projectsList.getCheckedElements();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("", selected.length);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    Object[] objectArray = selected;
                    int n = selected.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        ImportEclipseMEProjectWizardPage.this.createExistingProject((ProjectRecord)element, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ++n2;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String message = ProjectImporterMessage.WizardExternalProjectImportPage_errorMessage;
            Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "org.eclipse.mtj.ui", 1, message, t);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
            return false;
        }
        ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
        return true;
    }

    public Button getProjectFromDirectoryRadio() {
        return this.projectFromDirectoryRadio;
    }

    public CheckboxTreeViewer getProjectsList() {
        return this.projectsList;
    }

    public ProjectRecord[] getValidProjects() {
        ArrayList<ProjectRecord> validProjects = new ArrayList<ProjectRecord>();
        int i = 0;
        while (i < this.selectedProjects.length) {
            boolean projectInWorkspace;
            boolean projectNotInWorkspace = !this.isProjectInWorkspace(this.selectedProjects[i].getProjectName());
            boolean isEclipseMEProject = this.isEclipseMEProject(this.selectedProjects[i]);
            if (projectNotInWorkspace && isEclipseMEProject) {
                validProjects.add(this.selectedProjects[i]);
            }
            boolean bl = projectInWorkspace = !projectNotInWorkspace;
            if (projectInWorkspace && isEclipseMEProject) {
                this.showProjectInWorkspaceWorning = true;
            }
            ++i;
        }
        return validProjects.toArray(new ProjectRecord[validProjects.size()]);
    }

    public void performCancel() {
        ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
    }

    public String queryOverwrite(String pathString) {
        Path path = new Path(pathString);
        String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)ProjectImporterMessage.WizardDataTransfer_existsQuestion, (Object)pathString) : NLS.bind((String)ProjectImporterMessage.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), ProjectImporterMessage.Question, null, messageString, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }

    public void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            boolean archiveSelected = settings.getBoolean(STORE_ARCHIVE_SELECTED);
            this.projectFromDirectoryRadio.setSelection(!archiveSelected);
            this.projectFromArchiveRadio.setSelection(archiveSelected);
            if (archiveSelected) {
                this.archiveRadioSelected();
            } else {
                this.directoryRadioSelected();
            }
        }
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_ARCHIVE_SELECTED, this.projectFromArchiveRadio.getSelection());
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setFocus();
        }
        if (visible && this.projectFromArchiveRadio.getSelection()) {
            this.archivePathField.setFocus();
        }
    }

    public void updateProjectsList(final String path) {
        if (path == null || path.length() == 0) {
            this.setMessage(ProjectImporterMessage.WizardProjectsImportPage_ImportProjectsDescription);
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements((Object[])this.selectedProjects);
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
            this.lastPath = path;
            return;
        }
        final File directory = new File(path);
        long modified = directory.lastModified();
        if (path.equals(this.lastPath) && this.lastModified == modified) {
            return;
        }
        this.lastPath = path;
        this.lastModified = modified;
        final boolean dirSelected = this.projectFromDirectoryRadio.getSelection();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(ProjectImporterMessage.WizardProjectsImportPage_SearchingMessage, 100);
                    ImportEclipseMEProjectWizardPage.this.selectedProjects = new ProjectRecord[0];
                    ArrayList projectRecords = new ArrayList();
                    monitor.worked(10);
                    if (!dirSelected && ArchiveFileManipulations.isTarFile(path)) {
                        TarFile sourceTarFile = ImportEclipseMEProjectWizardPage.this.getSpecifiedTarSourceFile(path);
                        if (sourceTarFile == null) {
                            return;
                        }
                        ImportEclipseMEProjectWizardPage.this.structureProvider = new TarLeveledStructureProvider(sourceTarFile);
                        Object child = ImportEclipseMEProjectWizardPage.this.structureProvider.getRoot();
                        if (!ImportEclipseMEProjectWizardPage.this.collectProjectFilesFromProvider(projectRecords, child, 0, monitor)) {
                            return;
                        }
                        Iterator filesIterator = projectRecords.iterator();
                        ImportEclipseMEProjectWizardPage.this.selectedProjects = new ProjectRecord[projectRecords.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(ProjectImporterMessage.WizardProjectsImportPage_ProcessingMessage);
                        while (filesIterator.hasNext()) {
                            ((ImportEclipseMEProjectWizardPage)ImportEclipseMEProjectWizardPage.this).selectedProjects[index++] = (ProjectRecord)filesIterator.next();
                        }
                    } else if (!dirSelected && ArchiveFileManipulations.isZipFile(path)) {
                        ZipFile sourceFile = ImportEclipseMEProjectWizardPage.this.getSpecifiedZipSourceFile(path);
                        if (sourceFile == null) {
                            return;
                        }
                        ImportEclipseMEProjectWizardPage.this.structureProvider = new ZipLeveledStructureProvider(sourceFile);
                        Object child = ImportEclipseMEProjectWizardPage.this.structureProvider.getRoot();
                        if (!ImportEclipseMEProjectWizardPage.this.collectProjectFilesFromProvider(projectRecords, child, 0, monitor)) {
                            return;
                        }
                        Iterator filesIterator = projectRecords.iterator();
                        ImportEclipseMEProjectWizardPage.this.selectedProjects = new ProjectRecord[projectRecords.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(ProjectImporterMessage.WizardProjectsImportPage_ProcessingMessage);
                        while (filesIterator.hasNext()) {
                            ((ImportEclipseMEProjectWizardPage)ImportEclipseMEProjectWizardPage.this).selectedProjects[index++] = (ProjectRecord)filesIterator.next();
                        }
                    } else if (dirSelected && directory.isDirectory()) {
                        ArrayList files = new ArrayList();
                        if (!ImportEclipseMEProjectWizardPage.this.collectProjectFilesFromDirectory(files, directory, null, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        ImportEclipseMEProjectWizardPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask(ProjectImporterMessage.WizardProjectsImportPage_ProcessingMessage);
                        while (filesIterator.hasNext()) {
                            File file = (File)filesIterator.next();
                            ((ImportEclipseMEProjectWizardPage)ImportEclipseMEProjectWizardPage.this).selectedProjects[index] = new ProjectRecord(file);
                            ++index;
                        }
                    } else {
                        monitor.worked(60);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            MTJLogger.log((int)4, (String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        this.projectsList.setCheckedElements((Object[])this.getValidProjects());
        if (this.showProjectInWorkspaceWorning) {
            this.setMessage(ProjectImporterMessage.WizardProjectsImportPage_projectsInWorkspace, 2);
        } else {
            this.setMessage(ProjectImporterMessage.WizardProjectsImportPage_ImportProjectsDescription);
        }
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
    }

    private void archiveRadioSelected() {
        if (this.projectFromArchiveRadio.getSelection()) {
            this.directoryPathField.setEnabled(false);
            this.browseDirectoriesButton.setEnabled(false);
            this.archivePathField.setEnabled(true);
            this.browseArchivesButton.setEnabled(true);
            this.updateProjectsList(this.archivePathField.getText());
            this.archivePathField.setFocus();
        }
    }

    private boolean collectProjectFilesFromDirectory(Collection<File> files, File directory, Set<String> directoriesVisited, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_CheckingMessage, (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        if (contents == null) {
            return false;
        }
        if (directoriesVisited == null) {
            directoriesVisited = new HashSet<String>();
            try {
                directoriesVisited.add(directory.getCanonicalPath());
            }
            catch (IOException exception) {
                StatusManager.getManager().handle(StatusUtil.newStatus(4, exception.getLocalizedMessage(), exception));
            }
        }
        File[] fileArray = contents;
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && file.getName().equals(".project")) {
                files.add(file);
                return true;
            }
            ++n2;
        }
        int i = 0;
        while (i < contents.length) {
            block12: {
                if (contents[i].isDirectory() && !contents[i].getName().equals(METADATA_FOLDER)) {
                    block11: {
                        try {
                            String canonicalPath = contents[i].getCanonicalPath();
                            if (directoriesVisited.add(canonicalPath)) break block11;
                            break block12;
                        }
                        catch (IOException exception) {
                            StatusManager.getManager().handle(StatusUtil.newStatus(4, exception.getLocalizedMessage(), exception));
                        }
                    }
                    this.collectProjectFilesFromDirectory(files, contents[i], directoriesVisited, monitor);
                }
            }
            ++i;
        }
        return true;
    }

    private boolean collectProjectFilesFromProvider(Collection<ProjectRecord> files, Object entry, int level, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_CheckingMessage, (Object)this.structureProvider.getLabel(entry)));
        ArrayList children = this.structureProvider.getChildren(entry);
        if (children == null) {
            children = new ArrayList(1);
        }
        for (Object child : children) {
            String elementLabel;
            if (this.structureProvider.isFolder(child)) {
                this.collectProjectFilesFromProvider(files, child, level + 1, monitor);
            }
            if (!(elementLabel = this.structureProvider.getLabel(child)).equals(".project")) continue;
            files.add(new ProjectRecord(child, entry, level));
        }
        return true;
    }

    private boolean createExistingProject(ProjectRecord record, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String projectName = record.getProjectName();
        IWorkspace workspace = MTJCore.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (!this.isEclipseMEProject(record)) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardProjectsImportPage_NotEclipseMEProject_Title, NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_NotEclipseMEProject_Message, (Object)projectName));
            return false;
        }
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            Path locationPath = new Path(record.projectSystemFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.description.setLocation(null);
            } else {
                record.description.setLocation((IPath)locationPath);
            }
        } else {
            record.description.setName(projectName);
        }
        if (record.projectArchiveFile != null) {
            List fileSystemObjects = this.structureProvider.getChildren(record.parent);
            this.structureProvider.setStrip(record.level);
            ImportOperation operation = new ImportOperation(project.getFullPath(), this.structureProvider.getRoot(), (IImportStructureProvider)this.structureProvider, (IOverwriteQuery)this, fileSystemObjects);
            operation.setContext(this.getShell());
            operation.run(monitor);
            try {
                MTJProjectConverter.getInstance().convertEclipseMeProject(project, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                return true;
            }
            catch (ProjectConvertionException e) {
                throw new InvocationTargetException(e);
            }
        }
        File importSource = null;
        URI locationURI = record.description.getLocationURI();
        if (locationURI != null) {
            importSource = new File(locationURI);
            IProjectDescription desc = workspace.newProjectDescription(projectName);
            desc.setBuildSpec(record.description.getBuildSpec());
            desc.setComment(record.description.getComment());
            desc.setDynamicReferences(record.description.getDynamicReferences());
            desc.setNatureIds(record.description.getNatureIds());
            desc.setReferencedProjects(record.description.getReferencedProjects());
            record.description = desc;
        }
        try {
            monitor.beginTask(ProjectImporterMessage.WizardProjectsImportPage_CreateProjectsTask, 100);
            project.create(record.description, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        if (importSource != null) {
            List filesToImport = FileSystemStructureProvider.INSTANCE.getChildren((Object)importSource);
            ImportOperation operation = new ImportOperation(project.getFullPath(), (Object)importSource, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, filesToImport);
            operation.setContext(this.getShell());
            operation.setOverwriteResources(true);
            operation.setCreateContainerStructure(false);
            operation.run((IProgressMonitor)new SubProgressMonitor(monitor, 20));
            try {
                MTJProjectConverter.getInstance().convertEclipseMeProject(project, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
            catch (ProjectConvertionException e) {
                throw new InvocationTargetException(e);
            }
        }
        return true;
    }

    private void createOptionsArea(Composite workArea) {
        Composite optionsGroup = new Composite(workArea, 0);
        optionsGroup.setLayout((Layout)new GridLayout());
        optionsGroup.setLayoutData((Object)new GridData(768));
    }

    private void createProjectsList(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText(ProjectImporterMessage.WizardProjectsImportPage_ProjectsListTitle);
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.projectsList = new CheckboxTreeViewer(listComposite, 2048);
        GridData listData = new GridData(1808);
        this.projectsList.getControl().setLayoutData((Object)listData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return ImportEclipseMEProjectWizardPage.this.getValidProjects();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ProjectRecord)element).getProjectLabel();
            }
        });
        this.projectsList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImportEclipseMEProjectWizardPage.this.setPageComplete(ImportEclipseMEProjectWizardPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(listComposite);
    }

    private void createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.projectFromDirectoryRadio = new Button(projectGroup, 16);
        this.projectFromDirectoryRadio.setText(ProjectImporterMessage.WizardProjectsImportPage_RootSelectTitle);
        this.directoryPathField = new Text(projectGroup, 2048);
        this.directoryPathField.setLayoutData((Object)new GridData(768));
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText(ProjectImporterMessage.DataTransfer_browse);
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.projectFromArchiveRadio = new Button(projectGroup, 16);
        this.projectFromArchiveRadio.setText(ProjectImporterMessage.WizardProjectsImportPage_ArchiveSelectTitle);
        this.archivePathField = new Text(projectGroup, 2048);
        this.archivePathField.setLayoutData((Object)new GridData(768));
        this.browseArchivesButton = new Button(projectGroup, 8);
        this.browseArchivesButton.setText(ProjectImporterMessage.DataTransfer_browse);
        this.setButtonLayoutData(this.browseArchivesButton);
        this.projectFromDirectoryRadio.setSelection(true);
        this.archivePathField.setEnabled(false);
        this.browseArchivesButton.setEnabled(false);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportEclipseMEProjectWizardPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        this.browseArchivesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportEclipseMEProjectWizardPage.this.handleLocationArchiveButtonPressed();
            }
        });
        this.directoryPathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    ImportEclipseMEProjectWizardPage.this.updateProjectsList(ImportEclipseMEProjectWizardPage.this.directoryPathField.getText().trim());
                }
            }
        });
        this.directoryPathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ImportEclipseMEProjectWizardPage.this.updateProjectsList(ImportEclipseMEProjectWizardPage.this.directoryPathField.getText().trim());
            }
        });
        this.archivePathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    ImportEclipseMEProjectWizardPage.this.updateProjectsList(ImportEclipseMEProjectWizardPage.this.archivePathField.getText().trim());
                }
            }
        });
        this.archivePathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ImportEclipseMEProjectWizardPage.this.updateProjectsList(ImportEclipseMEProjectWizardPage.this.archivePathField.getText().trim());
            }
        });
        this.projectFromDirectoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportEclipseMEProjectWizardPage.this.directoryRadioSelected();
            }
        });
        this.projectFromArchiveRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportEclipseMEProjectWizardPage.this.archiveRadioSelected();
            }
        });
    }

    private void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(ProjectImporterMessage.DataTransfer_selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportEclipseMEProjectWizardPage.this.projectsList.setCheckedElements((Object[])ImportEclipseMEProjectWizardPage.this.selectedProjects);
                ImportEclipseMEProjectWizardPage.this.setPageComplete(ImportEclipseMEProjectWizardPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        Dialog.applyDialogFont((Control)selectAll);
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(ProjectImporterMessage.DataTransfer_deselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportEclipseMEProjectWizardPage.this.projectsList.setCheckedElements(new Object[0]);
                ImportEclipseMEProjectWizardPage.this.setPageComplete(false);
            }
        });
        Dialog.applyDialogFont((Control)deselectAll);
        this.setButtonLayoutData(deselectAll);
        Button refresh = new Button(buttonsComposite, 8);
        refresh.setText(ProjectImporterMessage.DataTransfer_refresh);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ImportEclipseMEProjectWizardPage.this.projectFromDirectoryRadio.getSelection()) {
                    ImportEclipseMEProjectWizardPage.this.updateProjectsList(ImportEclipseMEProjectWizardPage.this.directoryPathField.getText().trim());
                } else {
                    ImportEclipseMEProjectWizardPage.this.updateProjectsList(ImportEclipseMEProjectWizardPage.this.archivePathField.getText().trim());
                }
            }
        });
        Dialog.applyDialogFont((Control)refresh);
        this.setButtonLayoutData(refresh);
    }

    private void directoryRadioSelected() {
        if (this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setEnabled(true);
            this.browseDirectoriesButton.setEnabled(true);
            this.archivePathField.setEnabled(false);
            this.browseArchivesButton.setEnabled(false);
            this.updateProjectsList(this.directoryPathField.getText());
            this.directoryPathField.setFocus();
        }
    }

    private void displayErrorMessageDialog(final String title, final String message) {
        Runnable runnable = new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)ImportEclipseMEProjectWizardPage.this.getShell(), (String)title, (String)message);
            }
        };
        this.getShell().getDisplay().syncExec(runnable);
    }

    private IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = MTJCore.getWorkspace().getRoot().getProjects();
        }
        return this.wsProjects;
    }

    private TarFile getSpecifiedTarSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new TarFile(fileName);
        }
        catch (TarException tarException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.TarImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    private ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.ZipImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    private boolean isEclipseMEProject(ProjectRecord record) {
        return record.description.hasNature(EclipseME_NATURE);
    }

    private boolean isProjectInWorkspace(String projectName) {
        IProject[] workspaceProjects;
        if (projectName == null) {
            return false;
        }
        IProject[] iProjectArray = workspaceProjects = this.getProjectsInWorkspace();
        int n = workspaceProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject element = iProjectArray[n2];
            if (projectName.equals(element.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void handleLocationArchiveButtonPressed() {
        FileDialog dialog = new FileDialog(this.archivePathField.getShell());
        dialog.setFilterExtensions(FILE_IMPORT_MASK);
        dialog.setText(ProjectImporterMessage.WizardProjectsImportPage_SelectArchiveDialogTitle);
        String fileName = this.archivePathField.getText().trim();
        if (fileName.length() == 0) {
            fileName = previouslyBrowsedArchive;
        }
        if (fileName.length() == 0) {
            dialog.setFilterPath(MTJCore.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(fileName).getParentFile();
            if (path != null && path.exists()) {
                dialog.setFilterPath(path.toString());
            }
        }
        String selectedArchive = dialog.open();
        if (selectedArchive != null) {
            previouslyBrowsedArchive = selectedArchive;
            this.archivePathField.setText(previouslyBrowsedArchive);
            this.updateProjectsList(selectedArchive);
        }
    }

    protected void handleLocationDirectoryButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell());
        dialog.setMessage(ProjectImporterMessage.WizardProjectsImportPage_SelectDialogTitle);
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(MTJCore.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
            this.updateProjectsList(selectedDirectory);
        }
    }

    public class ProjectRecord {
        IProjectDescription description;
        int level;
        Object parent;
        Object projectArchiveFile;
        String projectName;
        File projectSystemFile;

        ProjectRecord(File file) {
            this.projectSystemFile = file;
            this.setProjectName();
        }

        ProjectRecord(Object file, Object parent, int level) {
            this.projectArchiveFile = file;
            this.parent = parent;
            this.level = level;
            this.setProjectName();
        }

        public String getProjectLabel() {
            if (this.description == null) {
                return this.projectName;
            }
            String path = this.projectSystemFile == null ? ImportEclipseMEProjectWizardPage.this.structureProvider.getLabel(this.parent) : this.projectSystemFile.getParent();
            return NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_projectLabel, (Object)this.projectName, (Object)path);
        }

        public String getProjectName() {
            return this.projectName;
        }

        private boolean isDefaultLocation(IPath path) {
            if (path.segmentCount() < 2) {
                return false;
            }
            return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
        }

        private void setProjectName() {
            try {
                if (this.projectArchiveFile != null) {
                    InputStream stream = ImportEclipseMEProjectWizardPage.this.structureProvider.getContents(this.projectArchiveFile);
                    if (stream == null) {
                        if (this.projectArchiveFile instanceof ZipEntry) {
                            Path path = new Path(((ZipEntry)this.projectArchiveFile).getName());
                            this.projectName = path.segment(path.segmentCount() - 2);
                        } else if (this.projectArchiveFile instanceof TarEntry) {
                            Path path = new Path(((TarEntry)this.projectArchiveFile).getName());
                            this.projectName = path.segment(path.segmentCount() - 2);
                        }
                    } else {
                        this.description = MTJCore.getWorkspace().loadProjectDescription(stream);
                        stream.close();
                        this.projectName = this.description.getName();
                    }
                }
                if (this.projectName == null) {
                    Path path = new Path(this.projectSystemFile.getPath());
                    if (this.isDefaultLocation((IPath)path)) {
                        this.projectName = path.segment(path.segmentCount() - 2);
                        this.description = MTJCore.getWorkspace().newProjectDescription(this.projectName);
                    } else {
                        this.description = MTJCore.getWorkspace().loadProjectDescription((IPath)path);
                        this.projectName = this.description.getName();
                    }
                }
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }
    }
}

