/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text.l10n;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;

public class L10nLocales
extends L10nObject {
    private static final long serialVersionUID = 1L;
    private L10nLocale defaultLocale;

    public L10nLocales(L10nModel l10nModel) {
        super(l10nModel, "locales");
        this.setInTheModel(true);
    }

    public void addChild(L10nObject l10nObject) {
        this.addChildNode((IDocumentElementNode)l10nObject, true);
    }

    public void addChild(L10nObject l10nObject, L10nObject l10nObject2, boolean bl) {
        int n = this.indexOf(l10nObject2);
        if (!bl) {
            ++n;
        }
        this.addChildNode(l10nObject, n, true);
    }

    public boolean canBeParent() {
        return true;
    }

    public String getDestination() {
        return this.getXMLAttributeValue("destination");
    }

    public L10nLocale getDefaultLocale() {
        IDocumentElementNode[] iDocumentElementNodeArray;
        String string = this.getXMLAttributeValue("default-locale");
        IDocumentElementNode[] iDocumentElementNodeArray2 = iDocumentElementNodeArray = this.getChildNodes();
        int n = iDocumentElementNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode iDocumentElementNode = iDocumentElementNodeArray2[n2];
            L10nLocale l10nLocale = (L10nLocale)iDocumentElementNode;
            if (l10nLocale.getName().equals(string)) {
                this.defaultLocale = l10nLocale;
                break;
            }
            ++n2;
        }
        return this.defaultLocale;
    }

    public String getName() {
        return "Locales";
    }

    public String getPackage() {
        String string = this.getXMLAttributeValue("package");
        return string == null ? "" : string;
    }

    public int getType() {
        return 0;
    }

    public boolean isRoot() {
        return true;
    }

    public void moveChild(L10nObject l10nObject, int n) {
        this.moveChildNode(l10nObject, n, true);
    }

    public void removeChild(L10nObject l10nObject) {
        this.removeChildNode(l10nObject, true);
    }

    public void setDestination(String string) {
        this.setXMLAttribute("destination", string);
    }

    public void setPackage(String string) {
        this.setXMLAttribute("package", string);
    }

    public void setDefaultLocale(L10nLocale l10nLocale) {
        String string = null;
        if (l10nLocale != null) {
            string = l10nLocale.getName();
        }
        this.setXMLAttribute("default-locale", string);
        this.defaultLocale = l10nLocale;
    }

    /*
     * WARNING - void declaration
     */
    public void validate() {
        void l10nLocale;
        IDocumentElementNode[] iDocumentElementNodeArray = this.getChildNodes();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean n = false;
        while (l10nLocale < iDocumentElementNodeArray.length) {
            L10nLocale l10nLocale2 = (L10nLocale)iDocumentElementNodeArray[l10nLocale];
            l10nLocale2.validate();
            String string = l10nLocale2.getName();
            if (!arrayList.contains(l10nLocale2)) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < iDocumentElementNodeArray.length) {
                    L10nLocale l10nLocale3 = (L10nLocale)iDocumentElementNodeArray[n2];
                    String string2 = l10nLocale3.getLocaleName();
                    if (n2 != l10nLocale && string.equalsIgnoreCase(string2)) {
                        arrayList.add(l10nLocale3);
                        bl = true;
                    }
                    ++n2;
                }
                if (bl) {
                    arrayList.add(l10nLocale2);
                }
            }
            ++l10nLocale;
        }
        for (L10nLocale l10nLocale4 : arrayList) {
            l10nLocale4.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", "Duplicated Locale"));
            l10nLocale4.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", "Duplicated Locale"));
        }
    }
}

