/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.build;

import java.util.LinkedHashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CodeValidator
extends ASTVisitor {
    private IResource validatedResource;
    private IEclipsePreferences preferences;

    public final void validate(ICompilationUnit compilationUnit) {
        if (compilationUnit != null) {
            this.validatedResource = compilationUnit.getResource();
            ProjectScope projectScope = new ProjectScope(this.validatedResource.getProject());
            IEclipsePreferences projectPrefs = projectScope.getNode("org.eclipse.mtj.core");
            this.preferences = projectPrefs.getBoolean("code_validation_use_project", false) ? projectPrefs : InstanceScope.INSTANCE.getNode(MTJCore.getPluginId());
            ASTParser parser = ASTParser.newParser((int)8);
            parser.setKind(8);
            parser.setSource(compilationUnit);
            parser.setResolveBindings(true);
            ASTNode root = parser.createAST(null);
            root.accept((ASTVisitor)this);
        }
    }

    public abstract boolean supportsValidationFor(IMidletSuiteProject var1);

    protected final void createMarker(String message, ASTNode node, int lineNumber, String markerID) throws CoreException {
        Severity severity = this.getSeverity(markerID);
        if (severity != Severity.IGNORE) {
            IMarker marker = this.validatedResource.createMarker("org.eclipse.mtj.core.problem.validation");
            int startPosition = node.getStartPosition();
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity.getValue());
            marker.setAttribute("charStart", startPosition);
            marker.setAttribute("charEnd", startPosition + node.getLength());
            marker.setAttribute("lineNumber", lineNumber);
        }
    }

    public abstract Severity getDefaultSeverity(String var1);

    public abstract Severity[] getSupportedSeverities(String var1);

    public abstract String getValidatorName();

    public abstract String[] getMarkerIDs();

    public final LinkedHashMap<String, Severity[]> getSupportedMarkersConfigurations() {
        LinkedHashMap<String, Severity[]> result = new LinkedHashMap<String, Severity[]>();
        String[] stringArray = this.getMarkerIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String markerID = stringArray[n2];
            String groupMarkerID = this.getGroupMarkerID(markerID);
            String configurableMarkerID = groupMarkerID == null ? markerID : groupMarkerID;
            Severity[] supportedSeverities = this.getSupportedSeverities(configurableMarkerID);
            if (supportedSeverities != null && supportedSeverities.length > 0) {
                result.put(configurableMarkerID, supportedSeverities);
            }
            ++n2;
        }
        return result;
    }

    public abstract String getGroupMarkerID(String var1);

    public abstract String getMarkerName(String var1);

    private Severity getSeverity(String markerID) {
        Severity defaultSeverity;
        String groupMarkerID = this.getGroupMarkerID(markerID);
        if (groupMarkerID != null) {
            markerID = groupMarkerID;
        }
        if ((defaultSeverity = this.getDefaultSeverity(markerID)) == null) {
            defaultSeverity = Severity.IGNORE;
        }
        try {
            return Severity.valueOf(this.preferences.get(String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + markerID, defaultSeverity.name()));
        }
        catch (Throwable throwable) {
            return defaultSeverity;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        ERROR(2),
        WARNING(1),
        IGNORE(-1);

        private int value;

        private Severity(int severity) {
            this.value = severity;
        }

        int getValue() {
            return this.value;
        }
    }
}

