/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.project.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.runtime.event.IMTJRuntimeChangeListener;
import org.eclipse.mtj.core.project.runtime.event.MTJRuntimeDeviceChangeEvent;
import org.eclipse.mtj.core.project.runtime.event.MTJRuntimeNameChangeEvent;
import org.eclipse.mtj.core.project.runtime.event.MTJRuntimeWorkspaceSymbolSetsChangeEvent;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.project.runtime.MTJRuntimeListUtils;
import org.eclipse.mtj.internal.core.symbol.SymbolSet;
import org.eclipse.mtj.internal.core.symbol.SymbolUtils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJRuntime {
    public static final String ATTR_DEVICEGROUP = "group";
    public static final String ATTR_DEVICENAME = "name";
    public static final String ATTR_RUNTIMEACTIVE = "active";
    public static final String ATTR_RUNTIMENAME = "name";
    public static final String ATTR_SYMBOL_SET_NAME = "name";
    public static final String ATTR_SYMBOLNAME = "name";
    public static final String ATTR_WORKSPACESYMBOLSETNAME = "name";
    public static final String ATTR_SYMBOLVALUE = "value";
    public static final String ATTR_SDK_ID = "id";
    public static final String ATTR_SDK_PROPERTY_NAME = "name";
    public static final String ATTR_SDK_PROPERTY_VALUE = "value";
    public static final String ELEM_CONFIGURATION = "configuration";
    public static final String ELEM_DEVICE = "device";
    public static final String ELEM_SYMBOL = "symbol";
    public static final String ELEM_SYMBOL_SET = "symbolSet";
    public static final String ELEM_WORKSPACE_SYMBOLSET = "workspaceSymbolSet";
    public static final String ELEM_SDK_PROVIDER_PROPERTIES = "sdkProviderProperties";
    public static final String ELEM_SDK = "sdk";
    public static final String ELEM_SDK_PROPERTY = "property";
    private boolean active;
    private IDevice device;
    private List<IMTJRuntimeChangeListener> listeners = new ArrayList<IMTJRuntimeChangeListener>();
    private String name;
    private ISymbolSet symbolSet;
    private List<ISymbolSet> workspaceScopeSymbolSets;
    private boolean isMatched = false;

    public MTJRuntime(Element configElement, Set<String> existingConfigNames) throws PersistenceException {
        this.name = configElement.getAttribute("name");
        this.active = Boolean.valueOf(configElement.getAttribute(ATTR_RUNTIMEACTIVE));
        this.loadDevice(configElement, existingConfigNames);
        this.loadSymbolSet(configElement);
        this.loadWorkspaceSymbolSets(configElement);
    }

    public MTJRuntime(String name) {
        this.name = name;
    }

    public void addMTJRuntimeChangeListener(IMTJRuntimeChangeListener listener) {
        this.listeners.add(listener);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MTJRuntime other = (MTJRuntime)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public void fireSymbolSetChanged() {
        for (IMTJRuntimeChangeListener listener : this.listeners) {
            listener.symbolSetChanged();
        }
    }

    public IDevice getDevice() {
        return this.device;
    }

    public String getName() {
        return this.name;
    }

    public ISymbolSet getSymbolSet() {
        if (this.symbolSet == null) {
            SymbolSet deviceSymbolSet = (SymbolSet)this.device.getSymbolSet();
            try {
                this.symbolSet = (ISymbolSet)deviceSymbolSet.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this.symbolSet = new SymbolSet();
                this.symbolSet.setName(this.getName());
            }
        }
        return this.symbolSet;
    }

    public ISymbolSet getSymbolSetForPreprocessing() {
        ISymbolSet symbolSetForPreprocessing = MTJCore.getSymbolSetFactory().createSymbolSet(String.valueOf(this.getSymbolSet().getName()) + " For Preprocessing");
        symbolSetForPreprocessing.add(this.symbolSet.getSymbols());
        String configName = this.getName().replace(' ', '_');
        configName = SymbolUtils.replaceFirstNonLetterChar(configName);
        symbolSetForPreprocessing.add(configName, Boolean.TRUE.toString(), 1);
        return symbolSetForPreprocessing;
    }

    public List<ISymbolSet> getWorkspaceScopeSymbolSets() {
        if (this.workspaceScopeSymbolSets == null) {
            this.workspaceScopeSymbolSets = new ArrayList<ISymbolSet>();
        }
        return this.workspaceScopeSymbolSets;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean isActive() {
        return this.active;
    }

    public void removeMTJRuntimeChangeListener(IMTJRuntimeChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setDevice(IDevice device) {
        if (this.device == device) {
            return;
        }
        IDevice oldDevice = this.device;
        this.device = device;
        this.symbolSet = device.getSymbolSet();
        MTJRuntimeDeviceChangeEvent event = new MTJRuntimeDeviceChangeEvent(this, oldDevice, device);
        for (IMTJRuntimeChangeListener listener : this.listeners) {
            listener.deviceChanged(event);
        }
    }

    public void setName(String name) {
        if (this.name.equals(name)) {
            return;
        }
        String oldName = this.name;
        this.name = name;
        MTJRuntimeNameChangeEvent event = new MTJRuntimeNameChangeEvent(this, oldName, name);
        for (IMTJRuntimeChangeListener listener : this.listeners) {
            listener.nameChanged(event);
        }
    }

    public void setSymbolSet(ISymbolSet symbolSet) {
        this.symbolSet = symbolSet;
    }

    public void setWorkspaceScopeSymbolSets(List<ISymbolSet> symbolSets) {
        if (MTJRuntimeListUtils.workspaceSymbolsetsEquals(this.workspaceScopeSymbolSets, symbolSets)) {
            return;
        }
        List<ISymbolSet> oldSets = this.workspaceScopeSymbolSets;
        this.workspaceScopeSymbolSets = symbolSets;
        MTJRuntimeWorkspaceSymbolSetsChangeEvent event = new MTJRuntimeWorkspaceSymbolSetsChangeEvent(this, oldSets, symbolSets);
        for (IMTJRuntimeChangeListener listener : this.listeners) {
            listener.workspaceScopeSymbolSetsChanged(event);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append("name=").append(this.name).append("|active=").append(this.active).append("|device=").append(this.device.getName()).append("|symbolSet=").append(this.symbolSet);
        return sb.toString();
    }

    private void loadDevice(Element configElement, Set<String> existingConfigNames) throws PersistenceException {
        String[] matched;
        String deviceName;
        String deviceGroup;
        Element deviceElement = XMLUtils.getFirstElementWithTagName(configElement, ELEM_DEVICE);
        if (deviceElement != null && !this.loadDevice(deviceGroup = deviceElement.getAttribute(ATTR_DEVICEGROUP), deviceName = deviceElement.getAttribute("name")) && (matched = MTJRuntimeListUtils.match(this.name, deviceGroup, deviceName, existingConfigNames)) != null && this.loadDevice(matched[1], matched[2])) {
            this.name = matched[0];
            MTJLogger.log(1, String.valueOf(deviceGroup) + "/" + deviceName + " was converted to " + this.device.toString());
            this.isMatched = true;
        }
    }

    private boolean loadDevice(String deviceGroup, String deviceName) throws PersistenceException {
        this.device = MTJCore.getDeviceRegistry().getDevice(deviceGroup, deviceName);
        return this.device != null;
    }

    private void loadSymbolSet(Element configElement) {
        this.symbolSet = new SymbolSet();
        Element symbolSetElement = XMLUtils.getFirstElementWithTagName(configElement, ELEM_SYMBOL_SET);
        if (!symbolSetElement.getAttribute("name").equals("")) {
            this.symbolSet.setName(symbolSetElement.getAttribute("name"));
        } else if (this.device != null) {
            this.symbolSet.setName(this.device.getName());
        }
        NodeList symbols = symbolSetElement.getElementsByTagName(ELEM_SYMBOL);
        int i = 0;
        while (i < symbols.getLength()) {
            Element symbolElement = (Element)symbols.item(i);
            String symbolName = symbolElement.getAttribute("name");
            String symbolValue = symbolElement.getAttribute("value");
            this.symbolSet.add(symbolName, symbolValue);
            ++i;
        }
    }

    private void loadWorkspaceSymbolSets(Element configElement) throws PersistenceException {
        NodeList symbolSets = configElement.getElementsByTagName(ELEM_WORKSPACE_SYMBOLSET);
        if (symbolSets == null || symbolSets.getLength() == 0) {
            return;
        }
        this.workspaceScopeSymbolSets = new ArrayList<ISymbolSet>();
        int i = 0;
        while (i < symbolSets.getLength()) {
            Element symbolSet = (Element)symbolSets.item(i);
            String symbolSetName = symbolSet.getAttribute("name");
            ISymbolSet definitionSet = MTJCore.getSymbolSetRegistry().getSymbolSet(symbolSetName);
            if (definitionSet != null) {
                this.workspaceScopeSymbolSets.add(definitionSet);
            }
            ++i;
        }
    }

    public boolean isMatched() {
        return this.isMatched;
    }
}

