/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core;

import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceAccessor {
    public static final PreferenceAccessor instance = new PreferenceAccessor();
    public static final String MULTI_VALUE_SEPARATOR = "|";
    private IEclipsePreferences defaultPreferences = new DefaultScope().getNode("org.eclipse.mtj.core");
    private IEclipsePreferences instancePreferences = new InstanceScope().getNode("org.eclipse.mtj.core");

    private PreferenceAccessor() {
    }

    public String getDefaultProguardOptions() {
        return this.defaultPreferences.get("proguard_options", "");
    }

    public boolean getAutoversionPackage(IProject project) {
        IEclipsePreferences preferences = this.getProjectPreferences(project, "pkg_use_project", "pkg_autoversion");
        return preferences.getBoolean("pkg_autoversion", false);
    }

    public String[] getExcludedManifestProperties(IProject project) {
        IEclipsePreferences preferences = this.getProjectPreferences(project, "pkg_use_project", "pkg_excluded_props");
        String value = preferences.get("pkg_excluded_props", "MIDlet-Jar-URL|MIDlet-Jar-Size|LIBlet-Jar-URL|LIBlet-Jar-Size");
        return this.parseMultiValuedPreferenceValue(value);
    }

    public String getPreprecessorDebuglevel(IProject project) {
        IEclipsePreferences preferences = this.getProjectPreferences(project, "preprocess_use_project", "preprocess_debuglevel");
        String value = preferences.get("preprocess_debuglevel", "debug");
        return value;
    }

    public Version getPreverificationConfigurationVersion(IProject project) throws CoreException {
        Version version = null;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IMidletSuiteProject suite = MidletSuiteFactory.getMidletSuiteProject(javaProject);
        IEclipsePreferences preferences = this.getProjectPreferences(project, "pkg_use_project", "preverify_config_location");
        String location = preferences.get("preverify_config_location", "platform");
        if ("jad".equals(location)) {
            IApplicationDescriptor jad = suite.getApplicationDescriptor();
            version = jad.getConfigurationSpecificationVersion();
        } else if ("platform".equals(location)) {
            IMIDPAPI api;
            version = new Version("1.0");
            IMIDPDevice device = (IMIDPDevice)suite.getRuntimeList().getActiveMTJRuntime().getDevice();
            if (device != null && (api = device.getCLDCAPI()) != null) {
                version = api.getVersion();
            }
        } else {
            String[] split;
            String identifierOrVersion = preferences.get("preverify_config_value", "");
            if (identifierOrVersion.startsWith("CLDC") && (split = identifierOrVersion.split("-")).length == 2) {
                identifierOrVersion = split[1];
                version = new Version(identifierOrVersion);
            }
        }
        if (version == null) {
            version = new Version("1.0");
        }
        return version;
    }

    public String[] getProguardKeepExpressions(IProject project) {
        IEclipsePreferences preferences = this.getProjectPreferences(project, "obfuscate_use_project", "proguard_keep");
        String value = preferences.get("proguard_keep", "public class * extends javax.microedition.midlet.MIDlet");
        return this.parseMultiValuedPreferenceValue(value);
    }

    public String getSpecifiedProguardOptions(IProject project) {
        String options = null;
        IEclipsePreferences preferences = this.getProjectPreferences(project, "obfuscate_use_project", "proguard_options");
        options = preferences.get("proguard_options", "-dontusemixedcaseclassnames -dontnote -defaultpackage ''");
        if (preferences.getBoolean("obfuscate_use_project", false)) {
            String[] array;
            StringBuffer buffer = new StringBuffer();
            String[] stringArray = array = options.split(" ");
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                if (Pattern.matches("@.+", option)) {
                    String config = option.substring(1);
                    option = NLS.bind((String)"@{0}", (Object)project.getLocation().append(config).toOSString());
                }
                buffer.append(" ").append(option);
                ++n2;
            }
            options = buffer.toString().trim();
        }
        return options;
    }

    public boolean isUseSpecifiedProguardOptions(IProject project) {
        IEclipsePreferences preferences = this.getProjectPreferences(project, "obfuscate_use_project", "proguard_use_specified");
        return preferences.getBoolean("proguard_use_specified", false);
    }

    public String getPreverifierType(IProject project) {
        IEclipsePreferences preferences = this.getProjectPreferences(project, "pkg_use_project", "preverify_type");
        return preferences.get("preverify_type", "preverify_emulator");
    }

    private IEclipsePreferences getProjectPreferences(IProject project, String projectSpecificKey, String preferenceKey) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences prefNode = projectScope.getNode("org.eclipse.mtj.core");
        boolean useProjectSpecific = prefNode.getBoolean(projectSpecificKey, false);
        IEclipsePreferences iEclipsePreferences = prefNode = useProjectSpecific ? prefNode : this.instancePreferences;
        if (prefNode.get(preferenceKey, null) == null) {
            prefNode = this.defaultPreferences;
        }
        return prefNode;
    }

    private String[] parseMultiValuedPreferenceValue(String value) {
        StringTokenizer st = new StringTokenizer(value, MULTI_VALUE_SEPARATOR);
        int count = st.countTokens();
        String[] names = new String[count];
        int i = 0;
        while (i < count) {
            names[i] = st.nextToken();
            ++i;
        }
        return names;
    }

    public String getString(String key) {
        String str = this.instancePreferences.get(key, null);
        return str != null ? str : this.defaultPreferences.get(key, "");
    }

    public boolean getBoolean(String key) {
        if (this.containsKey(this.instancePreferences, key)) {
            return this.instancePreferences.getBoolean(key, false);
        }
        return this.defaultPreferences.getBoolean(key, false);
    }

    public int getInt(String key) {
        if (this.containsKey(this.instancePreferences, key)) {
            return this.instancePreferences.getInt(key, 0);
        }
        return this.defaultPreferences.getInt(key, 0);
    }

    private boolean containsKey(IEclipsePreferences prefs, String key) {
        String[] keys;
        if (key == null) {
            return false;
        }
        try {
            keys = prefs.keys();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            return false;
        }
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (key.equals(str)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

