/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.build.BuildSpecManipulator;
import org.eclipse.mtj.internal.core.build.BuildStateMachine;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class MTJCompilationParticipant
extends CompilationParticipant {
    public int aboutToBuild(IJavaProject project) {
        try {
            IMidletSuiteProject mtjProject = MidletSuiteFactory.getMidletSuiteProject(project);
            BuildStateMachine stateMachine = BuildStateMachine.getInstance(mtjProject);
            NullProgressMonitor monitor = new NullProgressMonitor();
            BuildSpecManipulator manipulator = new BuildSpecManipulator(mtjProject.getProject());
            if (manipulator.isFirstBuilder("org.eclipse.jdt.core.javabuilder")) {
                stateMachine.start((IProgressMonitor)monitor);
            }
            if (stateMachine.getCurrentState() != null) {
                stateMachine.changeState(MTJBuildState.PRE_COMPILATION, (IProgressMonitor)monitor);
            }
        }
        catch (CoreException e) {
            MTJLogger.log(4, e);
        }
        return super.aboutToBuild(project);
    }

    public void buildFinished(IJavaProject project) {
        try {
            IMidletSuiteProject mtjProject = MidletSuiteFactory.getMidletSuiteProject(project);
            BuildStateMachine stateMachine = BuildStateMachine.getInstance(mtjProject);
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (stateMachine.getCurrentState() != null) {
                stateMachine.changeState(MTJBuildState.POST_COMPILATION, (IProgressMonitor)monitor);
                BuildSpecManipulator manipulator = new BuildSpecManipulator(mtjProject.getProject());
                if (manipulator.isLastBuilder("org.eclipse.jdt.core.javabuilder")) {
                    stateMachine.changeState(MTJBuildState.POST_BUILD, (IProgressMonitor)monitor);
                }
            }
        }
        catch (CoreException e) {
            MTJLogger.log(4, e);
        }
        super.buildFinished(project);
    }

    public boolean isActive(IJavaProject project) {
        boolean result = false;
        try {
            result = project.getProject().hasNature("org.eclipse.mtj.core.nature");
        }
        catch (CoreException e) {
            MTJLogger.log(4, e);
        }
        return result;
    }
}

