/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.export.states;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.internal.core.build.export.AntennaExportException;
import org.eclipse.mtj.internal.core.build.export.states.AbstractCreateAntTaskState;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.statemachine.StateMachine;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateAntBuildFilesFilterState
extends AbstractCreateAntTaskState {
    public CreateAntBuildFilesFilterState(StateMachine machine, IMidletSuiteProject project, Document _document, String buildFolder, String buildFile) {
        super(machine, project, _document, buildFolder, buildFile);
    }

    protected void onEnter(MTJRuntime runtime) throws AntennaExportException {
        Document document = this.getDocument();
        Element root = document.getDocumentElement();
        String configName = this.getFormatedName(runtime.getName());
        IProject project = this.getMidletSuiteProject().getProject();
        Element filter = XMLUtils.createTargetElement(document, root, NLS.bind((String)"buildFilesFilter-{0}", (Object)configName), this.getDependencies(runtime));
        this.buildFilesFilter(project, document, filter, runtime);
    }

    private void buildFilesFilter(IProject _project, Document _document, Element _root, MTJRuntime _runtime) throws AntennaExportException {
        IResource[] sources;
        IJavaProject javaProject = JavaCore.create((IProject)_project);
        if (javaProject == null) {
            return;
        }
        IMidletSuiteProject suiteProject = MidletSuiteFactory.getMidletSuiteProject(javaProject);
        if (suiteProject == null) {
            return;
        }
        String configName = this.getFormatedName(_runtime.getName());
        Element buildFilesFilter = _document.createElement("buildFilesFilter");
        _root.appendChild(buildFilesFilter);
        buildFilesFilter.setAttribute("dirclasses", NLS.bind((String)"{0}/{1}/{2}/classes/", (Object[])new String[]{this.getBuildFolder(), configName, this.getFormatedName(_project.getName())}));
        buildFilesFilter.setAttribute("dirresources", NLS.bind((String)"{0}/{1}/{2}/resources/", (Object[])new String[]{this.getBuildFolder(), configName, this.getFormatedName(_project.getName())}));
        buildFilesFilter.setAttribute("buildProperties", "${basedir}/build.properties");
        buildFilesFilter.setAttribute("device", configName);
        IResource[] iResourceArray = sources = Utils.getSourceFolders(suiteProject.getJavaProject());
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource source = iResourceArray[n2];
            Element fileset = _document.createElement("fileset");
            fileset.setAttribute("dir", NLS.bind((String)"..{0}", (Object)source.getFullPath()));
            buildFilesFilter.appendChild(fileset);
            ++n2;
        }
    }
}

