/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.internal.core.build.BuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.BuildLoggingConfiguration;
import org.eclipse.mtj.internal.core.build.IBuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.preverifier.IClassErrorInformation;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationError;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorLocation;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorLocationType;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorType;
import org.eclipse.mtj.internal.core.util.TemporaryFileManager;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProguardPreverifier
implements IPreverifier {
    private static final String[] CANDIDATE_JAVA_LOCATIONS = new String[]{"bin" + File.separatorChar + "java", "bin" + File.separatorChar + "java.exe", "jre" + File.separatorChar + "bin" + File.separatorChar + "java", "jre" + File.separatorChar + "bin" + File.separatorChar + "java.exe"};
    private static final int MAX_COMMAND_LENGTH = 2000;
    private static final String PREV_ERR_REGEX = "^Unable to access jarfile (\\S*)$";
    private static ProguardPreverifier proguardPreverifier;
    private static final Pattern PREV_ERR_PATTERN;
    private String proguardJarFilePath = MTJCore.getProguardJarFile().getAbsolutePath();

    static {
        PREV_ERR_PATTERN = Pattern.compile(PREV_ERR_REGEX, 8);
    }

    public static ProguardPreverifier getInstance() {
        if (proguardPreverifier == null) {
            proguardPreverifier = new ProguardPreverifier();
        }
        return proguardPreverifier;
    }

    private ProguardPreverifier() {
    }

    @Override
    public File getPreverifierExecutable() {
        return null;
    }

    @Override
    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
    }

    public PreverificationError[] preverify(IMTJProject mtjProject, IResource[] toVerify, IFolder outputFolder, IProgressMonitor monitor) throws CoreException {
        ArrayList<PreverificationError> allErrors = new ArrayList<PreverificationError>();
        this.ensureFolderExists(outputFolder, monitor);
        ArrayList<String> baseArguments = this.constructCommandLine();
        File outputFile = outputFolder.getLocation().toFile();
        String[] configurationParameters = this.getProguardFinalConfigurationParameters(mtjProject, outputFile.getAbsolutePath());
        ArrayList<String> arguments = new ArrayList<String>(baseArguments);
        this.addOutputToInJar(arguments, mtjProject);
        int i = 0;
        while (i < toVerify.length) {
            IResource resource = toVerify[i];
            switch (resource.getType()) {
                case 2: 
                case 4: {
                    this.addFileToInJar(arguments, resource.getLocation().toOSString());
                    break;
                }
                case 1: {
                    if (!resource.getName().endsWith(".jar")) break;
                    this.addFileToInJar(arguments, resource.getLocation().toOSString());
                }
            }
            if (this.commandLength(arguments) > 2000) {
                String[] stringArray = configurationParameters;
                int n = configurationParameters.length;
                int n2 = 0;
                while (n2 < n) {
                    String configuration = stringArray[n2];
                    arguments.add(configuration);
                    ++n2;
                }
                String[] commandLine = arguments.toArray(new String[arguments.size()]);
                PreverificationError[] errors = this.runPreverifier(commandLine, null, monitor);
                allErrors.addAll(Arrays.asList(errors));
                arguments = new ArrayList<String>(baseArguments);
                this.addOutputToInJar(arguments, mtjProject);
            }
            ++i;
        }
        if (arguments.size() != baseArguments.size()) {
            String[] stringArray = configurationParameters;
            int n = configurationParameters.length;
            int resource = 0;
            while (resource < n) {
                String configuration = stringArray[resource];
                arguments.add(configuration);
                ++resource;
            }
            String[] commandLine = arguments.toArray(new String[arguments.size()]);
            PreverificationError[] errors = this.runPreverifier(commandLine, null, monitor);
            allErrors.addAll(Arrays.asList(errors));
        }
        return allErrors.toArray(new PreverificationError[allErrors.size()]);
    }

    public PreverificationError[] preverifyJarFile(IMTJProject mtjProject, File jarFile, IFolder outputFolder, IProgressMonitor monitor) throws CoreException {
        File srcDirectory = new File("");
        try {
            srcDirectory = TemporaryFileManager.instance.createTempDirectory(String.valueOf(jarFile.getName().replace('.', '_')) + "_", ".tmp");
        }
        catch (IOException ioe) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to create directory.", (Throwable)ioe);
            throw new CoreException((IStatus)status);
        }
        srcDirectory.mkdirs();
        try {
            Utils.extractArchive(jarFile, srcDirectory);
        }
        catch (SecurityException se) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to inflate jar file due to a security violation.", (Throwable)se);
            throw new CoreException((IStatus)status);
        }
        catch (IOException ioe) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to inflate jar file.", (Throwable)ioe);
            throw new CoreException((IStatus)status);
        }
        File tgtDirectory = new File("");
        try {
            tgtDirectory = TemporaryFileManager.instance.createTempDirectory(String.valueOf(jarFile.getName().replace('.', '_')) + "_", ".tmp");
        }
        catch (IOException ioe) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to create directory.", (Throwable)ioe);
            throw new CoreException((IStatus)status);
        }
        tgtDirectory.mkdirs();
        ArrayList<String> arguments = this.constructCommandLine();
        arguments.add(srcDirectory.toString());
        String[] commandLine = arguments.toArray(new String[arguments.size()]);
        PreverificationError[] errors = this.runPreverifier(commandLine, null, monitor);
        FileFilter classFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() || !pathname.getName().endsWith(".class");
            }
        };
        try {
            Utils.copy(srcDirectory, tgtDirectory, classFilter);
        }
        catch (SecurityException se) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed copy specified source due to a security violation.", (Throwable)se);
            throw new CoreException((IStatus)status);
        }
        catch (IOException ioe) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to copy specified source.", (Throwable)ioe);
            throw new CoreException((IStatus)status);
        }
        File outputJarFile = new File(outputFolder.getLocation().toFile(), jarFile.getName());
        try {
            Utils.createArchive(outputJarFile, tgtDirectory);
        }
        catch (IOException ioe) {
            Status status = new Status(4, "org.eclipse.mtj.core", "Failed to create zip source folder.", (Throwable)ioe);
            throw new CoreException((IStatus)status);
        }
        return errors;
    }

    @Override
    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
    }

    private void addFileToInJar(List<String> args, String filePath) throws JavaModelException {
        if (filePath != null) {
            args.add("-injars");
            args.add("'" + filePath + "'");
        }
    }

    private void addOutputToInJar(List<String> args, IMTJProject mtjProject) throws JavaModelException {
        String outputPath = null;
        String s1 = mtjProject.getProject().getLocation().toOSString();
        String s2 = mtjProject.getJavaProject().getOutputLocation().removeFirstSegments(1).toOSString();
        outputPath = String.valueOf(s1) + File.separatorChar + s2;
        if (outputPath != null) {
            args.add("-injars");
            args.add("'" + outputPath + "'");
        }
    }

    private int commandLength(ArrayList<String> arguments) {
        int length = 0;
        Iterator<String> iter = arguments.iterator();
        while (iter.hasNext()) {
            String arg = iter.next();
            length += arg.toString().length();
            if (!iter.hasNext()) continue;
            ++length;
        }
        return length;
    }

    private ArrayList<String> constructCommandLine() throws CoreException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.getJavaExecutable().getAbsolutePath());
        arguments.add("-jar");
        arguments.add(this.proguardJarFilePath);
        return arguments;
    }

    private void ensureFolderExists(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
    }

    private String getFullClasspath(IMTJProject mtjProject) throws CoreException {
        IJavaProject javaProject = mtjProject.getJavaProject();
        String[] entries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        StringBuffer sb = new StringBuffer();
        int i = 1;
        while (i < entries.length) {
            if (i != 1) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append("'" + entries[i] + "'");
            ++i;
        }
        return sb.toString();
    }

    private File getJavaExecutable() {
        File executable = null;
        IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
        File installLocation = vmInstall.getInstallLocation();
        int i = 0;
        while (i < CANDIDATE_JAVA_LOCATIONS.length) {
            String javaLocation = CANDIDATE_JAVA_LOCATIONS[i];
            File javaExecutable = new File(installLocation, javaLocation);
            if (javaExecutable.exists()) {
                executable = javaExecutable;
                break;
            }
            ++i;
        }
        return executable;
    }

    private String[] getProguardFinalConfigurationParameters(IMTJProject mtjProject, String output) throws CoreException {
        return new String[]{"-outjars", "'" + output + "'", "-libraryjars", this.getFullClasspath(mtjProject), "'-ignorewarnings'", "-dontusemixedcaseclassnames", "-dontshrink", "-dontoptimize", "-dontobfuscate", "-microedition"};
    }

    private void handleErrorReceived(String text, List<PreverificationError> errorList) {
        Matcher matcher = PREV_ERR_PATTERN.matcher(text = text.trim());
        if (matcher.find()) {
            if (matcher.groupCount() > 0) {
                final String classname = matcher.group(1);
                String errorText = "Error preverifying class";
                if (matcher.end() < text.length()) {
                    StringBuffer sb = new StringBuffer(errorText);
                    sb.append(": ");
                    String detail = text.substring(matcher.end());
                    detail = detail.trim();
                    sb.append(detail);
                    errorText = sb.toString();
                }
                IClassErrorInformation classInfo = new IClassErrorInformation(){

                    public String getName() {
                        return classname;
                    }

                    public String getSourceFile() {
                        return null;
                    }
                };
                PreverificationErrorLocation location = new PreverificationErrorLocation(PreverificationErrorLocationType.UNKNOWN_LOCATION, classInfo);
                PreverificationError error = new PreverificationError(PreverificationErrorType.UNKNOWN_ERROR, location, text);
                errorList.add(error);
            }
        } else {
            MTJLogger.log(2, text);
        }
    }

    private PreverificationError[] runPreverifier(String[] commandLine, String[] environment, IProgressMonitor monitor) throws CoreException {
        final ArrayList errorList = new ArrayList();
        IProcess process = Utils.launchApplication(commandLine, null, environment, "Preverifier", "CLDC Preverifier");
        IStreamsProxy proxy = process.getStreamsProxy();
        if (BuildLoggingConfiguration.getInstance().isPreverifierOutputEnabled()) {
            BuildConsoleProxy.getInstance().traceln("======================== Launching Preverification =========================");
            BuildConsoleProxy.getInstance().addConsoleStreamListener(IBuildConsoleProxy.Stream.ERROR, proxy.getErrorStreamMonitor());
            BuildConsoleProxy.getInstance().addConsoleStreamListener(IBuildConsoleProxy.Stream.OUTPUT, proxy.getOutputStreamMonitor());
        }
        proxy.getErrorStreamMonitor().addListener(new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                ProguardPreverifier.this.handleErrorReceived(text, errorList);
            }
        });
        while (!monitor.isCanceled() && !process.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (BuildLoggingConfiguration.getInstance().isPreverifierOutputEnabled()) {
            BuildConsoleProxy.getInstance().traceln("======================== Preverification exited with code: " + process.getExitValue());
        }
        return errorList.toArray(new PreverificationError[errorList.size()]);
    }
}

