/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.build.preverifier.PreverifierNotFoundException;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.build.BuildConsoleProxy;
import org.eclipse.mtj.internal.core.build.BuildLoggingConfiguration;
import org.eclipse.mtj.internal.core.build.BuildSpecManipulator;
import org.eclipse.mtj.internal.core.build.BuildStateMachine;
import org.eclipse.mtj.internal.core.build.MTJIncrementalProjectBuilder;
import org.eclipse.mtj.internal.core.build.preverifier.builder.BuildInfo;
import org.eclipse.mtj.internal.core.build.preverifier.builder.BuilderMessages;
import org.eclipse.mtj.internal.core.build.preverifier.builder.ResourceDeltaBuilder;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.sdk.device.midp.PackagingModel;
import org.eclipse.mtj.internal.core.util.RequiredProjectsCPEntryVisitor;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.osgi.util.NLS;

public class PreverificationBuilder
extends MTJIncrementalProjectBuilder {
    private static BuildLoggingConfiguration buildLoggingConfig = BuildLoggingConfiguration.getInstance();
    private static BuildConsoleProxy consoleProxy = BuildConsoleProxy.getInstance();
    private static Map<IProject, Map<IProject, IClasspathEntry[]>> lastProjectsClassPath = new HashMap<IProject, Map<IProject, IClasspathEntry[]>>();

    public static void cleanProject(IProject project, boolean cleanDeployed, IProgressMonitor monitor) throws JavaModelException, CoreException {
        IFolder preverified;
        IFolder oldRuntimeFolder;
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_0, (Object)project));
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        BuildInfo buildInfo = new BuildInfo(15, new HashMap(), javaProject);
        IFolder oldVerifiedFolder = project.getFolder(MTJCore.getVerifiedOutputDirectoryName());
        if (oldVerifiedFolder.exists()) {
            Utils.clearContainer((IContainer)oldVerifiedFolder, monitor);
            oldVerifiedFolder.delete(true, monitor);
        }
        if ((oldRuntimeFolder = project.getFolder(".mtj.tmp").getFolder("runtime")).exists()) {
            Utils.clearContainer((IContainer)oldRuntimeFolder, monitor);
            oldRuntimeFolder.delete(true, monitor);
        }
        if ((preverified = buildInfo.getMidletSuite().getVerifiedOutputFolder(monitor)).exists()) {
            IResource[] children;
            IResource[] iResourceArray = children = preverified.members();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getType() == 2) {
                    Utils.clearContainer((IContainer)((IFolder)resource), monitor);
                } else {
                    resource.delete(true, monitor);
                }
                ++n2;
            }
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(NLS.bind((String)BuilderMessages.PreverificationBuilder_1, (Object)project));
        }
    }

    static void clearPreverifierMarkers(IProject ownerProject, IResource resource) throws CoreException {
        IMarker[] foundMarkers;
        IMarker[] iMarkerArray = foundMarkers = resource.findMarkers("org.eclipse.mtj.core.problem.preverify", false, 2);
        int n = foundMarkers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (ownerProject.getName().equals(marker.getAttribute("mtj.marker.belong.to"))) {
                marker.delete();
            }
            ++n2;
        }
    }

    private void clearNoPreverifierFoundMarker() throws CoreException {
        this.getProject().deleteMarkers("org.eclipse.mtj.core.problem.preverify.missingPreverifier", false, 0);
    }

    private void createNoPreverifierFoundMarker() throws CoreException {
        final IProject project = this.getProject();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = project.createMarker("org.eclipse.mtj.core.problem.preverify.missingPreverifier");
                marker.setAttribute("mtj.marker.belong.to", (Object)project.getName());
                marker.setAttribute("message", (Object)BuilderMessages.PreverificationBuilder_PreverifierNotFoundErrorMessage);
                marker.setAttribute("severity", 2);
            }
        };
        project.getWorkspace().run(runnable, null);
    }

    private IJavaProject[] getRequiredProjects(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        RequiredProjectsCPEntryVisitor visitor = new RequiredProjectsCPEntryVisitor();
        visitor.getRunner().run(javaProject, visitor, monitor);
        ArrayList<IJavaProject> projects = visitor.getRequiredProjects();
        return projects.toArray(new IJavaProject[projects.size()]);
    }

    private void preverifyLibraries(BuildInfo buildInfo, IProgressMonitor monitor) throws CoreException, PreverifierNotFoundException {
        IProject project = buildInfo.getCurrentJavaProject().getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_47) + project);
        }
        if (project != null && project.isAccessible()) {
            monitor.setTaskName(String.valueOf(BuilderMessages.PreverificationBuilder_48) + project.getName());
            buildInfo.setCurrentResourceDelta(this.getDelta(project));
            ResourceDeltaBuilder deltaBuilder = new ResourceDeltaBuilder(buildInfo);
            deltaBuilder.preverifyLibraries(monitor);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_49) + project);
        }
    }

    private void preverifyProject(BuildInfo buildInfo, IProgressMonitor monitor) throws CoreException, PreverifierNotFoundException {
        IProject project = buildInfo.getCurrentJavaProject().getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_50) + project);
        }
        if (project != null && project.isAccessible()) {
            monitor.setTaskName(String.valueOf(BuilderMessages.PreverificationBuilder_51) + project.getName());
            buildInfo.setCurrentResourceDelta(this.getDelta(project));
            ResourceDeltaBuilder deltaBuilder = new ResourceDeltaBuilder(buildInfo);
            deltaBuilder.build(monitor);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_52) + project);
        }
    }

    private void setResourcesAsDerived(IFolder verifiedFolder, IProgressMonitor monitor) throws CoreException {
        verifiedFolder.refreshLocal(2, monitor);
        Utils.setResourcesAsDerived((IContainer)verifiedFolder);
    }

    private boolean compareClasspath(IClasspathEntry[] cp1, IClasspathEntry[] cp2) {
        if (cp1 == null) {
            return cp2 == null;
        }
        if (cp2 == null) {
            return false;
        }
        if (cp1.length != cp2.length) {
            return false;
        }
        int i = 0;
        while (i < cp1.length) {
            if (!cp1[i].equals(cp2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean arePreverifiedClassesConsistent(IProject project) {
        IResourceDelta tempFolderDelta;
        IFolder tempFolder = project.getFolder(".mtj.tmp");
        IResourceDelta delta = this.getDelta(project);
        if (delta != null && (tempFolderDelta = delta.findMember(tempFolder.getProjectRelativePath())) != null) {
            int kind = tempFolderDelta.getKind();
            if ((kind & 2) != 0) {
                return false;
            }
            if ((kind & 4) != 0 && delta.findMember(tempFolder.getFolder("verified").getProjectRelativePath()) != null) {
                return false;
            }
        }
        return true;
    }

    protected IProject[] doBuild(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_61) + project);
        }
        IJavaProject rootJavaProject = JavaCore.create((IProject)project);
        ArrayList<IJavaProject> noLibletProjects = new ArrayList<IJavaProject>();
        IJavaProject[] iJavaProjectArray = this.getRequiredProjects(rootJavaProject, monitor);
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject requiredProject = iJavaProjectArray[n2];
            IMidletSuiteProject midletSuite = MidletSuiteFactory.getMidletSuiteProject(requiredProject);
            if (midletSuite.getProjectPackagingModel() != PackagingModel.LIBLET) {
                noLibletProjects.add(requiredProject);
            }
            ++n2;
        }
        IJavaProject[] requiredProjects = noLibletProjects.toArray(new IJavaProject[0]);
        monitor.subTask(BuilderMessages.PreverificationBuilder_62);
        boolean forceFullBuild = false;
        Map<IProject, IClasspathEntry[]> classpaths = lastProjectsClassPath.get(project);
        if (classpaths == null) {
            classpaths = new HashMap<IProject, IClasspathEntry[]>();
            lastProjectsClassPath.put(project, classpaths);
        }
        HashSet<IProject> removedRequiredProjects = new HashSet<IProject>(classpaths.keySet());
        removedRequiredProjects.remove(project);
        if (classpaths.size() != requiredProjects.length + 1) {
            forceFullBuild = true;
        }
        IClasspathEntry[] oldRootCP = classpaths.get(project);
        IClasspathEntry[] newRootCP = rootJavaProject.getResolvedClasspath(true);
        if (!(forceFullBuild || this.compareClasspath(oldRootCP, newRootCP) && this.arePreverifiedClassesConsistent(project))) {
            forceFullBuild = true;
        }
        classpaths.put(project, newRootCP);
        IJavaProject[] iJavaProjectArray2 = requiredProjects;
        int n3 = requiredProjects.length;
        int n4 = 0;
        while (n4 < n3) {
            IJavaProject requiredProject = iJavaProjectArray2[n4];
            removedRequiredProjects.remove(requiredProject.getProject());
            IClasspathEntry[] oldCP = classpaths.get(requiredProject.getProject());
            IClasspathEntry[] newCP = requiredProject.getResolvedClasspath(true);
            if (!(forceFullBuild || this.compareClasspath(oldCP, newCP) && this.arePreverifiedClassesConsistent(requiredProject.getProject()))) {
                forceFullBuild = true;
            }
            classpaths.put(requiredProject.getProject(), newCP);
            ++n4;
        }
        if (forceFullBuild) {
            this.doClean(6, monitor);
            for (IProject removedRequiredProject : removedRequiredProjects) {
                if (!removedRequiredProject.exists()) continue;
                PreverificationBuilder.clearPreverifierMarkers(project, (IResource)removedRequiredProject);
            }
        }
        this.clearNoPreverifierFoundMarker();
        BuildInfo buildInfo = new BuildInfo(forceFullBuild ? 6 : kind, args, rootJavaProject);
        try {
            this.preverifyProject(buildInfo, monitor);
            IJavaProject[] iJavaProjectArray3 = requiredProjects;
            int n5 = requiredProjects.length;
            n3 = 0;
            while (n3 < n5) {
                IJavaProject requiredProject = iJavaProjectArray3[n3];
                buildInfo.setCurrentJavaProject(requiredProject);
                this.preverifyProject(buildInfo, monitor);
                ++n3;
            }
            if (buildInfo.areLibrariesPreverified()) {
                buildInfo.setCurrentJavaProject(rootJavaProject);
                this.preverifyLibraries(buildInfo, monitor);
                iJavaProjectArray3 = requiredProjects;
                n5 = requiredProjects.length;
                n3 = 0;
                while (n3 < n5) {
                    IJavaProject requiredProject = iJavaProjectArray3[n3];
                    buildInfo.setCurrentJavaProject(requiredProject);
                    this.preverifyLibraries(buildInfo, monitor);
                    ++n3;
                }
            }
            IProject[] interestingProjects = new IProject[requiredProjects.length];
            int i = 0;
            while (i < requiredProjects.length) {
                interestingProjects[i] = requiredProjects[i].getProject();
                ++i;
            }
            if (buildInfo.isPackageDirty()) {
                this.setResourcesAsDerived(buildInfo.getVerifiedClassesFolder(monitor), monitor);
                this.setResourcesAsDerived(buildInfo.getVerifiedLibsFolder(monitor), monitor);
            }
            if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_63) + project);
            }
            monitor.done();
            return interestingProjects;
        }
        catch (PreverifierNotFoundException preverifierNotFoundException) {
            this.createNoPreverifierFoundMarker();
            return null;
        }
    }

    protected void doClean(int kind, IProgressMonitor monitor) throws CoreException {
        IJavaProject[] requiredProjects;
        IProject project = this.getProject();
        this.clearNoPreverifierFoundMarker();
        PreverificationBuilder.clearPreverifierMarkers(project, (IResource)project);
        IJavaProject[] iJavaProjectArray = requiredProjects = this.getRequiredProjects(JavaCore.create((IProject)project), monitor);
        int n = requiredProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject requiredProject = iJavaProjectArray[n2];
            if (requiredProject != null) {
                PreverificationBuilder.clearPreverifierMarkers(project, (IResource)requiredProject.getProject());
            }
            ++n2;
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_64) + project);
        }
        PreverificationBuilder.cleanProject(project, false, monitor);
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            consoleProxy.traceln(String.valueOf(BuilderMessages.PreverificationBuilder_65) + project);
        }
    }

    protected String getBuilderId() {
        return "org.eclipse.mtj.core.preverifier";
    }

    protected void onStateExit(BuildStateMachine stateMachine, IProgressMonitor monitor) throws CoreException {
        super.onStateExit(stateMachine, monitor);
        BuildSpecManipulator manipulator = new BuildSpecManipulator(this.getMTJProject().getProject());
        if (!manipulator.hasBuilder("org.eclipse.mtj.core.packageBuilder")) {
            manipulator.addBuilderAfter("org.eclipse.mtj.core.preverifier", "org.eclipse.mtj.core.packageBuilder", null);
            manipulator.commitChanges(monitor);
        }
    }

    protected MTJBuildState getEnterState() {
        return MTJBuildState.PRE_PREVERIFICATION;
    }

    protected MTJBuildState getExitState() {
        return MTJBuildState.POST_PREVERIFICATION;
    }
}

