/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaProjectSourceContainer;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaSourcePathComputer;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.build.preprocessor.PreprocessorBuilder;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class EmulationJavaSourcePathComputer
extends JavaSourcePathComputer {
    public static final String ID = "org.eclipse.mtj.core.launching.emulationSourcePathComputer";

    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        ISourceContainer[] containers = super.computeSourceContainers(configuration, monitor);
        if (this.isPreprocessingProject(configuration)) {
            int i = 0;
            while (i < containers.length) {
                IJavaProject tgtJavaProject;
                IJavaProject javaProject;
                IProject srcProject;
                IProject tgtProject;
                if (containers[i] instanceof JavaProjectSourceContainer && (tgtProject = PreprocessorBuilder.getOutputProject(srcProject = (javaProject = ((JavaProjectSourceContainer)containers[i]).getJavaProject()).getProject())).exists() && (tgtJavaProject = JavaCore.create((IProject)tgtProject)).exists()) {
                    containers[i] = new JavaProjectSourceContainer(tgtJavaProject);
                }
                ++i;
            }
        }
        return containers;
    }

    public String getId() {
        return ID;
    }

    private boolean isPreprocessingProject(ILaunchConfiguration configuration) {
        boolean preprocessing = false;
        try {
            String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            IProject project = MTJCore.getWorkspace().getRoot().getProject(projectName);
            if (project.exists()) {
                preprocessing = project.hasNature("org.eclipse.mtj.core.preprocessingNature");
            }
        }
        catch (CoreException e) {
            MTJLogger.log(2, e);
        }
        return preprocessing;
    }
}

