/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.launching.midp;

import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.launching.midp.EmulatorRunner;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.sdk.device.AbstractMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDevice;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;

public class EmulatorLaunchConfigDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private static final String EXE_EXT = ".exe";
    private static final String DEVICE_COMMAND = "-Xdevice:";
    private static final String LIST_INSTALLED_MIDLET_COMMAND = "-Xjam:list";
    private static final IStatus NO_MIDLET_STATUS = new Status(4, "org.eclipse.mtj.core", 100, "", null);
    private static final String REMOVE_INSTALLED_MIDLET_COMMAND = "-Xjam:remove=";

    public void launch(ILaunchConfiguration launchConfig, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IDevice device;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((device = this.getDevice(launchConfig)) == null) {
            MTJStatusHandler.throwCoreException(4, -999, "Device is unspecified or unavailable");
        }
        monitor.beginTask(NLS.bind((String)Messages.launchdelegate_launching, (Object[])new Object[]{launchConfig.getName()}), 3);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(Messages.launchdelegate_verifying_attrs);
        IVMRunner runner = this.getVMRunner(launchConfig, device, mode);
        VMRunnerConfiguration runConfig = this.getVMRunnerConfiguration(launchConfig, device, mode);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        monitor.subTask(Messages.launchdelegate_source_locator);
        this.setDefaultSourceLocator(launch, launchConfig);
        monitor.worked(1);
        ((EmulatorRunner)runner).run(runConfig, launchConfig, launch, monitor);
        if (!monitor.isCanceled()) {
            monitor.done();
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        boolean continueLaunch = super.preLaunchCheck(configuration, mode, monitor);
        if (continueLaunch) {
            continueLaunch = this.verifyEmulationSettings(configuration, mode, monitor);
        }
        return continueLaunch;
    }

    private void checkAndRemoveInstalledMidlet(IApplicationDescriptor desc, IDevice device) throws CoreException {
        if (!(device instanceof JavaEmulatorDevice)) {
            String midlet_name = desc.getManifestProperties().getProperty("MIDlet-Name");
            String midlet_vendor_name = desc.getManifestProperties().getProperty("MIDlet-Vendor");
            AbstractMIDPDevice aDevice = (AbstractMIDPDevice)device;
            File executable = aDevice.getExecutable();
            String[] arguments = new String[]{DEVICE_COMMAND + aDevice.getName(), LIST_INSTALLED_MIDLET_COMMAND};
            String[] commandLine = this.populateCommandLine(executable, arguments);
            File workingDirectory = executable.getParentFile();
            String output = Utils.getStandardOutput("get installed MIDlet Suite", commandLine, workingDirectory);
            String regex = "\\[\\d+\\]";
            String[] suites = output.split(regex);
            int suitNum = 0;
            boolean installed = false;
            int i = 1;
            while (i < suites.length) {
                String suiteInfo = suites[i];
                if (suiteInfo.trim().length() > 0) {
                    ++suitNum;
                    ColonDelimitedProperties props = this.parseMidetSuiteInfo(suiteInfo);
                    String suiteName = props.getProperty("Name");
                    String vendorName = props.getProperty("Vendor");
                    if (midlet_name.equals(suiteName) && midlet_vendor_name.equals(vendorName)) {
                        installed = true;
                        break;
                    }
                }
                ++i;
            }
            if (installed) {
                arguments = new String[]{DEVICE_COMMAND + aDevice.getName(), REMOVE_INSTALLED_MIDLET_COMMAND + suitNum};
                commandLine = this.populateCommandLine(executable, arguments);
                Utils.getStandardOutput("remove MIDlet Suite", commandLine, workingDirectory);
            }
        }
    }

    private IDevice getDevice(ILaunchConfiguration launchConfig) throws CoreException {
        IDevice device = null;
        if (launchConfig.getAttribute("mtj.use_project_device", true)) {
            device = this.getMidletSuite(launchConfig).getRuntimeList().getActiveMTJRuntime().getDevice();
        } else {
            String toolkitName = launchConfig.getAttribute("mtj.emulated_device_group", "");
            String deviceName = launchConfig.getAttribute("mtj.emulated_device", "");
            try {
                device = MTJCore.getDeviceRegistry().getDevice(toolkitName, deviceName);
            }
            catch (PersistenceException e) {
                MTJStatusHandler.throwCoreException(4, -999, e);
            }
        }
        return device;
    }

    private IMidletSuiteProject getMidletSuite(ILaunchConfiguration launchConfig) throws CoreException {
        IMidletSuiteProject result = null;
        IJavaProject javaProject = this.getJavaProject(launchConfig);
        if (javaProject != null && javaProject.getProject().hasNature("org.eclipse.mtj.core.nature")) {
            result = MidletSuiteFactory.getMidletSuiteProject(javaProject);
        }
        return result;
    }

    private ColonDelimitedProperties parseMidetSuiteInfo(String suiteInfo) {
        ColonDelimitedProperties props = new ColonDelimitedProperties();
        StringReader reader = new StringReader(suiteInfo);
        try {
            props.load(reader);
        }
        catch (Exception e) {
            MTJLogger.log(2, "Error parsing installed apps", e);
            MTJLogger.log(2, suiteInfo);
        }
        return props;
    }

    private String[] populateCommandLine(File executable, String[] arguments) {
        boolean isWin32 = Platform.getOS().equals("win32");
        String command = executable.getAbsolutePath();
        boolean useCmdShell = isWin32 && !command.toLowerCase().endsWith(EXE_EXT);
        ArrayList<String> list = new ArrayList<String>();
        if (useCmdShell) {
            list.add("cmd");
            list.add("/c");
            command = "\"" + executable.getName() + "\"";
        }
        list.add(command);
        list.addAll(Arrays.asList(arguments));
        return list.toArray(new String[list.size()]);
    }

    private boolean promptWhetherToContinue(IStatus status) throws CoreException {
        Boolean shouldContinue = (Boolean)MTJStatusHandler.statusPrompt(status, (Object)this);
        return shouldContinue != null ? shouldContinue : false;
    }

    private boolean verifyEmulationSettings(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IMidletSuiteProject suite;
        IApplicationDescriptor desc;
        IJavaProject javaProject;
        Status status;
        boolean valid = true;
        if ("debug".equals(mode) && !(valid = this.promptWhetherToContinue((IStatus)(status = new Status(1, "org.eclipse.mtj.core", 104, "", null))))) {
            return valid;
        }
        boolean doOTA = configuration.getAttribute("mtj.do_ota", false);
        if (doOTA && (javaProject = this.getJavaProject(configuration)) != null && (desc = (suite = MidletSuiteFactory.getMidletSuiteProject(javaProject)).getApplicationDescriptor()) != null) {
            boolean bl = valid = desc.getMidletCount() > 0;
            if (!valid && !(valid = this.promptWhetherToContinue(NO_MIDLET_STATUS))) {
                return valid;
            }
            this.checkAndRemoveInstalledMidlet(desc, this.getDevice(configuration));
        }
        return valid;
    }

    protected IVMRunner getVMRunner(ILaunchConfiguration launchConfig, IDevice device, String mode) throws CoreException {
        IMidletSuiteProject suite = this.getMidletSuite(launchConfig);
        return new EmulatorRunner(suite, device, mode);
    }

    protected VMRunnerConfiguration getVMRunnerConfiguration(ILaunchConfiguration launchConfig, IDevice device, String mode) throws CoreException {
        File workingDir = this.verifyWorkingDirectory(launchConfig);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(device.getName(), new String[0]);
        runConfig.setVMArguments(new String[0]);
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setVMSpecificAttributesMap(new HashMap());
        return runConfig;
    }
}

