/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.launching.midp;

import com.ibm.icu.text.DateFormat;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.launching.AbstractVMRunner;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.mtj.core.launching.LaunchEnvironment;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.PreferenceAccessor;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.osgi.util.NLS;

public class EmulatorRunner
extends AbstractVMRunner {
    private static final String PORT_VM_ARG = "port";
    private static final String SOCKET_ATTACHING_CONNECTOR_NAME = "com.sun.jdi.SocketAttach";
    private static final String SOCKET_LISTENING_CONNECTOR_NAME = "com.sun.jdi.SocketListen";
    private static final String TIMEOUT_VM_ARG = "timeout";
    private boolean debugMode;
    private IDevice device;
    private IMidletSuiteProject midletSuiteProject;

    public EmulatorRunner(IMidletSuiteProject midletSuiteProject, IDevice device, String mode) {
        this.midletSuiteProject = midletSuiteProject;
        this.device = device;
        this.debugMode = "debug".equals(mode);
    }

    public String renderProcessLabel(String[] commandLine) {
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < commandLine.length) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(commandLine[i]);
            ++i;
        }
        return NLS.bind((String)Messages.debugvmrunner_process_label_string, (Object[])new String[]{sb.toString(), timestamp});
    }

    public void run(VMRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
    }

    public void run(VMRunnerConfiguration vmRunnerConfig, ILaunchConfiguration launchConfig, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (this.debugMode) {
            this.runInDebug(vmRunnerConfig, launchConfig, launch, monitor);
        } else {
            this.runWithoutDebug(vmRunnerConfig, launchConfig, launch, monitor);
        }
    }

    public void runInDebug(VMRunnerConfiguration vmRunnerConfig, ILaunchConfiguration launchConfig, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(Messages.debugvmrunner_launching_vm, 4);
        subMonitor.subTask(Messages.debugvmrunner_finding_free_socket);
        int port = SocketUtil.findFreePort();
        if (port == -1) {
            this.abort(Messages.debugvmrunner_no_free_socket, null, 118);
        }
        subMonitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask(Messages.debugvmrunner_constructing_cmd_line);
        String[] cmdLine = this.getCommandLine(launchConfig, port, monitor);
        Utils.dumpCommandLine(cmdLine);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(Messages.debugvmrunner_starting_VM);
        Connector vmConnector = this.getVMConnector();
        if (vmConnector == null) {
            this.abort(Messages.debugvmrunner_no_connector, null, 119);
        }
        Map<String, Connector.Argument> vmArgsMap = vmConnector.defaultArguments();
        this.specifyArguments(vmArgsMap, port);
        Process emulatorProcess = null;
        try {
            try {
                File workingDir;
                if (monitor.isCanceled()) {
                    return;
                }
                if (!this.device.isDebugServer()) {
                    ((ListeningConnector)vmConnector).startListening(vmArgsMap);
                }
                if ((emulatorProcess = this.exec(cmdLine, workingDir = this.getWorkingDir(vmRunnerConfig))) == null) {
                    return;
                }
                if (monitor.isCanceled()) {
                    emulatorProcess.destroy();
                    return;
                }
                Map defaultMap = this.getDefaultProcessMap();
                defaultMap.put(IProcess.ATTR_PROCESS_TYPE, "MTJProcess");
                IProcess newEmulatorProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)emulatorProcess, (String)this.renderProcessLabel(cmdLine), (Map)defaultMap);
                newEmulatorProcess.setAttribute(IProcess.ATTR_CMDLINE, this.renderCommandLine(cmdLine));
                subMonitor.worked(1);
                subMonitor.subTask(Messages.debugvmrunner_establishing_debug_conn);
                VirtualMachine vm = this.createVirtualMachine(vmConnector, vmArgsMap, emulatorProcess, newEmulatorProcess, monitor);
                JDIDebugModel.newDebugTarget((ILaunch)launch, (VirtualMachine)vm, (String)this.renderDebugTarget(vmRunnerConfig.getClassToLaunch(), port), (IProcess)newEmulatorProcess, (boolean)true, (boolean)false);
                subMonitor.worked(1);
                subMonitor.done();
                return;
            }
            finally {
                if (!this.device.isDebugServer()) {
                    ((ListeningConnector)vmConnector).stopListening(vmArgsMap);
                }
            }
        }
        catch (IOException e) {
            this.abort(Messages.debugvmrunner_couldnt_connect_to_vm, e, 120);
        }
        catch (IllegalConnectorArgumentsException e) {
            this.abort(Messages.debugvmrunner_couldnt_connect_to_vm, e, 120);
        }
        if (emulatorProcess != null) {
            emulatorProcess.destroy();
        }
    }

    public void runWithoutDebug(VMRunnerConfiguration vmRunnerConfig, ILaunchConfiguration launchConfig, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(Messages.debugvmrunner_launching_vm, 3);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask(Messages.debugvmrunner_constructing_cmd_line);
        String[] cmdLine = this.getCommandLine(launchConfig, -1, monitor);
        Utils.dumpCommandLine(cmdLine);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(Messages.debugvmrunner_starting_VM);
        if (monitor.isCanceled()) {
            return;
        }
        File workingDir = this.getWorkingDir(vmRunnerConfig);
        Process p = this.exec(cmdLine, workingDir);
        if (p == null) {
            return;
        }
        if (monitor.isCanceled()) {
            p.destroy();
            return;
        }
        Map defaultMap = this.getDefaultProcessMap();
        defaultMap.put(IProcess.ATTR_PROCESS_TYPE, "MTJProcess");
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)this.renderProcessLabel(cmdLine), (Map)defaultMap);
        process.setAttribute(IProcess.ATTR_CMDLINE, this.renderCommandLine(cmdLine));
        subMonitor.worked(1);
    }

    private VirtualMachine createVirtualMachine(Connector vmConnector, Map vmArgMap, Process emulatorProcess, IProcess emulatorProcessIlaunchBased, IProgressMonitor monitor) throws IOException, IllegalConnectorArgumentsException, CoreException {
        VirtualMachine vm = this.device.isDebugServer() ? this.waitForRemoteDebugger((AttachingConnector)vmConnector, vmArgMap) : this.waitForDebuggerConnection((ListeningConnector)vmConnector, emulatorProcess, emulatorProcessIlaunchBased, vmArgMap, monitor);
        return vm;
    }

    private AttachingConnector getAttachingConnector() {
        AttachingConnector connector = null;
        List<AttachingConnector> connectors = Bootstrap.virtualMachineManager().attachingConnectors();
        int i = 0;
        while (i < connectors.size()) {
            AttachingConnector c = connectors.get(i);
            if (SOCKET_ATTACHING_CONNECTOR_NAME.equals(c.name())) {
                connector = c;
            }
            ++i;
        }
        return connector;
    }

    private ListeningConnector getListeningConnector() {
        ListeningConnector connector = null;
        List<ListeningConnector> connectors = Bootstrap.virtualMachineManager().listeningConnectors();
        int i = 0;
        while (i < connectors.size()) {
            ListeningConnector c = connectors.get(i);
            if (SOCKET_LISTENING_CONNECTOR_NAME.equals(c.name())) {
                connector = c;
            }
            ++i;
        }
        return connector;
    }

    private Connector getVMConnector() {
        Connector connector = this.device.isDebugServer() ? this.getAttachingConnector() : this.getListeningConnector();
        return connector;
    }

    private File getWorkingDir(VMRunnerConfiguration config) throws CoreException {
        File deviceWorkingDirectory;
        File dir = null;
        String path = null;
        if (this.device instanceof IMIDPDevice && (deviceWorkingDirectory = ((IMIDPDevice)this.device).getWorkingDirectory()) != null && deviceWorkingDirectory.exists()) {
            path = deviceWorkingDirectory.getPath();
        }
        if (path == null) {
            path = config.getWorkingDirectory();
        }
        if (path != null && !(dir = new File(path)).isDirectory()) {
            this.abort(NLS.bind((String)Messages.debugvmrunner_workingdir_not_dir, (Object[])new String[]{path}), null, 108);
        }
        return dir;
    }

    private String renderCommandLine(String[] commandLineArgs) {
        StringBuffer buf = new StringBuffer();
        if (commandLineArgs.length > 1) {
            int i = 0;
            while (i < commandLineArgs.length) {
                if (i > 0) {
                    buf.append(' ');
                }
                buf.append(commandLineArgs[i]);
                ++i;
            }
        }
        return buf.toString();
    }

    private String renderDebugTarget(String classToRun, int debugPort) {
        return NLS.bind((String)Messages.debugvmrunner_debug_target_string, (Object[])new String[]{classToRun, String.valueOf(debugPort)});
    }

    private void specifyArguments(Map args, int portNumber) {
        Connector.IntegerArgument port = (Connector.IntegerArgument)args.get(PORT_VM_ARG);
        port.setValue(portNumber);
        Connector.IntegerArgument timeoutArg = (Connector.IntegerArgument)args.get(TIMEOUT_VM_ARG);
        if (timeoutArg != null) {
            int timeout = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
            timeoutArg.setValue(timeout);
        }
    }

    private VirtualMachine waitForDebuggerConnection(ListeningConnector vmConnector, Process emulatorProcessRaw, IProcess emulatorProcessIlaunchBased, Map vmArgMap, IProgressMonitor monitor) throws CoreException, IOException, IllegalConnectorArgumentsException {
        VirtualMachine vm = null;
        boolean retry = false;
        while (true) {
            try {
                ConnectRunnable runnable = new ConnectRunnable(vmConnector, vmArgMap);
                Thread connectThread = new Thread((Runnable)runnable, Messages.EmulatorRunner_4);
                connectThread.start();
                while (connectThread.isAlive()) {
                    if (monitor.isCanceled()) {
                        vmConnector.stopListening(vmArgMap);
                        emulatorProcessRaw.destroy();
                        break;
                    }
                    try {
                        emulatorProcessRaw.exitValue();
                        try {
                            vmConnector.stopListening(vmArgMap);
                        }
                        catch (IOException iOException) {}
                        this.checkErrorMessage(emulatorProcessIlaunchBased);
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {}
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Exception ex = runnable.getException();
                if (ex instanceof IllegalConnectorArgumentsException) {
                    throw (IllegalConnectorArgumentsException)ex;
                }
                if (ex instanceof InterruptedIOException) {
                    throw (InterruptedIOException)ex;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                vm = runnable.getVirtualMachine();
            }
            catch (InterruptedIOException e) {
                this.checkErrorMessage(emulatorProcessIlaunchBased);
                Status status = new Status(4, "org.eclipse.mtj.core", 117, "", (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                retry = false;
                if (handler == null) {
                    throw new CoreException((IStatus)status);
                }
                Object result = handler.handleStatus((IStatus)status, (Object)this);
                if (!(result instanceof Boolean)) continue;
                retry = (Boolean)result;
                if (retry) continue;
            }
            break;
        }
        return vm;
    }

    private VirtualMachine waitForRemoteDebugger(AttachingConnector vmConnector, Map vmArgMap) throws IOException, IllegalConnectorArgumentsException {
        PreferenceAccessor prefs = PreferenceAccessor.instance;
        VirtualMachine vm = null;
        int launchTimeout = prefs.getInt("rmt_debug_delay");
        int launchRetryInterval = prefs.getInt("rmt_debug_poll_interval");
        long launchEndTime = System.currentTimeMillis() + (long)launchTimeout;
        boolean retry = true;
        do {
            try {
                vm = vmConnector.attach(vmArgMap);
                retry = false;
            }
            catch (IOException iOException) {
                if (System.currentTimeMillis() > launchEndTime) {
                    throw new IOException(Messages.EmulatorRunner_6);
                }
                try {
                    Thread.sleep(launchRetryInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        } while (retry);
        return vm;
    }

    protected void checkErrorMessage(IProcess process) throws CoreException {
        String errorMessage = process.getStreamsProxy().getErrorStreamMonitor().getContents();
        if (errorMessage.length() == 0) {
            errorMessage = process.getStreamsProxy().getOutputStreamMonitor().getContents();
        }
        if (errorMessage.length() != 0) {
            this.abort(errorMessage, null, 116);
        }
    }

    protected String[] getCommandLine(ILaunchConfiguration config, int port, IProgressMonitor monitor) throws CoreException {
        LaunchEnvironment launchEnvironment = new LaunchEnvironment();
        launchEnvironment.setDebugLaunch(this.debugMode);
        launchEnvironment.setDebugListenerPort(port);
        launchEnvironment.setLaunchConfiguration(config);
        launchEnvironment.setProject(this.midletSuiteProject);
        String commandLineString = this.device.getLaunchCommand(launchEnvironment, monitor);
        ExecutionArguments execArgs = new ExecutionArguments("", commandLineString);
        String[] cmdLine = execArgs.getProgramArgumentsArray();
        return cmdLine;
    }

    protected String getPluginIdentifier() {
        return "org.eclipse.mtj.core";
    }

    static class ConnectRunnable
    implements Runnable {
        private Map fConnectionMap = null;
        private ListeningConnector fConnector = null;
        private Exception fException = null;
        private VirtualMachine fVirtualMachine = null;

        public ConnectRunnable(ListeningConnector connector, Map vmArgMap) {
            this.fConnector = connector;
            this.fConnectionMap = vmArgMap;
        }

        public Exception getException() {
            return this.fException;
        }

        public VirtualMachine getVirtualMachine() {
            return this.fVirtualMachine;
        }

        public void run() {
            try {
                this.fVirtualMachine = this.fConnector.accept(this.fConnectionMap);
            }
            catch (IOException e) {
                this.fException = e;
            }
            catch (IllegalConnectorArgumentsException e) {
                this.fException = e;
            }
        }
    }
}

