/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.launching.midp.ota;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTAHandler
extends AbstractHandler {
    private static final String OTA_CONTEXT_PATH = "/ota";
    private static final String[] KNOWN_MIME_TYPES = new String[]{"jad", "text/vnd.sun.j2me.app-descriptor", "jar", "application/java-archive"};
    private static Map<String, String> mimeTypeMap;
    private static final long serialVersionUID = 1L;

    private static Map<String, String> getMimeTypeMap() {
        if (mimeTypeMap == null) {
            mimeTypeMap = new HashMap<String, String>();
            int i = 0;
            while (i < KNOWN_MIME_TYPES.length) {
                mimeTypeMap.put(KNOWN_MIME_TYPES[i++], KNOWN_MIME_TYPES[i++]);
            }
        }
        return mimeTypeMap;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String project = null;
        String file = null;
        StringTokenizer st = new StringTokenizer(target, "/");
        if (st.hasMoreTokens()) {
            project = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            file = st.nextToken();
        }
        if (project != null && file != null) {
            try {
                this.handle(project, file, target, request, response);
            }
            catch (CoreException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    private String getContentEncoding(IFile requestedFile) {
        return requestedFile.getFileExtension().equals("jad") ? "UTF-8" : null;
    }

    private String getContentType(IFile requestedFile) {
        String contentType = OTAHandler.getMimeTypeMap().get(requestedFile.getFileExtension());
        return contentType != null ? contentType : "application/octet-stream";
    }

    private IJavaProject getJavaProject(String projectName) {
        IJavaProject javaProject = null;
        IWorkspaceRoot root = MTJCore.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project != null) {
            javaProject = JavaCore.create((IProject)project);
        }
        return javaProject;
    }

    private void handle(IJavaProject javaProject, String file, String pathParams, HttpServletRequest request, HttpServletResponse response) throws CoreException, IOException {
        IFile requestedFile;
        String deployableJadFolderName = ".mtj.tmp" + File.separator + "emulation";
        IFolder deployedFolder = javaProject.getProject().getFolder(deployableJadFolderName);
        if (deployedFolder.exists() && (requestedFile = deployedFolder.getFile(file)).exists()) {
            this.sendFile(requestedFile, response);
        }
    }

    private void handle(String project, String file, String pathParams, HttpServletRequest request, HttpServletResponse response) throws CoreException, IOException {
        IJavaProject javaProject = this.getJavaProject(project);
        if (javaProject != null) {
            this.handle(javaProject, file, pathParams, request, response);
        }
    }

    private void sendFile(IFile requestedFile, HttpServletResponse response) throws CoreException, IOException {
        String contentType = this.getContentType(requestedFile);
        String contentEncoding = this.getContentEncoding(requestedFile);
        File javaFile = requestedFile.getLocation().toFile();
        response.setCharacterEncoding(contentEncoding);
        response.setContentType(contentType);
        response.setContentLength((int)javaFile.length());
        InputStream is = requestedFile.getContents();
        ServletOutputStream os = response.getOutputStream();
        Utils.copyInputToOutput(is, (OutputStream)os);
        os.close();
        is.close();
        response.flushBuffer();
    }

    static ContextHandler getContextHandler() {
        ContextHandler ctxHandler = new ContextHandler(OTA_CONTEXT_PATH);
        ctxHandler.setHandler((Handler)new OTAHandler());
        MimeTypes types = new MimeTypes();
        types.setMimeMap(OTAHandler.getMimeTypeMap());
        ctxHandler.setMimeTypes(types);
        return ctxHandler;
    }
}

