/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.packaging.midp;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.BuildStateMachine;
import org.eclipse.mtj.internal.core.build.sign.SignatureUtils;
import org.eclipse.mtj.internal.core.project.midp.IJadSignature;
import org.eclipse.mtj.internal.core.project.midp.LibletProperties;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.sdk.device.midp.PackagingModel;
import org.eclipse.mtj.internal.core.sdk.device.midp.Profile;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class DeployedJADWriter {
    private IMidletSuiteProject midletSuite;
    private File deploymentFolder;
    private File deployedJarFile;

    public DeployedJADWriter(IMidletSuiteProject midletSuite, IFolder deploymentFolder, File deployedJar) {
        this(midletSuite, deploymentFolder.getLocation().toFile(), deployedJar);
    }

    public DeployedJADWriter(IMidletSuiteProject midletSuite, File deploymentFolder, File deployedJar) {
        this.midletSuite = midletSuite;
        this.deploymentFolder = deploymentFolder;
        this.deployedJarFile = deployedJar;
    }

    public void writeDeployedJAD(boolean incrementalBuild, IProgressMonitor monitor) throws IOException, CoreException {
        LibletProperties[] libletProperties;
        IApplicationDescriptor appDescriptor = this.midletSuite.getApplicationDescriptor();
        ColonDelimitedProperties jadProperties = (ColonDelimitedProperties)appDescriptor.getManifestProperties();
        String jarSizePropertyName = "MIDlet-Jar-Size";
        String jarURLPropertyName = "MIDlet-Jar-URL";
        String jarDependencyName = "MIDlet-Dependency-";
        String jarDependencyJadUrlName = "MIDlet-Dependency-JAD-URL-";
        if (jadProperties.getProperty("LIBlet-Jar-URL") != null && !jadProperties.getProperty("LIBlet-Jar-URL").equals("")) {
            jarSizePropertyName = "LIBlet-Jar-Size";
            jarURLPropertyName = "LIBlet-Jar-URL";
            jarDependencyName = "LIBlet-Dependency-";
            jarDependencyJadUrlName = "LIBlet-Dependency-JAD-URL-";
        }
        jadProperties.setProperty(jarSizePropertyName, Long.valueOf(this.deployedJarFile.length()).toString());
        if (incrementalBuild) {
            jadProperties.setProperty(jarURLPropertyName, this.deployedJarFile.getName());
        }
        if ((libletProperties = this.midletSuite.getLibletProperties()) != null) {
            int index = 1;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            int i = 0;
            while (i < libletProperties.length) {
                IProject project;
                IMidletSuiteProject midletSuiteRequiredProject;
                String requiredProjectName = libletProperties[i].getProjectName();
                if (libletProperties[i].getType() != LibletProperties.Type.LIBLET || requiredProjectName == null || requiredProjectName.trim().equals("") || (midletSuiteRequiredProject = MidletSuiteFactory.getMidletSuiteProject(JavaCore.create((IProject)(project = workspace.getRoot().getProject(requiredProjectName))))).getProjectPackagingModel() == PackagingModel.LIBLET) {
                    jadProperties.setProperty(String.valueOf(jarDependencyName) + index, libletProperties[i].getJadPropertyString());
                    if (libletProperties[i].getJadURL() != null && !libletProperties[i].getJadURL().trim().equals("")) {
                        jadProperties.setProperty(String.valueOf(jarDependencyJadUrlName) + index, libletProperties[i].getJadURL());
                    }
                    ++index;
                }
                ++i;
            }
        }
        this.writeJad(appDescriptor);
        IJadSignature signatureObject = SignatureUtils.getSignatureObject(this.midletSuite);
        if (signatureObject != null) {
            BuildStateMachine stateMachine = BuildStateMachine.getInstance(this.midletSuite);
            stateMachine.changeState(MTJBuildState.PRE_SIGNING, monitor);
            this.signJad(signatureObject, this.deployedJarFile, jadProperties);
            this.writeJad(appDescriptor);
            stateMachine.changeState(MTJBuildState.POST_SIGNING, monitor);
        }
    }

    private void signJad(IJadSignature signatureObject, File deployedJarFile, ColonDelimitedProperties jadProperties) throws CoreException {
        signatureObject.computeSignature(deployedJarFile);
        boolean isLiblet = this.midletSuite.getProjectPackagingModel() == PackagingModel.LIBLET;
        boolean isMEEP = this.midletSuite.getApplicationDescriptor().getMicroEditionProfile().equals(Profile.MEEP_80.toString());
        String jarRsaShaPropertyName = isLiblet ? "LIBlet-Jar-RSA-SHA1-1" : (isMEEP ? "MIDlet-Jar-RSA-SHA1-1" : "MIDlet-Jar-RSA-SHA1");
        String certificatePropertyName = isLiblet ? "LIBlet-Certificate-1-" : "MIDlet-Certificate-1-";
        jadProperties.setProperty(jarRsaShaPropertyName, signatureObject.getJarSignatureString());
        String[] certificates = signatureObject.getCertificateStrings();
        int i = 1;
        while (i <= certificates.length) {
            jadProperties.setProperty(String.valueOf(certificatePropertyName) + i, certificates[i - 1]);
            ++i;
        }
    }

    private void writeJad(IApplicationDescriptor appDescriptor) throws IOException {
        String jadName = this.midletSuite.getJadFileName();
        if (jadName != null) {
            File deployedJadFile = new File(this.deploymentFolder, jadName);
            if (!deployedJadFile.exists()) {
                deployedJadFile.createNewFile();
            }
            appDescriptor.store(deployedJadFile);
        } else {
            MTJLogger.log(4, Messages.DeployedJADWriter_unableToResolveJadName);
        }
    }
}

