/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.midp;

public class LibletProperties {
    private String name;
    private Level level;
    private Type type;
    private String jadURL;
    private String vendor;
    private String version;
    private String jadFileName;
    private String projectName;

    public LibletProperties(String name, Level level, Type type, String jadURL, String vendor, String version, String projectName) {
        this.name = name;
        this.level = level;
        this.type = type;
        this.jadURL = jadURL;
        this.vendor = vendor;
        this.version = version;
        this.setProjectName(projectName);
    }

    public String getJadPropertyString() {
        return String.valueOf(this.type.getJadName()) + ";" + this.level.getJadName() + ";" + this.name + ";" + (this.type != Type.SERVICE ? String.valueOf(this.vendor) + ";" + this.version : ";");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getJadURL() {
        return this.jadURL;
    }

    public void setJadURL(String jadURL) {
        this.jadURL = jadURL;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getJadFileName() {
        return this.jadFileName;
    }

    public void setJadFileName(String jadFileName) {
        this.jadFileName = jadFileName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        OPTIONAL,
        REQUIRED;


        public String getJadName() {
            switch (this) {
                case OPTIONAL: {
                    return "optional";
                }
                case REQUIRED: {
                    return "required";
                }
            }
            return null;
        }

        public static Level getByJadName(String name) {
            if (name.equals("optional")) {
                return OPTIONAL;
            }
            if (name.equals("required")) {
                return REQUIRED;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        LIBLET,
        STANDARD,
        SERVICE,
        PROPRIETARY;


        public String getJadName() {
            switch (this) {
                case LIBLET: {
                    return "liblet";
                }
                case PROPRIETARY: {
                    return "proprietary";
                }
                case SERVICE: {
                    return "service";
                }
                case STANDARD: {
                    return "standard";
                }
            }
            return null;
        }

        public static Type getByJadName(String name) {
            if (name.equals("liblet")) {
                return LIBLET;
            }
            if (name.equals("proprietary")) {
                return PROPRIETARY;
            }
            if (name.equals("service")) {
                return SERVICE;
            }
            if (name.equals("standard")) {
                return STANDARD;
            }
            return null;
        }
    }
}

