/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.midp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistryListener;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.PreferenceAccessor;
import org.eclipse.mtj.internal.core.l10n.L10nApi;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteProject;
import org.eclipse.mtj.internal.core.sdk.device.midp.Configuration;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.swt.widgets.Display;

public class MidletSuiteFactory {
    private static final Map<IJavaProject, IMidletSuiteProject> midletSuiteMap = new HashMap<IJavaProject, IMidletSuiteProject>();
    private static final Semaphore accessSuiteMapSemaphore = new Semaphore(1);

    static {
        MTJCore.getDeviceRegistry().addRegistryListener(new DeviceRegistryListener());
    }

    public static MidletSuiteCreationRunnable getMidletSuiteCreationRunnable(IProject project, IJavaProject javaProject, IMIDPDevice device, String jadFileName) {
        return new MidletSuiteCreationRunnable(project, javaProject, device, jadFileName);
    }

    public static IMidletSuiteProject getMidletSuiteProject(IJavaProject javaProject) {
        return MidletSuiteFactory.getMidletSuiteProject(javaProject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMidletSuiteProject getMidletSuiteProject(IJavaProject javaProject, boolean create) {
        IMidletSuiteProject suite = null;
        Display display = Display.getDefault();
        if (display.getThread() == Thread.currentThread()) {
            while (!accessSuiteMapSemaphore.tryAcquire()) {
                if (display.isDisposed() || display.readAndDispatch()) continue;
                display.sleep();
            }
        } else {
            accessSuiteMapSemaphore.acquireUninterruptibly();
        }
        try {
            Map<IJavaProject, IMidletSuiteProject> map = midletSuiteMap;
            synchronized (map) {
                suite = midletSuiteMap.get(javaProject);
                if (suite == null && create) {
                    suite = new MidletSuiteProject(javaProject);
                    midletSuiteMap.put(javaProject, suite);
                }
            }
        }
        finally {
            accessSuiteMapSemaphore.release();
        }
        return suite;
    }

    private static boolean hasMTJNature(IProject project) throws CoreException {
        if (!project.exists()) {
            return false;
        }
        if (project.isOpen()) {
            return project.hasNature("org.eclipse.mtj.core.nature");
        }
        return project.getWorkspace().loadProjectDescription(project.getLocation().append("/.project")).hasNature("org.eclipse.mtj.core.nature");
    }

    public static IMTJProject getMidletSuiteProject(String name) {
        IMidletSuiteProject suite = null;
        try {
            IProject project;
            if (name != null && MidletSuiteFactory.hasMTJNature(project = ResourcesPlugin.getWorkspace().getRoot().getProject(name))) {
                suite = MidletSuiteFactory.getMidletSuiteProject(JavaCore.create((IProject)project));
            }
        }
        catch (CoreException e) {
            MTJLogger.log(4, e);
        }
        return suite;
    }

    public static boolean isMidletSuiteProject(IProject project) {
        if (project == null) {
            return false;
        }
        IMTJProject mtjproject = MidletSuiteFactory.getMidletSuiteProject(project.getName());
        return mtjproject != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMidletSuiteProject(IJavaProject javaProject) {
        Map<IJavaProject, IMidletSuiteProject> map = midletSuiteMap;
        synchronized (map) {
            midletSuiteMap.remove(javaProject);
        }
    }

    private MidletSuiteFactory() {
    }

    public static class DeviceRegistryListener
    implements IDeviceRegistryListener {
        public void deviceAdded(IDevice device) {
            for (IMTJProject midletSuiteProject : midletSuiteMap.values()) {
                MTJRuntimeList runtimeList = midletSuiteProject.getRuntimeList();
                for (MTJRuntime mtjRuntime : runtimeList) {
                    IDevice runtimeDevice = mtjRuntime.getDevice();
                    if (runtimeDevice == null || !runtimeDevice.getIdentifier().equals(device.getIdentifier())) continue;
                    mtjRuntime.setDevice(device);
                    if (!mtjRuntime.isActive()) continue;
                    try {
                        midletSuiteProject.refreshClasspath((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        MTJLogger.log(4, e);
                    }
                }
            }
        }

        public void deviceRemoved(IDevice device) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MidletSuiteCreationRunnable {
        private static final String BIN_FOLDER_NAME = "bin";
        private IMIDPDevice device;
        private String jadFileName;
        private IJavaProject javaProject;
        private boolean preprocessingEnable;
        private IProject project;
        private Map<String, String> properties;
        private boolean localizationEnable;
        private String propertiesFolderName;
        private String packageName;
        private boolean jmUnitSupportEnable;

        private MidletSuiteCreationRunnable(IProject project, IJavaProject javaProject, IMIDPDevice device, String jadFileName) {
            this.project = project;
            this.javaProject = javaProject;
            this.device = device;
            this.jadFileName = jadFileName;
        }

        public boolean isPreprocessingEnable() {
            return this.preprocessingEnable;
        }

        public boolean isLocalizationEnable() {
            return this.localizationEnable;
        }

        public boolean isJMUnitSupportEnable() {
            return this.jmUnitSupportEnable;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                IMidletSuiteProject suite = MidletSuiteFactory.getMidletSuiteProject(this.javaProject);
                this.createL10nData(suite, monitor);
                suite.setJadFileName(this.jadFileName);
                this.addNatures(monitor);
                this.setJavaProjectOptions(monitor);
                this.setProjectMetadata();
                this.createApplicationDescriptorInProject(monitor);
                this.setDeviceIntoActiveConfig(suite, this.device);
                suite.saveMetaData();
                suite.refreshClasspath(monitor);
                IJavaProject javaProject2 = suite.getJavaProject();
                IClasspathEntry[] iClasspathEntryArray = javaProject2.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry r = iClasspathEntryArray[n2];
                    System.out.println(r.getPath().toString());
                    ++n2;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }

        private void createL10nData(IMidletSuiteProject suite, IProgressMonitor monitor) throws CoreException, IOException {
            IProject project = suite.getProject();
            if (this.localizationEnable) {
                IFolder newSource = project.getFolder(this.propertiesFolderName);
                if (!newSource.exists()) {
                    newSource.create(true, true, monitor);
                }
                project.refreshLocal(1, monitor);
                ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
                entries.addAll(Arrays.asList(this.javaProject.getRawClasspath()));
                IClasspathEntry[] array = entries.toArray(new IClasspathEntry[entries.size()]);
                if (!this.javaProject.hasClasspathCycle(array)) {
                    this.javaProject.setRawClasspath(array, monitor);
                }
                IResource[] sources = Utils.getSourceFolders(this.javaProject);
                int i = 0;
                while (i < sources.length) {
                    IPackageFragmentRoot source = this.javaProject.getPackageFragmentRoot(sources[i]);
                    if (source.exists()) {
                        IPackageFragment packageFragment = source.createPackageFragment(this.packageName, true, monitor);
                        L10nApi.createLocalizationFile(project, newSource.getProjectRelativePath(), (IJavaElement)packageFragment);
                        this.javaProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        L10nApi.createLocalizationApi(project, packageFragment, newSource.getProjectRelativePath());
                        this.javaProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        break;
                    }
                    ++i;
                }
            }
        }

        public void setPreprocessingEnable(boolean preprocessEnable) {
            this.preprocessingEnable = preprocessEnable;
        }

        public void setLocalizationEnabled(boolean localizationEnable) {
            this.localizationEnable = localizationEnable;
        }

        public void setJMUnitSupport(boolean jmUnitSupportEnable) {
            this.jmUnitSupportEnable = jmUnitSupportEnable;
        }

        private boolean addNatureIfNecessary(ArrayList<String> natures, String nature) {
            boolean added = false;
            if (!natures.contains(nature)) {
                natures.add(nature);
                added = true;
            }
            return added;
        }

        private void addNatures(IProgressMonitor monitor) throws CoreException {
            IProjectDescription desc = this.project.getDescription();
            ArrayList<String> natures = new ArrayList<String>(Arrays.asList(desc.getNatureIds()));
            boolean updated = this.addNatureIfNecessary(natures, "org.eclipse.mtj.core.nature");
            updated |= this.addNatureIfNecessary(natures, "org.eclipse.jdt.core.javanature");
            if (this.isPreprocessingEnable()) {
                updated |= this.addNatureIfNecessary(natures, "org.eclipse.mtj.core.preprocessingNature");
            }
            if (this.isLocalizationEnable()) {
                updated |= this.addNatureIfNecessary(natures, "org.eclipse.mtj.core.l10nNature");
            }
            if (this.isJMUnitSupportEnable()) {
                updated |= this.addNatureIfNecessary(natures, "org.eclipse.mtj.jmunit.jmunitNature");
            }
            if (updated) {
                SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 1);
                desc.setNatureIds(natures.toArray(new String[natures.size()]));
                this.project.setDescription(desc, (IProgressMonitor)submonitor);
            }
        }

        private void setDeviceIntoActiveConfig(IMidletSuiteProject suite, IDevice device) {
            MTJRuntimeList configurations = suite.getRuntimeList();
            MTJRuntime activeConfig = configurations.getActiveMTJRuntime();
            if (activeConfig != null) {
                activeConfig.setDevice(device);
                return;
            }
            if (activeConfig == null && !configurations.isEmpty()) {
                activeConfig = (MTJRuntime)configurations.get(0);
            }
            if (activeConfig == null) {
                activeConfig = new MTJRuntime(device.getName());
                activeConfig.setSymbolSet(device.getSymbolSet());
            }
            activeConfig.setActive(true);
            activeConfig.setDevice(device);
            configurations.add(activeConfig);
        }

        private void createApplicationDescriptorInProject(IProgressMonitor monitor) throws CoreException, IOException {
            IMidletSuiteProject midletSuite = MidletSuiteFactory.getMidletSuiteProject(this.javaProject);
            IFile jadFile = midletSuite.getApplicationDescriptorFile();
            if (!jadFile.exists()) {
                InputStream is = this.getJADFileSource(midletSuite);
                jadFile.create(is, true, monitor);
            }
        }

        private ColonDelimitedProperties getDefaultApplicationDescriptorProperties(IMidletSuiteProject suite) {
            ColonDelimitedProperties descriptor = new ColonDelimitedProperties();
            if (this.properties != null) {
                if (this.properties.get("MIDlet-Name") == null && this.properties.get("LIBlet-Name") != null) {
                    descriptor.setProperty("LIBlet-Name", this.properties.get("LIBlet-Name"));
                    descriptor.setProperty("LIBlet-Vendor", this.properties.get("LIBlet-Vendor"));
                    descriptor.setProperty("LIBlet-Version", this.properties.get("LIBlet-Version"));
                    descriptor.setProperty("LIBlet-Jar-URL", suite.getJarFilename());
                } else {
                    descriptor.setProperty("MIDlet-Name", this.properties.get("MIDlet-Name"));
                    descriptor.setProperty("MIDlet-Vendor", this.properties.get("MIDlet-Vendor"));
                    descriptor.setProperty("MIDlet-Version", this.properties.get("MIDlet-Version"));
                    descriptor.setProperty("MIDlet-Jar-URL", suite.getJarFilename());
                }
                descriptor.setProperty("MicroEdition-Configuration", this.properties.get("MicroEdition-Configuration"));
                descriptor.setProperty("MicroEdition-Profile", this.properties.get("MicroEdition-Profile"));
            }
            return descriptor;
        }

        private InputStream getJADFileSource(IMidletSuiteProject midletSuite) throws IOException, CoreException {
            IFile jadFile;
            InputStream is = null;
            String jadName = midletSuite.getJadFileName();
            IFolder folder = this.project.getFolder(BIN_FOLDER_NAME);
            if (folder.exists() && (jadFile = folder.getFile(jadName)).exists()) {
                is = jadFile.getContents();
            }
            if (is == null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ColonDelimitedProperties defaultProps = this.getDefaultApplicationDescriptorProperties(midletSuite);
                defaultProps.store(bos, "");
                is = new ByteArrayInputStream(bos.toByteArray());
            }
            return is;
        }

        private void setJavaProjectOptions(IProgressMonitor monitor) {
            boolean forceJava = PreferenceAccessor.instance.getBoolean("force_java11");
            if (forceJava) {
                Map options = this.javaProject.getOptions(true);
                Configuration deviceConfiguration = null;
                if (this.properties != null) {
                    String deviceConfigurationStr = this.properties.get("MicroEdition-Configuration");
                    Configuration[] configurationArray = Configuration.values();
                    int n = configurationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Configuration candidate = configurationArray[n2];
                        if (candidate.toString().equals(deviceConfigurationStr)) {
                            deviceConfiguration = candidate;
                            break;
                        }
                        ++n2;
                    }
                }
                boolean requiresJava7Compliance = deviceConfiguration != null && Configuration.CLDC_18.getVersion().compareTo(deviceConfiguration.getVersion()) <= 0;
                JavaCore.setComplianceOptions((String)(requiresJava7Compliance ? "1.7" : "1.3"), (Map)options);
                this.javaProject.setOptions(options);
            }
        }

        private void setProjectMetadata() throws CoreException {
            IMidletSuiteProject midletprj = MidletSuiteFactory.getMidletSuiteProject(this.javaProject);
            midletprj.saveMetaData();
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public void setPropertiesFolderName(String propertiesFolderName) {
            this.propertiesFolderName = propertiesFolderName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }
    }
}

