/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidLetsCollector {
    public static Set<IType> collectMidletsInPackage(IPackageFragment packageFragment, IProgressMonitor monitor) {
        HashSet<IType> result = new HashSet<IType>();
        List<IType> midlets = MidLetsCollector.collectMidletsInProject(monitor, packageFragment.getJavaProject());
        for (IType midlet : midlets) {
            if (!midlet.getPackageFragment().equals(packageFragment)) continue;
            result.add(midlet);
        }
        return result;
    }

    public static List<IType> collectMidletsInProject(IProgressMonitor monitor, IJavaProject project) {
        HashSet<IType> result = new HashSet<IType>(5);
        try {
            IType midlet = project.findType("javax.microedition.midlet.MIDlet");
            ITypeHierarchy hierarchy = midlet.newTypeHierarchy(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IType[] types = hierarchy.getAllSubtypes(midlet);
            int length = types.length;
            if (length != 0) {
                int i = 0;
                while (i < length) {
                    if (!types[i].isBinary()) {
                        result.add(types[i]);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        monitor.done();
        return new ArrayList<IType>(result);
    }
}

