/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.ISDKProvider;
import org.eclipse.mtj.internal.core.sdk.ISDKProviderRegistryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDKProviderRegistry
implements IRegistryChangeListener {
    private static SDKProviderRegistry instance;
    protected Set<ISDKProvider> sdkProviders;
    protected ArrayList<ISDKProviderRegistryListener> listenerList = new ArrayList();

    public static synchronized SDKProviderRegistry getInstance() {
        if (instance == null) {
            instance = new SDKProviderRegistry();
        }
        return instance;
    }

    private SDKProviderRegistry() {
        RegistryFactory.getRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public synchronized void addListener(ISDKProviderRegistryListener listener) {
        this.listenerList.add(listener);
    }

    public synchronized void removeListener(ISDKProviderRegistryListener listener) {
        this.listenerList.remove(listener);
    }

    public synchronized List<ISDKProvider> getSDKProviders() {
        this.initialize();
        return new ArrayList<ISDKProvider>(this.sdkProviders);
    }

    public synchronized int getSDKProviderCount() {
        this.initialize();
        return this.sdkProviders.size();
    }

    protected void initialize() {
        if (this.sdkProviders == null) {
            this.sdkProviders = new TreeSet<ISDKProvider>();
            this.readSdkProviders(false);
        }
    }

    protected synchronized void refresh() {
        if (this.sdkProviders == null) {
            this.sdkProviders = new TreeSet<ISDKProvider>();
            this.readSdkProviders(true);
        }
    }

    protected void readSdkProviders(boolean fireNotification) {
        IConfigurationElement[] providerExtensions;
        String pluginId = MTJCore.getMTJCore().getBundle().getSymbolicName();
        if (pluginId == null) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        TreeSet<ISDKProvider> foundProviders = new TreeSet<ISDKProvider>();
        IConfigurationElement[] iConfigurationElementArray = providerExtensions = registry.getConfigurationElementsFor(pluginId, "sdkprovider");
        int n = providerExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement providerExtension = iConfigurationElementArray[n2];
            try {
                ISDKProvider sdkProvider = (ISDKProvider)providerExtension.createExecutableExtension("class");
                foundProviders.add(sdkProvider);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        TreeSet<ISDKProvider> providersToAdd = new TreeSet<ISDKProvider>((Collection<ISDKProvider>)foundProviders);
        providersToAdd.removeAll(this.sdkProviders);
        TreeSet<ISDKProvider> providersToRemove = new TreeSet<ISDKProvider>((Collection<ISDKProvider>)foundProviders);
        providersToRemove.removeAll(providersToAdd);
        this.addSDKProviders(providersToAdd, fireNotification);
        this.removeSDKProviders(providersToRemove, fireNotification);
    }

    protected synchronized void addSDKProviders(Set<ISDKProvider> providersToAdd, boolean fireNotification) throws IllegalArgumentException {
        if (providersToAdd == null) {
            throw new IllegalArgumentException();
        }
        if (!providersToAdd.isEmpty()) {
            this.sdkProviders.addAll(providersToAdd);
            if (fireNotification) {
                this.fireSDKProvidersAddedEvent(providersToAdd);
            }
        }
    }

    protected synchronized void removeSDKProviders(Set<ISDKProvider> providersToRemove, boolean fireNotification) throws IllegalArgumentException {
        if (providersToRemove == null) {
            throw new IllegalArgumentException();
        }
        if (!providersToRemove.isEmpty()) {
            this.sdkProviders.removeAll(providersToRemove);
            if (fireNotification) {
                this.fireSDKProvidersRemovedEvent(providersToRemove);
            }
        }
    }

    protected synchronized void fireSDKProvidersAddedEvent(final Set<ISDKProvider> providers) {
        for (final ISDKProviderRegistryListener listener : this.listenerList) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    listener.sdkProvidersAdded(providers);
                }
            });
            t.start();
        }
    }

    protected synchronized void fireSDKProvidersRemovedEvent(final Set<ISDKProvider> providers) {
        for (final ISDKProviderRegistryListener listener : this.listenerList) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    listener.sdkProvidersRemoved(providers);
                }
            });
            t.start();
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
        this.refresh();
    }
}

