/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceFinder;
import org.eclipse.mtj.core.sdk.device.IDeviceImporter;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.sdk.device.DeviceImporterElement;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceFinder
implements IDeviceFinder,
IRegistryChangeListener {
    private static Map<String, IDeviceImporter> deviceImportersMap;
    private static DeviceFinder finder;

    static {
        finder = null;
    }

    public static synchronized IDeviceFinder getInstance() {
        if (finder == null) {
            finder = new DeviceFinder();
            Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)finder);
        }
        return finder;
    }

    private DeviceFinder() {
        deviceImportersMap = Collections.synchronizedMap(new HashMap());
        try {
            this.readDeviceImporters();
        }
        catch (CoreException e) {
            MTJLogger.log(4, Messages.DeviceFinder_0, e);
        }
    }

    @Override
    public synchronized List<IDevice> findDevices(File directory, IProgressMonitor monitor) throws CoreException, InterruptedException {
        ArrayList<IDevice> foundDevices = new ArrayList<IDevice>();
        try {
            monitor.beginTask(Messages.DeviceFinder_1, -1);
            HashMap<Class<? extends IDeviceImporter>, Map<File, Object>> importersCollectedData = new HashMap<Class<? extends IDeviceImporter>, Map<File, Object>>();
            Iterator<Map.Entry<String, IDeviceImporter>> iterator = deviceImportersMap.entrySet().iterator();
            while (iterator.hasNext()) {
                List<IDevice> list = this.searchDevicesInDirectory(directory, iterator.next().getValue(), importersCollectedData, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (list == null) continue;
                foundDevices.addAll(list);
            }
        }
        finally {
            monitor.done();
        }
        return foundDevices;
    }

    @Override
    public synchronized List<IDevice> findDevices(String deviceImporterID, File directory, IProgressMonitor monitor) throws CoreException, InterruptedException {
        ArrayList<IDevice> foundDevices = new ArrayList<IDevice>();
        try {
            List<IDevice> list;
            IDeviceImporter deviceImporter;
            monitor.beginTask(Messages.DeviceFinder_1, -1);
            if (deviceImporterID != null && (deviceImporter = deviceImportersMap.get(deviceImporterID)) != null && (list = this.searchDevicesInDirectory(directory, deviceImporter, new HashMap<Class<? extends IDeviceImporter>, Map<File, Object>>(), (IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null) {
                foundDevices.addAll(list);
            }
        }
        finally {
            monitor.done();
        }
        return foundDevices;
    }

    private void readDeviceImporters() throws CoreException {
        IExtensionRegistry registry;
        IConfigurationElement[] elements;
        String pluginId;
        if (deviceImportersMap != null && (pluginId = MTJCore.getMTJCore().getBundle().getSymbolicName()) != null && (elements = (registry = Platform.getExtensionRegistry()).getConfigurationElementsFor(pluginId, "deviceimporter")).length >= 0) {
            DeviceImporterElement[] deviceElements = new DeviceImporterElement[elements.length];
            int i = 0;
            while (i < elements.length) {
                deviceElements[i] = new DeviceImporterElement(elements[i]);
                ++i;
            }
            Arrays.sort(deviceElements, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    DeviceImporterElement element1 = (DeviceImporterElement)o1;
                    DeviceImporterElement element2 = (DeviceImporterElement)o2;
                    return element1.getPriority() - element2.getPriority();
                }
            });
            i = 0;
            while (i < deviceElements.length) {
                deviceImportersMap.put(deviceElements[i].getId(), deviceElements[i].getDeviceImporter());
                ++i;
            }
        }
    }

    private List<IDevice> searchDevicesInDirectory(File directory, IDeviceImporter importer, Map<Class<? extends IDeviceImporter>, Map<File, Object>> importersCollectedData, IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        ArrayList<IDevice> foundDevices = null;
        try {
            if (directory.canRead()) {
                File[] subdirectories;
                foundDevices = new ArrayList<IDevice>();
                monitor.setTaskName(NLS.bind((String)Messages.DeviceFinder_2, (Object)directory));
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                List<IDevice> localFoundDevices = importer.importDevices(directory, importersCollectedData, (IProgressMonitor)subMonitor);
                if (localFoundDevices != null) {
                    foundDevices.addAll(localFoundDevices);
                }
                if ((subdirectories = directory.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                })) != null) {
                    File[] fileArray = subdirectories;
                    int n = subdirectories.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File element = fileArray[n2];
                        List<IDevice> subdirectFoundDevices = this.searchDevicesInDirectory(element, importer, importersCollectedData, monitor);
                        if (subdirectFoundDevices != null) {
                            foundDevices.addAll(subdirectFoundDevices);
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (SecurityException e) {
            MTJLogger.log(4, NLS.bind((String)Messages.DeviceFinder_3, (Object)directory.getPath()), e);
        }
        monitor.worked(1);
        return foundDevices;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        String pluginId = MTJCore.getMTJCore().getBundle().getSymbolicName();
        IExtensionDelta[] deltas = event.getExtensionDeltas(pluginId, "deviceimporter");
        int i = 0;
        while (i < deltas.length) {
            int j;
            DeviceImporterElement[] deviceElements;
            if (deltas[i].getKind() == 1) {
                try {
                    deviceElements = this.getDeviceImporterElements(deltas[i].getExtension());
                    j = 0;
                    while (j < deviceElements.length) {
                        deviceImportersMap.put(deviceElements[j].getId(), deviceElements[j].getDeviceImporter());
                        ++j;
                    }
                }
                catch (CoreException e) {
                    MTJLogger.log(4, e);
                }
            } else {
                deviceElements = this.getDeviceImporterElements(deltas[i].getExtension());
                j = 0;
                while (j < deviceElements.length) {
                    deviceImportersMap.remove(deviceElements[j].getId());
                    ++j;
                }
            }
            ++i;
        }
    }

    private DeviceImporterElement[] getDeviceImporterElements(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        DeviceImporterElement[] deviceElements = new DeviceImporterElement[elements.length];
        int j = 0;
        while (j < deviceElements.length) {
            deviceElements[j] = new DeviceImporterElement(elements[j]);
            ++j;
        }
        return deviceElements;
    }
}

