/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.device.IAPI;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.internal.core.Trace;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocDetector {
    private static final String ZIP_EXT = ".zip";
    private static final String PACKAGE_LIST = "package-list";

    public URL detectJavadoc(ILibrary library) {
        boolean trace = Trace.isOptionEnabled(Trace.JAVADOC_DETECT_PERF);
        long enterTime = 0L;
        if (trace) {
            enterTime = System.currentTimeMillis();
        }
        URL retURL = this.searchForJavaDoc(library);
        if (trace) {
            long elapsed = System.currentTimeMillis() - enterTime;
            Trace.trace(Trace.JAVADOC_DETECT_PERF, "Detected javadoc for ", library.toString(), " in ", elapsed, "ms");
        }
        return retURL;
    }

    private URL searchForJavaDoc(ILibrary library) {
        URL foundURL = null;
        File[] rootDirs = this.getDefaultDocRootDirectories(library);
        if (rootDirs != null) {
            File[] fileArray = rootDirs;
            int n = rootDirs.length;
            int n2 = 0;
            while (n2 < n) {
                File docDir = fileArray[n2];
                foundURL = this.searchForLibraryDoc(docDir, library);
                if (foundURL != null) break;
                ++n2;
            }
        }
        return foundURL;
    }

    private File[] getDefaultDocRootDirectories(ILibrary library) {
        if (library == null) {
            return null;
        }
        ArrayList<File> docfiles = new ArrayList<File>();
        File parentDir = library.toFile().getParentFile();
        int i = 0;
        while (i < 5 && parentDir != null) {
            File[] tmpDocfiles;
            File[] fileArray = tmpDocfiles = parentDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.getName().indexOf("doc") != -1;
                }
            });
            int n = tmpDocfiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                docfiles.add(file);
                ++n2;
            }
            parentDir = parentDir.getParentFile();
            ++i;
        }
        if (docfiles.size() > 0) {
            return docfiles.toArray(new File[0]);
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private URL searchForLibraryDoc(File parentDir, ILibrary library) {
        if (library instanceof IMIDPLibrary) {
            File[] javadocDirsOrZips = parentDir.listFiles(new FileFilter(){

                public boolean accept(File folder) {
                    File packageList;
                    File indexFile;
                    return folder.isDirectory() && (indexFile = new File(folder, "index.html")).isFile() && (packageList = new File(folder, JavadocDetector.PACKAGE_LIST)).isFile();
                }
            });
            if (javadocDirsOrZips.length == 0) {
                javadocDirsOrZips = parentDir.listFiles(new FileFilter(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public boolean accept(File file) {
                        if (!file.isFile()) return false;
                        if (!file.getName().toLowerCase().endsWith(JavadocDetector.ZIP_EXT)) return false;
                        try {
                            ZipFile zip = new ZipFile(file);
                            try {
                                ZipEntry indexEntry = zip.getEntry("index.html");
                                if (indexEntry == null) return false;
                                if (indexEntry.isDirectory()) return false;
                                ZipEntry packageListEntry = zip.getEntry(JavadocDetector.PACKAGE_LIST);
                                if (packageListEntry == null) return false;
                                if (packageListEntry.isDirectory()) return false;
                                return true;
                            }
                            finally {
                                zip.close();
                            }
                        }
                        catch (Throwable throwable) {
                            return false;
                        }
                    }
                });
            }
            if (javadocDirsOrZips.length > 0) {
                try {
                    JarFile jar = new JarFile(library.toFile());
                    try {
                        IMIDPLibrary midpLib = (IMIDPLibrary)library;
                        boolean mustHaveJavaLang = midpLib.hasProfile() || midpLib.hasConfiguration();
                        HashSet<String> expandedJarEntries = new HashSet<String>();
                        Enumeration<JarEntry> jarEntries = jar.entries();
                        while (jarEntries.hasMoreElements()) {
                            File entryFile = new File(jarEntries.nextElement().getName());
                            while (entryFile != null) {
                                entryFile = expandedJarEntries.add(entryFile.getPath().replace(File.separator, "/")) ? entryFile.getParentFile() : null;
                            }
                        }
                        Trace.trace(Trace.JAVADOC_DETECT_DEBUG, "Searching javadocs for ", midpLib);
                        File detected = null;
                        int i = 0;
                        while (i < javadocDirsOrZips.length) {
                            String packagesListName;
                            BufferedReader reader;
                            ZipFile javadocsZip = null;
                            File javadocDirOrZip = javadocDirsOrZips[i];
                            if (javadocDirOrZip.isDirectory()) {
                                File pList = new File(javadocDirOrZip, PACKAGE_LIST);
                                reader = new BufferedReader(new FileReader(pList));
                                packagesListName = pList.toString();
                            } else {
                                javadocsZip = new ZipFile(javadocDirOrZip);
                                reader = new BufferedReader(new InputStreamReader(javadocsZip.getInputStream(javadocsZip.getEntry(PACKAGE_LIST))));
                                packagesListName = String.valueOf(javadocDirOrZip.toString()) + File.separator + PACKAGE_LIST;
                            }
                            try {
                                if (this.detectByPackagesList(mustHaveJavaLang, expandedJarEntries, reader, packagesListName) || this.detectByLibraryFileName(library, javadocsZip, javadocDirOrZip)) {
                                    if (this.checkJavadocsVersion(midpLib, javadocsZip, javadocDirOrZip)) {
                                        Trace.trace(Trace.JAVADOC_DETECT_DEBUG, "Found javadocs for ", midpLib, " in ", javadocDirOrZip);
                                        URL uRL = this.getJavadocsURL(javadocDirOrZip);
                                        return uRL;
                                    }
                                    detected = javadocDirOrZip;
                                }
                            }
                            finally {
                                try {
                                    reader.close();
                                }
                                finally {
                                    if (javadocsZip != null) {
                                        javadocsZip.close();
                                    }
                                }
                            }
                            ++i;
                        }
                        if (detected != null) {
                            Trace.trace(Trace.JAVADOC_DETECT_DEBUG, "Found javadocs for ", midpLib, " in ", detected);
                            URL uRL = this.getJavadocsURL(detected);
                            return uRL;
                        }
                    }
                    finally {
                        jar.close();
                    }
                }
                catch (IOException e) {
                    MTJCore.getMTJCore().getLog().log((IStatus)new Status(2, MTJCore.getPluginId(), "Error while matchin javadocs", (Throwable)e));
                }
            }
            File[] subdirectories = parentDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            URL url = null;
            int i = 0;
            while (i < subdirectories.length && url == null) {
                url = this.searchForLibraryDoc(subdirectories[i], library);
                ++i;
            }
            return url;
        }
        return null;
    }

    private boolean detectByLibraryFileName(ILibrary library, ZipFile javadocsZip, File javadocDirOrZip) throws MalformedURLException {
        String libraryName;
        String libFileName = library.toFile().getName();
        int dotIdx = libFileName.lastIndexOf(46);
        String libName = dotIdx > -1 ? libFileName.substring(0, dotIdx) : libFileName;
        String pathName = this.getNormalizedJavadocsPathName(javadocsZip, javadocDirOrZip);
        return pathName.startsWith(libraryName = libName.toLowerCase().replace('_', '-')) || libraryName.startsWith(pathName);
    }

    private String getNormalizedJavadocsPathName(ZipFile javadocsZip, File javadocDirOrZip) {
        String result = javadocDirOrZip.getName().toLowerCase().replace('_', '-');
        if (javadocsZip != null && result.endsWith(ZIP_EXT)) {
            result = result.substring(0, result.length() - ZIP_EXT.length());
        }
        return result;
    }

    private boolean checkJavadocsVersion(IMIDPLibrary library, ZipFile javadocsZip, File javadocDirOrZip) {
        Version javadocsVersion;
        List<? extends IAPI> apis = library.getAPIs();
        if (apis == null) {
            return true;
        }
        String pathName = this.getNormalizedJavadocsPathName(javadocsZip, javadocDirOrZip);
        int versionIdx = pathName.lastIndexOf(45) + 1;
        if (versionIdx <= 0 || versionIdx >= pathName.length()) {
            return true;
        }
        try {
            javadocsVersion = new Version(pathName.substring(versionIdx).trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        for (IAPI iAPI : apis) {
            if (javadocsVersion.compareTo(iAPI.getVersion()) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean detectByPackagesList(boolean mustHaveJavaLang, Set<String> expandedJarEntries, BufferedReader packagesListReader, String packagesListName) throws IOException {
        boolean foundJavaLang = false;
        boolean found = false;
        String s = packagesListReader.readLine();
        while (s != null) {
            if (s.startsWith("#")) {
                s = packagesListReader.readLine();
                continue;
            }
            if (mustHaveJavaLang && !foundJavaLang && "java.lang".equals(s.trim())) {
                Trace.trace(Trace.JAVADOC_DETECT_DEBUG, "java.lang entry found in line ", s, " package-list is ", packagesListName);
                foundJavaLang = true;
            }
            if (!expandedJarEntries.contains(s.replace('.', '/'))) {
                found = false;
                break;
            }
            s = packagesListReader.readLine();
            found = true;
            if (!mustHaveJavaLang || foundJavaLang) continue;
            found = false;
        }
        return found;
    }

    private URL getJavadocsURL(File javadocDirOrZip) throws MalformedURLException {
        if (javadocDirOrZip.isDirectory()) {
            return javadocDirOrZip.toURI().toURL();
        }
        try {
            return new URI("jar:" + javadocDirOrZip.toURI().toString() + "!/").toURL();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

