/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.security.meep;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mtj.internal.core.security.meep.JarFileDataAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LibraryJarClassLoader
extends ClassLoader {
    private Map<File, JarFileDataAccessor> accessors = new HashMap<File, JarFileDataAccessor>();

    public void addJarFile(File jarFile) {
        if (jarFile.isFile() && jarFile.exists() && !this.accessors.containsKey(jarFile) && jarFile.getName().endsWith(".jar")) {
            try {
                JarFileDataAccessor accessor = new JarFileDataAccessor(jarFile);
                this.accessors.put(jarFile, accessor);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Package pkg;
        byte[] data;
        try {
            data = this.getClassData(name);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("Could not find class " + name, ex);
        }
        if (data == null) {
            throw new ClassNotFoundException("Could not find class " + name);
        }
        Class<?> clazz = this.defineClass(name, data, 0, data.length);
        String pkgName = this.extractPackageName(name);
        if (pkgName != null && (pkg = this.getPackage(pkgName)) == null) {
            this.definePackage(pkgName, null, null, null, null, null, null, null);
        }
        return clazz;
    }

    private String extractPackageName(String fqnName) {
        int idx = fqnName.lastIndexOf(46);
        return idx >= 0 ? fqnName.substring(0, idx) : null;
    }

    private byte[] getClassData(String name) throws IOException {
        String classEntryName = String.valueOf(name.replace('.', '/')) + ".class";
        for (JarFileDataAccessor accessor : this.accessors.values()) {
            if (!accessor.hasEntry(classEntryName)) continue;
            return accessor.getEntryData(classEntryName);
        }
        return null;
    }

    @Override
    public URL findResource(String name) {
        try {
            Enumeration<URL> resources = this.findResources(name);
            return resources.hasMoreElements() ? resources.nextElement() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (JarFileDataAccessor accessor : this.accessors.values()) {
            URL u;
            if (!accessor.hasEntry(name) || (u = accessor.getEntryURL(name)) == null) continue;
            result.add(u);
        }
        return Collections.enumeration(result);
    }
}

