/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.security.meep;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.internal.core.security.meep.LibraryJarClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MEEPPermissionsProvider {
    private static final String BASE_CLASS_NAME = "java.security.Permission";
    private static final String IMPNG_PERMISSIONS_FILE_NAME = "impng.permissions";
    private static final String NULL_PARAMETER = "null";
    private static final String NO_PARAMETER = "\"";
    private Map<String, PermissionDescriptor> permissions;
    private ISDK sdk;

    public MEEPPermissionsProvider(ISDK sdk) {
        this.sdk = sdk;
        this.fill(sdk);
    }

    public ISDK getSDK() {
        return this.sdk;
    }

    private void listClasses(File jarFilePointer, Set<String> allClassesNames) {
        try {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(jarFilePointer);
                Enumeration<JarEntry> jarEntryEnum = jarFile.entries();
                while (jarEntryEnum.hasMoreElements()) {
                    JarEntry jarEntry = jarEntryEnum.nextElement();
                    String entryName = jarEntry.getName();
                    if (jarEntry.isDirectory() || entryName == null || !entryName.endsWith(".class")) continue;
                    allClassesNames.add(entryName.substring(0, entryName.lastIndexOf(46)).replace('/', '.').replace('$', '.'));
                }
            }
            finally {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
        }
        catch (Throwable throwable) {}
    }

    private void loadIMPNGPermissions(Set<File> libDirs) {
        for (File libDir : libDirs) {
            File permissionsFile = new File(libDir, IMPNG_PERMISSIONS_FILE_NAME);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(permissionsFile), "UTF-8"));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                        this.permissions.put(line, new PermissionDescriptor(line, false));
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private void fill(ISDK sdk) {
        this.permissions = new HashMap<String, PermissionDescriptor>();
        HashSet<File> libs = new HashSet<File>();
        HashSet<File> libDirs = new HashSet<File>();
        if (sdk != null) {
            List<IDevice> devices;
            try {
                devices = sdk.getDeviceList();
            }
            catch (Throwable throwable) {
                devices = null;
            }
            if (devices != null) {
                for (IDevice device : devices) {
                    List<ILibrary> libraries;
                    IDeviceClasspath deviceCP = device.getClasspath();
                    if (deviceCP == null || (libraries = deviceCP.getEntries()) == null) continue;
                    for (ILibrary library : libraries) {
                        File libFile;
                        if (library == null || (libFile = library.toFile()) == null) continue;
                        File libDir = libFile.getParentFile();
                        if (libDir != null) {
                            libDirs.add(libDir);
                        }
                        if (!libFile.isFile() || !libFile.getName().toLowerCase().endsWith(".jar")) continue;
                        libs.add(libFile);
                    }
                }
            }
        }
        this.loadIMPNGPermissions(libDirs);
        this.loadMEEPPermissions(libs);
    }

    private void loadMEEPPermissions(Set<File> libs) {
        Class<?> baseClass;
        HashSet<String> allClassNames = new HashSet<String>();
        LibraryJarClassLoader classLoader = new LibraryJarClassLoader();
        for (File libFile : libs) {
            try {
                classLoader.addJarFile(libFile);
                this.listClasses(libFile, allClassNames);
            }
            catch (Throwable throwable) {}
        }
        try {
            baseClass = classLoader.loadClass(BASE_CLASS_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            baseClass = null;
        }
        if (baseClass != null) {
            for (String className : allClassNames) {
                try {
                    Class<?> candidate = classLoader.loadClass(className);
                    if (Modifier.isAbstract(candidate.getModifiers()) || !baseClass.isAssignableFrom(candidate)) continue;
                    PermissionDescriptor descriptor = new PermissionDescriptor(className, true);
                    Constructor<?>[] constructors = candidate.getConstructors();
                    if (constructors != null) {
                        Constructor<?>[] constructorArray = constructors;
                        int n = constructors.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Constructor<?> constructor = constructorArray[n2];
                            Class<?>[] parameterTypes = constructor.getParameterTypes();
                            if (parameterTypes != null && parameterTypes.length <= 2) {
                                boolean accept = true;
                                int i = 0;
                                while (i < parameterTypes.length && accept) {
                                    accept &= parameterTypes[i] == String.class;
                                    ++i;
                                }
                                if (accept) {
                                    descriptor.numberOfSupportedArgumentes.add(parameterTypes.length);
                                }
                            }
                            ++n2;
                        }
                    }
                    if (descriptor.numberOfSupportedArgumentes.isEmpty()) continue;
                    this.permissions.put(className, descriptor);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public PermissionsFactory getPermissionsFactory(Collection<String> excludePermissions) {
        return new PermissionsFactory(excludePermissions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PermissionDefinition
    implements Comparable<PermissionDefinition> {
        private String permission;
        private String name;
        private LinkedHashSet<String> actions = new LinkedHashSet();
        private boolean permissionClass;
        private int numberOfParameters;

        private PermissionDefinition(String permission, String name, String actions, boolean permissionClass, int numberOfParameters) {
            this.permission = permission;
            this.name = name;
            this.permissionClass = permissionClass;
            this.numberOfParameters = numberOfParameters;
            if (numberOfParameters > 1) {
                this.parseActions(actions);
            }
        }

        private void parseActions(String actionsString) {
            if (actionsString != null) {
                String[] stringArray = actionsString.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String action = stringArray[n2];
                    this.actions.add(action.trim());
                    ++n2;
                }
            }
        }

        public String getPermission() {
            return this.permission;
        }

        private Set<String> getActionsSet() {
            return this.actions;
        }

        public String getName() {
            return this.name;
        }

        public int getNumberOfParameters() {
            return this.numberOfParameters;
        }

        public String getActions() {
            if (this.numberOfParameters < 2 || this.actions.isEmpty()) {
                return null;
            }
            StringBuilder result = new StringBuilder();
            for (String action : this.actions) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(action);
            }
            return result.toString();
        }

        public boolean isPermissionClass() {
            return this.permissionClass;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.permission);
            if (this.isPermissionClass() && this.numberOfParameters > 0) {
                result.append(" ");
                if (this.name == null) {
                    result.append(MEEPPermissionsProvider.NULL_PARAMETER);
                } else {
                    result.append(MEEPPermissionsProvider.NO_PARAMETER);
                    result.append(this.name);
                    result.append(MEEPPermissionsProvider.NO_PARAMETER);
                }
                String actionsString = this.getActions();
                if (this.numberOfParameters > 1) {
                    result.append(" ");
                    if (actionsString == null) {
                        result.append(MEEPPermissionsProvider.NULL_PARAMETER);
                    } else {
                        result.append(MEEPPermissionsProvider.NO_PARAMETER);
                        result.append(actionsString);
                        result.append(MEEPPermissionsProvider.NO_PARAMETER);
                    }
                }
            }
            return result.toString();
        }

        @Override
        public int compareTo(PermissionDefinition o) {
            return Collator.getInstance().compare(this.toString(), o.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PermissionDescriptor
    implements Comparable<PermissionDescriptor> {
        private String permission;
        private boolean permissionClass;
        private Set<Integer> numberOfSupportedArgumentes = new HashSet<Integer>();

        private PermissionDescriptor(String permission, boolean permissionClass) {
            this.permission = permission;
            this.permissionClass = permissionClass;
        }

        public boolean isPermissionClass() {
            return this.permissionClass;
        }

        public String getPermission() {
            return this.permission;
        }

        public String toString() {
            return this.getPermission();
        }

        @Override
        public int compareTo(PermissionDescriptor o) {
            return Collator.getInstance().compare(this.getPermission(), o.getPermission());
        }

        public int hashCode() {
            return this.getPermission().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PermissionDescriptor) {
                return this.getPermission().equals(((PermissionDescriptor)obj).getPermission());
            }
            return false;
        }

        public boolean supportsName() {
            return this.numberOfSupportedArgumentes.contains(1) || this.numberOfSupportedArgumentes.contains(2);
        }

        public boolean supportsAction() {
            return this.numberOfSupportedArgumentes.contains(2);
        }

        public boolean nameCanBeOptional() {
            return this.numberOfSupportedArgumentes.contains(0);
        }

        public boolean actionsCanBeOptional(boolean nameRequired) {
            return this.numberOfSupportedArgumentes.contains(nameRequired ? 1 : 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PermissionError {
        OK,
        INVALID_NAME,
        INVALID_ACTION,
        UNDEFINED_ACTION,
        UNDEFINED_NAME,
        CONFLICT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PermissionsFactory {
        private Map<String, Map<String, Set<String>>> existingMEEPPermissions = new HashMap<String, Map<String, Set<String>>>();
        private PermissionDescriptor[] availablePermissions;

        private PermissionsFactory(Collection<String> excludePermissions) {
            if (excludePermissions == null) {
                excludePermissions = Collections.emptySet();
            }
            HashSet<String> excludePermissionNames = new HashSet<String>();
            for (String excludePermission : excludePermissions) {
                PermissionDescriptor descriptor;
                String[] permissionComponents = this.splitPermissionComponents(excludePermission);
                if (permissionComponents == null || (descriptor = (PermissionDescriptor)MEEPPermissionsProvider.this.permissions.get(permissionComponents[0])) == null) continue;
                String permission = descriptor.getPermission();
                if (descriptor.isPermissionClass()) {
                    Set<String> existingActions;
                    if (!descriptor.supportsName()) {
                        excludePermissionNames.add(permission);
                        continue;
                    }
                    Map<String, Set<String>> existingNames = this.existingMEEPPermissions.get(permission);
                    if (existingNames == null) {
                        existingNames = new HashMap<String, Set<String>>();
                        this.existingMEEPPermissions.put(permission, existingNames);
                    }
                    if ((existingActions = existingNames.get(permissionComponents[1])) == null) {
                        existingActions = new HashSet<String>();
                        existingNames.put(permissionComponents[1], existingActions);
                    }
                    if (permissionComponents[2] == null) {
                        existingActions.add(null);
                        continue;
                    }
                    String[] stringArray = permissionComponents[2].split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String action = stringArray[n2];
                        existingActions.add(action.trim());
                        ++n2;
                    }
                    continue;
                }
                excludePermissionNames.add(permission);
            }
            ArrayList<PermissionDescriptor> avilablePermissionsList = new ArrayList<PermissionDescriptor>();
            for (PermissionDescriptor permissionDescriptor : MEEPPermissionsProvider.this.permissions.values()) {
                if (excludePermissionNames.contains(permissionDescriptor.getPermission())) continue;
                avilablePermissionsList.add(permissionDescriptor);
            }
            Collections.sort(avilablePermissionsList);
            this.availablePermissions = avilablePermissionsList.toArray(new PermissionDescriptor[avilablePermissionsList.size()]);
        }

        public PermissionDescriptor getDescriptor(PermissionDefinition permission) {
            return (PermissionDescriptor)MEEPPermissionsProvider.this.permissions.get(permission.getPermission());
        }

        public PermissionDefinition getPermission(String permission) {
            PermissionDescriptor descriptor;
            String[] permissionComponents = this.splitPermissionComponents(permission);
            if (permissionComponents != null && (descriptor = (PermissionDescriptor)MEEPPermissionsProvider.this.permissions.get(permissionComponents[0])) != null) {
                int numberOfParameters = 0;
                if (descriptor.supportsName() && !MEEPPermissionsProvider.NO_PARAMETER.equals(permissionComponents[1])) {
                    ++numberOfParameters;
                    if (descriptor.supportsAction() && !MEEPPermissionsProvider.NO_PARAMETER.equals(permissionComponents[2])) {
                        ++numberOfParameters;
                    }
                }
                if (numberOfParameters == 0 && !descriptor.nameCanBeOptional() && descriptor.isPermissionClass()) {
                    return null;
                }
                if (numberOfParameters == 1 && !descriptor.actionsCanBeOptional(true)) {
                    return null;
                }
                return this.getPermissionWithoutValidation(descriptor, permissionComponents[1], permissionComponents[2], MEEPPermissionsProvider.NO_PARAMETER.equals(permissionComponents[2]) ? (MEEPPermissionsProvider.NO_PARAMETER.equals(permissionComponents[1]) ? 0 : 1) : 2);
            }
            return null;
        }

        private String[] splitPermissionComponents(String permission) {
            String[] stringArray = new String[3];
            stringArray[1] = MEEPPermissionsProvider.NO_PARAMETER;
            stringArray[2] = MEEPPermissionsProvider.NO_PARAMETER;
            String[] result = stringArray;
            int idx = permission.indexOf(32);
            if (idx < 0) {
                result[0] = permission.trim();
                permission = "";
            } else {
                result[0] = permission.substring(0, idx).trim();
                permission = permission.substring(idx).trim();
            }
            int i = 1;
            while (i < 3 && permission.length() > 0) {
                if (permission.startsWith(MEEPPermissionsProvider.NO_PARAMETER)) {
                    idx = permission.indexOf(34, 1);
                    if (idx < 0) {
                        return null;
                    }
                    result[i] = permission.substring(1, idx);
                    permission = permission.substring(idx + 1).trim();
                } else {
                    if (!permission.startsWith(MEEPPermissionsProvider.NULL_PARAMETER)) {
                        return null;
                    }
                    idx = permission.indexOf(32);
                    result[i] = null;
                    if (idx < 0) {
                        if (MEEPPermissionsProvider.NULL_PARAMETER.length() < permission.length()) {
                            return null;
                        }
                        permission = "";
                    } else {
                        if (idx != MEEPPermissionsProvider.NULL_PARAMETER.length()) {
                            return null;
                        }
                        permission = permission.substring(idx).trim();
                    }
                }
                ++i;
            }
            return result;
        }

        public PermissionDescriptor[] getAvailablePermissions() {
            return this.availablePermissions;
        }

        public PermissionError validatePermission(PermissionDescriptor descriptor, String name, String actions, int numberOfParameters) {
            if (descriptor.isPermissionClass()) {
                Set<String> existingActions;
                PermissionDefinition permission;
                Map<String, Set<String>> existingNames;
                if (numberOfParameters > 0) {
                    if (descriptor.supportsName()) {
                        if (name != null && name.indexOf(34) >= 0) {
                            return PermissionError.INVALID_NAME;
                        }
                        if (numberOfParameters > 1) {
                            if (descriptor.supportsAction() && actions != null && actions.indexOf(34) >= 0) {
                                return PermissionError.INVALID_ACTION;
                            }
                        } else if (!descriptor.numberOfSupportedArgumentes.contains(1)) {
                            return PermissionError.UNDEFINED_ACTION;
                        }
                    }
                } else if (!descriptor.numberOfSupportedArgumentes.contains(0)) {
                    return PermissionError.UNDEFINED_NAME;
                }
                if ((existingNames = this.existingMEEPPermissions.get((permission = this.getPermissionWithoutValidation(descriptor, name, actions, numberOfParameters)).getPermission())) != null && (existingActions = existingNames.get(permission.getNumberOfParameters() > 0 ? permission.getName() : MEEPPermissionsProvider.NO_PARAMETER)) != null) {
                    Set definedActions = permission.getActionsSet();
                    if (definedActions.isEmpty()) {
                        if (existingActions.contains(null) && permission.getNumberOfParameters() > 1 || existingActions.contains(MEEPPermissionsProvider.NO_PARAMETER) && permission.getNumberOfParameters() < 2) {
                            return PermissionError.CONFLICT;
                        }
                    } else {
                        for (String action : definedActions) {
                            if (!existingActions.contains(action)) continue;
                            return PermissionError.CONFLICT;
                        }
                    }
                }
            }
            return PermissionError.OK;
        }

        private PermissionDefinition getPermissionWithoutValidation(PermissionDescriptor descriptor, String name, String actions, int numberOfParameters) {
            if (descriptor.isPermissionClass()) {
                boolean hasName = descriptor.supportsName() && numberOfParameters > 0;
                boolean hasAction = descriptor.supportsAction() && numberOfParameters > 1;
                return new PermissionDefinition(descriptor.getPermission(), hasName ? name : null, hasName && hasAction && actions != null ? actions.trim() : null, true, numberOfParameters);
            }
            return new PermissionDefinition(descriptor.getPermission(), null, null, false, 0);
        }

        public PermissionDefinition getPermission(PermissionDescriptor descriptor, String name, String actions, int numberOfParameters) {
            if (this.validatePermission(descriptor, name, actions, numberOfParameters) != PermissionError.OK) {
                return null;
            }
            return this.getPermissionWithoutValidation(descriptor, name, actions, numberOfParameters);
        }
    }
}

