/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.statemachine;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.statemachine.AbstractStateMachineEvent;
import org.eclipse.mtj.internal.core.statemachine.AbstractStateTransition;

public abstract class AbstractState {
    private List<AbstractStateTransition> transitions = new ArrayList<AbstractStateTransition>();
    private List<AbstractState> childStates;
    private AbstractState parent;
    private AbstractState intialChild;

    public AbstractState(AbstractState _parent) {
        this.parent = _parent;
        if (this.parent != null) {
            this.parent.addChildState(this);
        }
    }

    public final void addTransition(AbstractStateTransition _transition) {
        if (_transition == null) {
            throw new IllegalArgumentException(Messages.AbstractState_transitionNotNull);
        }
        if (_transition.getSource() == null) {
            throw new IllegalArgumentException(Messages.AbstractState_noSourceState);
        }
        if (_transition.getTarget() == null) {
            throw new IllegalArgumentException(Messages.AbstractState_noTargetState);
        }
        if (_transition.getSource() != this) {
            throw new IllegalArgumentException(Messages.AbstractState_invalidSourceState);
        }
        if (!this.transitions.contains(_transition)) {
            this.transitions.add(_transition);
        }
    }

    public final void removeTransition(AbstractStateTransition _transition) {
        this.transitions.remove(_transition);
    }

    public final void setInitialState(AbstractState _state) {
        if (_state == null) {
            throw new IllegalArgumentException(Messages.AbstractState_stateNotNull);
        }
        if (_state.getParent() != this) {
            throw new IllegalArgumentException(Messages.AbstractState_invalidInitialState);
        }
        this.intialChild = _state;
    }

    public final AbstractStateTransition[] getTransitions() {
        return this.transitions.toArray(new AbstractStateTransition[this.transitions.size()]);
    }

    protected abstract void onEnter();

    protected abstract void onExit();

    final synchronized void addChildState(AbstractState _state) {
        if (this.childStates == null) {
            this.childStates = new ArrayList<AbstractState>();
        }
        this.childStates.add(_state);
    }

    final AbstractState getParent() {
        return this.parent;
    }

    final synchronized AbstractState postEvent(AbstractStateMachineEvent _event) {
        AbstractStateTransition transition;
        AbstractStateTransition[] transitions;
        AbstractState nextState = null;
        ArrayList<AbstractStateTransition> candidates = new ArrayList<AbstractStateTransition>();
        AbstractStateTransition[] abstractStateTransitionArray = transitions = this.getTransitions();
        int n = transitions.length;
        int n2 = 0;
        while (n2 < n) {
            transition = abstractStateTransitionArray[n2];
            if (transition.isTransitionReady(_event)) {
                candidates.add(transition);
            }
            ++n2;
        }
        if (!candidates.isEmpty()) {
            if (candidates.size() > 1) {
                throw new IllegalStateException(Messages.AbstractState_conflictingTransitions);
            }
            transition = (AbstractStateTransition)candidates.get(0);
            nextState = transition.getTarget();
            transition.onTransition();
        }
        return nextState;
    }

    final void onEnterState() {
        this.onEnter();
        if (this.intialChild != null) {
            this.intialChild.onEnterState();
        }
    }

    final void onExitState() {
        this.onExit();
        if (this.intialChild != null) {
            this.intialChild.onExitState();
        }
    }
}

